/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import icbm.api.explosion.IExplosive;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions$;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.machinemuse.utils.ElectricItemUtils$;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class MuseElectricItem$class {
    public static double getCurrentEnergy(MuseElectricItem $this, ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY());
    }

    public static double getMaxEnergy(MuseElectricItem $this, ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, ElectricItemUtils$.MODULE$.MAXIMUM_ENERGY());
    }

    public static void setCurrentEnergy(MuseElectricItem $this, ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY(), Math.min(energy, $this.getMaxEnergy(stack)));
    }

    public static double drainEnergyFrom(MuseElectricItem $this, ItemStack stack, double requested) {
        double d;
        double available = $this.getCurrentEnergy(stack);
        if (available > requested) {
            $this.setCurrentEnergy(stack, available - requested);
            d = requested;
        } else {
            $this.setCurrentEnergy(stack, 0.0);
            d = available;
        }
        return d;
    }

    public static double giveEnergyTo(MuseElectricItem $this, ItemStack stack, double provided) {
        double d;
        double max;
        double available = $this.getCurrentEnergy(stack);
        if (available + provided < (max = $this.getMaxEnergy(stack))) {
            $this.setCurrentEnergy(stack, available + provided);
            d = provided;
        } else {
            $this.setCurrentEnergy(stack, max);
            d = max - available;
        }
        return d;
    }

    public static boolean canProvideEnergy(MuseElectricItem $this, ItemStack itemStack) {
        return true;
    }

    public static int getChargedItemId(MuseElectricItem $this, ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public static int getEmptyItemId(MuseElectricItem $this, ItemStack itemStack) {
        return itemStack.field_77993_c;
    }

    public static int getMaxCharge(MuseElectricItem $this, ItemStack itemStack) {
        return (int)ElectricConversions$.MODULE$.museEnergyToEU($this.getCurrentEnergy(itemStack));
    }

    public static int getTier(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.getTier(itemStack);
    }

    public static int getTransferLimit(MuseElectricItem $this, ItemStack itemStack) {
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(Math.sqrt($this.getMaxEnergy(itemStack)));
    }

    public static int charge(MuseElectricItem $this, ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : (double)$this.getTransferLimit(itemStack);
        double given = $this.giveEnergyTo(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(given);
    }

    public static int discharge(MuseElectricItem $this, ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : (double)$this.getTransferLimit(itemStack);
        double taken = $this.drainEnergyFrom(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return (int)ElectricConversions$.MODULE$.museEnergyToEU(taken);
    }

    public static boolean canUse(MuseElectricItem $this, ItemStack itemStack, int amount) {
        return ElectricConversions$.MODULE$.museEnergyFromEU(amount) < $this.getCurrentEnergy(itemStack);
    }

    public static boolean canShowChargeToolTip(MuseElectricItem $this, ItemStack itemStack) {
        return false;
    }

    public static void onEMP(MuseElectricItem $this, ItemStack itemStack, Entity entity, IExplosive empExplosive) {
        $this.setCurrentEnergy(itemStack, 0.0);
    }

    public static double getJoules(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToJoules($this.getCurrentEnergy(itemStack));
    }

    public static void setJoules(MuseElectricItem $this, double joules, ItemStack itemStack) {
        $this.setCurrentEnergy(itemStack, ElectricConversions$.MODULE$.museEnergyFromJoules(joules));
    }

    public static double getMaxJoules(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToJoules($this.getMaxEnergy(itemStack));
    }

    public static double getVoltage(MuseElectricItem $this, ItemStack itemStack) {
        return 120.0;
    }

    public static ElectricityPack onReceive(MuseElectricItem $this, ElectricityPack electricityPack, ItemStack itemStack) {
        double energyReceiving = ElectricConversions$.MODULE$.museEnergyFromElectricityPack(electricityPack);
        double energyConsumed = $this.giveEnergyTo(itemStack, energyReceiving);
        ElectricityPack packConsumed = ElectricConversions$.MODULE$.museEnergyToElectricityPack(energyConsumed, $this.getVoltage(itemStack));
        return packConsumed;
    }

    public static ElectricityPack onProvide(MuseElectricItem $this, ElectricityPack electricityPack, ItemStack itemStack) {
        double energyRequested = ElectricConversions$.MODULE$.museEnergyFromElectricityPack(electricityPack);
        double energyGiven = $this.drainEnergyFrom(itemStack, energyRequested);
        ElectricityPack packGiven = ElectricConversions$.MODULE$.museEnergyToElectricityPack(energyGiven, $this.getVoltage(itemStack));
        return packGiven;
    }

    public static ElectricityPack getReceiveRequest(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToElectricityPack($this.getMaxEnergy(itemStack) - $this.getCurrentEnergy(itemStack), $this.getVoltage(itemStack));
    }

    public static ElectricityPack getProvideRequest(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToElectricityPack($this.getMaxEnergy(itemStack) - $this.getCurrentEnergy(itemStack), $this.getVoltage(itemStack));
    }

    public static float receiveEnergy(MuseElectricItem $this, ItemStack theItem, float energy, boolean doReceive) {
        double current = $this.getCurrentEnergy(theItem);
        double receivedME = ElectricConversions$.MODULE$.museEnergyFromMJ(energy);
        double eatenME = $this.giveEnergyTo(theItem, receivedME);
        if (!doReceive) {
            $this.setCurrentEnergy(theItem, current);
        }
        return (float)ElectricConversions$.MODULE$.museEnergyToMJ(eatenME);
    }

    public static float transferEnergy(MuseElectricItem $this, ItemStack theItem, float energy, boolean doTransfer) {
        double current = $this.getCurrentEnergy(theItem);
        double requesteddME = ElectricConversions$.MODULE$.museEnergyFromMJ(energy);
        double takenME = $this.drainEnergyFrom(theItem, requesteddME);
        if (!doTransfer) {
            $this.setCurrentEnergy(theItem, current);
        }
        return (float)ElectricConversions$.MODULE$.museEnergyToMJ(takenME);
    }

    public static float getEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return (float)ElectricConversions$.MODULE$.museEnergyToMJ($this.getCurrentEnergy(theItem));
    }

    public static float getMaxEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return (float)ElectricConversions$.MODULE$.museEnergyToMJ($this.getMaxEnergy(theItem));
    }

    public static void $init$(MuseElectricItem $this) {
    }
}

