/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class Utils {
    private static final int MASKR = 0xFF0000;
    private static final int MASKG = 65280;
    private static final int MASKB = 255;
    public static final int GUIBACKGROUNDCOLOR = 0xC6C6C6;
    private static final int[] oX = new int[]{0, -1, 0, 1};
    private static final int[] oY = new int[]{-1, 0, 1, 0};

    public boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCenteredText(FontRenderer fr, String text, int xLoc, int yLoc, int color) {
        fr.func_78276_b(text, xLoc - fr.func_78256_a(text) / 2, yLoc, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRightAlignedText(FontRenderer fr, String text, int xLoc, int yLoc, int color) {
        fr.func_78276_b(text, xLoc - fr.func_78256_a(text), yLoc, color);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawLeftAlignedText(FontRenderer fr, String text, int xLoc, int yLoc, int color) {
        fr.func_78276_b(text, xLoc, yLoc, color);
    }

    public static int multiplyColorComponents(int color, float brightnessFactor) {
        return (int)(brightnessFactor * (float)(color & 0xFF0000)) & 0xFF0000 | (int)(brightnessFactor * (float)(color & 0xFF00)) & 0xFF00 | (int)(brightnessFactor * (float)(color & 0xFF)) & 0xFF;
    }

    public static int interpolateColors(int a, int b, float lerp) {
        int MASK1 = 0xFF00FF;
        int MASK2 = 65280;
        int f2 = (int)(256.0f * lerp);
        int f1 = 256 - f2;
        return (a & 0xFF00FF) * f1 + (b & 0xFF00FF) * f2 >> 8 & 0xFF00FF | (a & 0xFF00) * f1 + (b & 0xFF00) * f2 >> 8 & 0xFF00;
    }

    public static int overlayColors(int base, int over) {
        float rDiff = 1.0f - (float)(base & 0xFF0000) / 1.671168E7f;
        float gDiff = 1.0f - (float)(base & 0xFF00) / 65280.0f;
        float bDiff = 1.0f - (float)(base & 0xFF) / 255.0f;
        int r2 = over & 0xFF0000;
        int g2 = over & 0xFF00;
        int b2 = over & 0xFF;
        return base + ((int)(rDiff * (float)r2) & 0xFF0000) + ((int)(gDiff * (float)g2) & 0xFF00) + ((int)(bDiff * (float)b2) & 0xFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRightAlignedGlowingText(FontRenderer fr, String text, int xLoc, int yLoc, int color, int glowColor) {
        Utils.drawGlowingText(fr, text, xLoc - fr.func_78256_a(text), yLoc, color, glowColor);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawCenteredGlowingText(FontRenderer fr, String text, int xLoc, int yLoc, int color, int glowColor) {
        Utils.drawGlowingText(fr, text, xLoc - fr.func_78256_a(text) / 2, yLoc, color, glowColor);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGlowingText(FontRenderer fr, String text, int xLoc, int yLoc, int color, int glowColor) {
        for (int i = 0; i < 4; ++i) {
            fr.func_78276_b(text, xLoc + oX[i], yLoc + oY[i], glowColor);
        }
        fr.func_78276_b(text, xLoc, yLoc, color);
    }

    public static int lookupRotatedSide(int side, int orientation) {
        int[][] table = new int[][]{{0, 1, 2, 2, 2, 2}, {1, 0, 3, 3, 3, 3}, {2, 3, 0, 1, 5, 4}, {3, 2, 1, 0, 4, 5}, {5, 5, 5, 4, 0, 1}, {4, 4, 4, 5, 1, 0}};
        return table[side][orientation];
    }

    public static NBTTagCompound getOrCreateStackTag(ItemStack itemStack) {
        if (itemStack != null) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.func_77982_d(tag);
            }
            return tag;
        }
        return null;
    }

    public static boolean isItemChargeable(ItemStack stack, int tier) {
        IElectricItem item;
        return stack != null && stack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)stack.func_77973_b()).getTier(stack) <= tier;
    }

    public static boolean isItemDrainable(ItemStack stack, int tier) {
        IElectricItem item;
        return stack != null && stack.func_77973_b() instanceof IElectricItem && (item = (IElectricItem)stack.func_77973_b()).canProvideEnergy(stack) && item.getTier(stack) <= tier;
    }
}

