/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import com.kaijin.AdvPowerMan.AdvancedPowerManagement;
import com.kaijin.AdvPowerMan.Info;
import com.kaijin.AdvPowerMan.ItemCardBase;
import com.kaijin.AdvPowerMan.ItemStorageLinkCard;
import com.kaijin.AdvPowerMan.TECommon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IEnergyStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public class TEStorageMonitor
extends TECommon
implements ISidedInventory {
    private ItemStack[] contents = new ItemStack[1];
    private int tickTime = 0;
    private int tickDelay = 5;
    public int lowerBoundary = 60;
    public int upperBoundary = 90;
    private boolean tileLoaded = false;
    public int energyStored = 0;
    public int energyCapacity = 0;
    public int chargeLevel = 0;
    public boolean isPowering = false;
    public boolean blockState = false;
    public int[] targetCoords;
    private static final int[] storageMonitorSideUniversal = new int[]{0};

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isPowering = nbttagcompound.func_74767_n("isPowering");
        this.upperBoundary = nbttagcompound.func_74762_e("upperBoundary");
        this.lowerBoundary = nbttagcompound.func_74762_e("lowerBoundary");
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("isPowering", this.isPowering);
        nbttagcompound.func_74768_a("upperBoundary", this.upperBoundary);
        nbttagcompound.func_74768_a("lowerBoundary", this.lowerBoundary);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public int getGuiID() {
        return 3;
    }

    private void selfDestroy() {
        this.dropContents();
        ItemStack stack = new ItemStack(AdvancedPowerManagement.blockAdvPwrMan, 1, 11);
        this.dropItem(stack);
        this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70313_j();
    }

    public void dropItem(ItemStack item) {
        EntityItem entityitem = new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, item);
        entityitem.field_70293_c = 10;
        this.field_70331_k.func_72838_d((Entity)entityitem);
    }

    @Override
    public void dropContents() {
        for (int i = 0; i < this.contents.length; ++i) {
            ItemStack item = this.contents[i];
            if (item == null || item.field_77994_a <= 0) continue;
            this.dropItem(item);
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemStorageLinkCard;
    }

    private void onLoad() {
        if (!AdvancedPowerManagement.proxy.isClient()) {
            this.tileLoaded = true;
            this.checkInventory();
            if (this.targetCoords != null) {
                TileEntity tile = null;
                if (this.targetCoords[3] == this.field_70331_k.field_73011_w.field_76574_g) {
                    tile = this.field_70331_k.func_72796_p(this.targetCoords[0], this.targetCoords[1], this.targetCoords[2]);
                }
                if (tile instanceof IEnergyStorage) {
                    this.energyStored = ((IEnergyStorage)tile).getStored();
                    this.energyCapacity = ((IEnergyStorage)tile).getCapacity();
                    this.blockState = true;
                } else {
                    this.energyStored = 0;
                    this.energyCapacity = 0;
                    this.blockState = false;
                }
            }
            this.chargeLevel = this.gaugeEnergyScaled(12);
            if (this.energyCapacity > 0) {
                this.updateRedstone();
            } else if (this.isPowering) {
                this.isPowering = false;
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void func_70316_g() {
        if (AdvancedPowerManagement.proxy.isClient()) {
            return;
        }
        if (!this.tileLoaded) {
            this.onLoad();
        }
        if (this.tickTime > 0) {
            --this.tickTime;
        } else {
            this.tickTime = this.tickDelay;
            if (this.targetCoords != null) {
                TileEntity tile = null;
                if (this.targetCoords[3] == this.field_70331_k.field_73011_w.field_76574_g) {
                    tile = this.field_70331_k.func_72796_p(this.targetCoords[0], this.targetCoords[1], this.targetCoords[2]);
                }
                if (tile instanceof IEnergyStorage) {
                    this.energyStored = ((IEnergyStorage)tile).getStored();
                    this.energyCapacity = ((IEnergyStorage)tile).getCapacity();
                    if (!this.blockState) {
                        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    }
                    this.blockState = true;
                } else {
                    this.energyStored = 0;
                    this.energyCapacity = 0;
                    if (this.blockState) {
                        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    }
                    this.blockState = false;
                }
            }
            if (this.energyCapacity > 0) {
                this.updateRedstone();
            } else if (this.isPowering) {
                this.isPowering = false;
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            }
            int oldChargeLevel = this.chargeLevel;
            this.chargeLevel = this.gaugeEnergyScaled(12);
            if (oldChargeLevel != this.chargeLevel) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    private void updateRedstone() {
        float chargePercent = (float)this.energyStored * 100.0f / (float)this.energyCapacity;
        if (!this.isPowering && chargePercent < (float)this.lowerBoundary || this.isPowering && chargePercent >= (float)this.upperBoundary) {
            if (Info.isDebugging) {
                System.out.println("Storage Monitor toggling redstone. chargePercent:" + chargePercent);
            }
            this.isPowering = !this.isPowering;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    private void checkInventory() {
        ItemStack item = this.func_70301_a(0);
        if (item == null || !(item.func_77973_b() instanceof ItemStorageLinkCard)) {
            this.targetCoords = null;
            this.energyCapacity = 0;
            this.energyStored = 0;
            this.blockState = false;
        } else {
            this.targetCoords = ItemCardBase.getCoordinates(item);
            ItemCardBase.setCoordinates(item, this.targetCoords);
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int gaugeEnergyScaled(int gaugeSize) {
        if (this.energyStored <= 0 || this.energyCapacity <= 0) {
            return 0;
        }
        int result = this.energyStored * gaugeSize / this.energyCapacity;
        if (result > gaugeSize) {
            result = gaugeSize;
        }
        return result;
    }

    @Override
    public void receiveGuiButton(int id) {
        switch (id) {
            case 0: {
                this.upperBoundary -= 10;
                if (this.upperBoundary < 1) {
                    this.upperBoundary = 1;
                }
                if (this.upperBoundary >= this.lowerBoundary) break;
                this.lowerBoundary = this.upperBoundary;
                break;
            }
            case 1: {
                --this.upperBoundary;
                if (this.upperBoundary < 1) {
                    this.upperBoundary = 1;
                }
                if (this.upperBoundary >= this.lowerBoundary) break;
                this.lowerBoundary = this.upperBoundary;
                break;
            }
            case 2: {
                ++this.upperBoundary;
                if (this.upperBoundary <= 100) break;
                this.upperBoundary = 100;
                break;
            }
            case 3: {
                this.upperBoundary += 10;
                if (this.upperBoundary == 11) {
                    this.upperBoundary = 10;
                }
                if (this.upperBoundary <= 100) break;
                this.upperBoundary = 100;
                break;
            }
            case 4: {
                this.lowerBoundary -= 10;
                if (this.lowerBoundary >= 1) break;
                this.lowerBoundary = 1;
                break;
            }
            case 5: {
                --this.lowerBoundary;
                if (this.lowerBoundary >= 1) break;
                this.lowerBoundary = 1;
                break;
            }
            case 6: {
                ++this.lowerBoundary;
                if (this.lowerBoundary > 100) {
                    this.lowerBoundary = 100;
                }
                if (this.lowerBoundary <= this.upperBoundary) break;
                this.upperBoundary = this.lowerBoundary;
                break;
            }
            case 7: {
                this.lowerBoundary += 10;
                if (this.lowerBoundary == 11) {
                    this.lowerBoundary = 10;
                }
                if (this.lowerBoundary > 100) {
                    this.lowerBoundary = 100;
                }
                if (this.lowerBoundary <= this.upperBoundary) break;
                this.upperBoundary = this.lowerBoundary;
            }
        }
    }

    public Packet250CustomPayload getDescriptionPacket() {
        return this.createDescPacket();
    }

    @Override
    protected void addUniqueDescriptionData(DataOutputStream data) throws IOException {
        data.writeInt(this.chargeLevel);
        data.writeBoolean(this.isPowering);
        data.writeBoolean(this.blockState);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveDescriptionData(int packetID, DataInputStream stream) {
        boolean c;
        boolean b;
        int a;
        try {
            a = stream.readInt();
            b = stream.readBoolean();
            c = stream.readBoolean();
        }
        catch (IOException e) {
            this.logDescPacketError(e);
            return;
        }
        this.chargeLevel = a;
        this.isPowering = b;
        this.blockState = c;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int[] func_94128_d(int side) {
        return storageMonitorSideUniversal;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && stack != null && stack.func_77973_b() instanceof ItemStorageLinkCard;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.contents[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.contents[slot] != null) {
            if (this.contents[slot].field_77994_a <= amount) {
                ItemStack output = this.contents[slot];
                this.contents[slot] = null;
                this.onInventoryChanged(slot);
                return output;
            }
            ItemStack output = this.contents[slot].func_77979_a(amount);
            if (this.contents[slot].field_77994_a == 0) {
                this.contents[slot] = null;
            }
            this.onInventoryChanged(slot);
            return output;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        ItemStack stack = this.contents[slot];
        this.contents[slot] = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.contents[slot] = itemstack;
        if (Info.isDebugging && itemstack != null) {
            if (AdvancedPowerManagement.proxy.isServer()) {
                System.out.println("Server assigned stack tag: " + itemstack.field_77990_d);
                if (itemstack.field_77990_d != null) {
                    System.out.println("     " + itemstack.field_77990_d.func_74758_c().toString());
                }
            }
            if (AdvancedPowerManagement.proxy.isClient()) {
                System.out.println("Client assigned stack tag: " + itemstack.field_77990_d);
                if (itemstack.field_77990_d != null) {
                    System.out.println("     " + itemstack.field_77990_d.func_74758_c().toString());
                }
            }
        }
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged(slot);
    }

    @Override
    public void onInventoryChanged(int slot) {
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (Info.isDebugging) {
            System.out.println("TEStorageMonitor.onInventoryChanged");
        }
        this.checkInventory();
        super.func_70296_d();
    }

    public String func_70303_b() {
        return Info.KEY_BLOCK_NAMES[11] + ".name";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

