/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import com.kaijin.AdvPowerMan.AdvancedPowerManagement;
import com.kaijin.AdvPowerMan.Info;
import com.kaijin.AdvPowerMan.MovingAverage;
import com.kaijin.AdvPowerMan.TECommonBench;
import com.kaijin.AdvPowerMan.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TEChargingBench
extends TECommonBench
implements IEnergySink,
IEnergyStorage,
IInventory,
net.minecraft.inventory.ISidedInventory,
ISidedInventory {
    public int baseMaxInput;
    public int baseStorage;
    public int adjustedMaxInput;
    public int adjustedStorage;
    public int currentEnergy;
    protected int chargeLevel;
    public float drainFactor;
    public float chargeFactor;
    protected int energyReceived = 0;
    public MovingAverage inputTracker = new MovingAverage(12);
    public int ticksRequired = 0;
    public int energyRequired = 0;
    private static final int[] ChargingBenchSideInput = new int[]{0};
    private static final int[] ChargingBenchSideOutput = new int[]{1};
    private static final int[] ChargingBenchSideInOut = new int[]{0, 1};
    private static final int[] ChargingBenchSidePower = new int[]{2};

    public TEChargingBench() {
    }

    public TEChargingBench(int i) {
        this.contents = new ItemStack[19];
        this.baseTier = i;
        this.initializeBaseValues();
        this.adjustedMaxInput = this.baseMaxInput;
        this.adjustedStorage = this.baseStorage;
        this.powerTier = this.baseTier;
        this.drainFactor = 1.0f;
        this.chargeFactor = 1.0f;
    }

    protected void initializeBaseValues() {
        this.baseMaxInput = (int)Math.pow(2.0, 2 * this.baseTier + 3);
        switch (this.baseTier) {
            case 1: {
                this.baseStorage = 40000;
                break;
            }
            case 2: {
                this.baseStorage = 600000;
                break;
            }
            case 3: {
                this.baseStorage = 10000000;
                break;
            }
            default: {
                this.baseStorage = 0;
            }
        }
    }

    public int swapBenchComponents(int newTier) {
        int oldTier = this.baseTier;
        this.baseTier = newTier;
        this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0 + newTier - 1, 3);
        this.initializeBaseValues();
        this.doUpgradeEffects();
        this.chargeLevel = this.gaugeEnergyScaled(12);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return oldTier;
    }

    public void setStored(int energy) {
    }

    public int addEnergy(int amount) {
        return this.currentEnergy;
    }

    public boolean isTeleporterCompatible(Direction side) {
        return false;
    }

    public int getMaxSafeInput() {
        return this.adjustedMaxInput;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public int demandsEnergy() {
        if (!this.receivingRedstoneSignal()) {
            return this.adjustedStorage - this.currentEnergy;
        }
        return 0;
    }

    public int injectEnergy(Direction directionFrom, int supply) {
        int surplus = 0;
        if (AdvancedPowerManagement.proxy.isServer()) {
            if (supply > this.adjustedMaxInput) {
                this.selfDestroy();
                if (supply <= 1) {
                    return 0;
                }
                return supply - 1;
            }
            if (this.currentEnergy > this.adjustedStorage) {
                this.currentEnergy = this.adjustedStorage;
            }
            this.currentEnergy += supply;
            this.energyReceived += supply;
            if (this.currentEnergy > this.adjustedStorage) {
                surplus = this.currentEnergy - this.adjustedStorage;
                this.currentEnergy = this.adjustedStorage;
                this.energyReceived -= surplus;
            }
        }
        return surplus;
    }

    public int getStored() {
        return this.currentEnergy;
    }

    public int getCapacity() {
        return this.adjustedStorage;
    }

    public int getOutput() {
        return 0;
    }

    @Override
    public int getGuiID() {
        return 1;
    }

    @Override
    protected void selfDestroy() {
        this.dropContents();
        ItemStack stack = new ItemStack(AdvancedPowerManagement.blockAdvPwrMan, 1, 0 + this.baseTier - 1);
        this.dropItem(stack);
        this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70313_j();
    }

    public void doUpgradeEffects() {
        int ocCount = 0;
        int tfCount = 0;
        int esCount = 0;
        for (int i = 15; i < 19; ++i) {
            ItemStack stack = this.contents[i];
            if (stack == null) continue;
            if (stack.func_77969_a(Info.ic2overclockerUpg)) {
                ocCount += stack.field_77994_a;
                continue;
            }
            if (stack.func_77969_a(Info.ic2storageUpg)) {
                esCount += stack.field_77994_a;
                continue;
            }
            if (!stack.func_77969_a(Info.ic2transformerUpg)) continue;
            tfCount += stack.field_77994_a;
        }
        if (ocCount > 20) {
            ocCount = 20;
        }
        if (esCount > 64) {
            esCount = 64;
        }
        if (tfCount > 3) {
            tfCount = 3;
        }
        this.chargeFactor = (float)Math.pow(1.3f, ocCount);
        this.drainFactor = (float)Math.pow(1.5, ocCount);
        this.powerTier = this.baseTier + tfCount;
        if (this.powerTier > 3) {
            this.powerTier = 3;
        }
        this.adjustedMaxInput = (int)Math.pow(2.0, 2 * (this.baseTier + tfCount) + 3);
        if (this.adjustedMaxInput > 2048) {
            this.adjustedMaxInput = 2048;
        }
        switch (this.baseTier) {
            case 1: {
                this.adjustedStorage = this.baseStorage + esCount * 10000;
                break;
            }
            case 2: {
                this.adjustedStorage = this.baseStorage + esCount * 60000;
                break;
            }
            case 3: {
                this.adjustedStorage = this.baseStorage + esCount * 500000;
                break;
            }
            default: {
                this.adjustedStorage = this.baseStorage;
            }
        }
        if (this.currentEnergy > this.adjustedStorage) {
            this.currentEnergy = this.adjustedStorage;
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            if (slot == 2 && item.canProvideEnergy(stack) && item.getTier(stack) <= this.powerTier) {
                return true;
            }
            if (slot >= 3 && slot < 15 && item.getTier(stack) <= this.baseTier) {
                return true;
            }
            if (slot >= 15 && slot < 19 && (stack.func_77969_a(Info.ic2overclockerUpg) || stack.func_77969_a(Info.ic2transformerUpg) || stack.func_77969_a(Info.ic2storageUpg))) {
                return true;
            }
            if (slot == 0 && item.getTier(stack) <= this.baseTier) {
                return true;
            }
            if (slot == 1) {
                return true;
            }
        }
        return false;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (Info.isDebugging) {
            System.out.println("CB ID: " + nbttagcompound.func_74779_i("id"));
        }
        this.baseTier = nbttagcompound.func_74762_e("baseTier");
        this.currentEnergy = nbttagcompound.func_74762_e("currentEnergy");
        this.contents = new ItemStack[19];
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.initializeBaseValues();
        this.doUpgradeEffects();
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("baseTier", this.baseTier);
        nbttagcompound.func_74768_a("currentEnergy", this.currentEnergy);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70316_g() {
        if (AdvancedPowerManagement.proxy.isClient()) {
            return;
        }
        if (!this.initialized && this.field_70331_k != null) {
            EnergyTileLoadEvent loadEvent = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)loadEvent);
            this.initialized = true;
        }
        this.inputTracker.tick(this.energyReceived);
        this.energyReceived = 0;
        this.ticksRequired = 0;
        this.energyRequired = 0;
        boolean lastWorkState = this.doingWork;
        this.doingWork = false;
        this.drainPowerSource();
        this.chargeItems();
        this.moveOutputItems();
        this.acceptInputItems();
        if (this.energyRequired > this.currentEnergy) {
            int deficit = this.energyRequired - this.currentEnergy;
            float avg = this.inputTracker.getAverage();
            if (avg >= 1.0f) {
                int time = (int)Math.ceil((float)deficit / avg);
                if (time > this.ticksRequired) {
                    this.ticksRequired = time;
                }
            } else {
                this.ticksRequired = -1;
            }
        }
        int oldChargeLevel = this.chargeLevel;
        this.chargeLevel = this.gaugeEnergyScaled(12);
        if (oldChargeLevel != this.chargeLevel || lastWorkState != this.doingWork) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    private void drainPowerSource() {
        int chargeReturned = 0;
        ItemStack stack = this.func_70301_a(2);
        if (stack != null && stack.func_77973_b() instanceof IElectricItem && this.currentEnergy < this.adjustedStorage) {
            IElectricItem powerSource = (IElectricItem)stack.func_77973_b();
            int emptyItemID = powerSource.getEmptyItemId(stack);
            int chargedItemID = powerSource.getChargedItemId(stack);
            if (stack.field_77993_c == chargedItemID) {
                if (powerSource.getTier(stack) <= this.powerTier && powerSource.canProvideEnergy(stack)) {
                    int energyNeeded = this.adjustedStorage - this.currentEnergy;
                    int itemTransferLimit = powerSource.getTransferLimit(stack);
                    if (energyNeeded > itemTransferLimit) {
                        energyNeeded = itemTransferLimit;
                    }
                    if (energyNeeded > 0) {
                        chargeReturned = ElectricItem.discharge((ItemStack)stack, (int)energyNeeded, (int)this.powerTier, (boolean)false, (boolean)false);
                        this.currentEnergy += chargeReturned;
                        if (chargeReturned > 0) {
                            this.doingWork = true;
                        }
                        if (this.currentEnergy > this.adjustedStorage) {
                            this.currentEnergy = this.adjustedStorage;
                        }
                    }
                }
                if (chargedItemID != emptyItemID && ElectricItem.discharge((ItemStack)stack, (int)1, (int)this.powerTier, (boolean)false, (boolean)true) == 0) {
                    this.func_70299_a(2, new ItemStack(emptyItemID, 1, 0));
                }
            }
        }
    }

    private void chargeItems() {
        for (int i = 3; i < 15; ++i) {
            ItemStack stackCopy;
            int amountNeeded;
            IElectricItem item;
            ItemStack stack = this.contents[i];
            if (stack == null || !(stack.func_77973_b() instanceof IElectricItem) || stack.field_77994_a != 1 || (item = (IElectricItem)stack.func_77973_b()).getTier(stack) > this.baseTier) continue;
            int itemTransferLimit = item.getTransferLimit(stack);
            if (itemTransferLimit == 0) {
                itemTransferLimit = this.baseMaxInput;
            }
            int adjustedTransferLimit = (int)Math.ceil(this.chargeFactor * (float)itemTransferLimit);
            int missing = item.getChargedItemId(stack) != item.getEmptyItemId(stack) || stack.func_77985_e() ? ((amountNeeded = ElectricItem.charge((ItemStack)(stackCopy = stack.func_77946_l()), (int)adjustedTransferLimit, (int)this.baseTier, (boolean)true, (boolean)true)) == adjustedTransferLimit ? ElectricItem.charge((ItemStack)stackCopy, (int)item.getMaxCharge(stackCopy), (int)this.baseTier, (boolean)true, (boolean)true) : amountNeeded) : ((amountNeeded = ElectricItem.charge((ItemStack)stack, (int)adjustedTransferLimit, (int)this.baseTier, (boolean)true, (boolean)true)) == adjustedTransferLimit ? ElectricItem.charge((ItemStack)stack, (int)item.getMaxCharge(stack), (int)this.baseTier, (boolean)true, (boolean)true) : amountNeeded);
            int eta = (int)Math.ceil((float)missing / (float)adjustedTransferLimit);
            if (this.ticksRequired < eta) {
                this.ticksRequired = eta;
            }
            this.energyRequired += (int)Math.ceil(this.drainFactor / this.chargeFactor * (float)missing);
            int adjustedEnergyUse = (int)Math.ceil(this.drainFactor / this.chargeFactor * (float)amountNeeded);
            if (adjustedEnergyUse <= 0 || this.currentEnergy <= 0) continue;
            if (adjustedEnergyUse > this.currentEnergy) {
                adjustedTransferLimit = adjustedTransferLimit * this.currentEnergy / adjustedEnergyUse;
                adjustedEnergyUse = this.currentEnergy;
            }
            ElectricItem.charge((ItemStack)this.contents[i], (int)adjustedTransferLimit, (int)this.baseTier, (boolean)true, (boolean)false);
            this.currentEnergy -= adjustedEnergyUse;
            if (this.currentEnergy < 0) {
                this.currentEnergy = 0;
            }
            this.doingWork = true;
        }
    }

    private void moveOutputItems() {
        ItemStack stack = this.contents[1];
        if (stack == null) {
            for (int slot = 3; slot < 15; ++slot) {
                ItemStack currentStack = this.contents[slot];
                if (currentStack == null || !(currentStack.func_77973_b() instanceof IElectricItem) || ElectricItem.charge((ItemStack)currentStack.func_77946_l(), (int)1, (int)this.baseTier, (boolean)false, (boolean)true) != 0) continue;
                this.contents[1] = currentStack;
                this.contents[slot] = null;
                this.func_70296_d();
                break;
            }
        }
    }

    private void acceptInputItems() {
        ItemStack stack = this.contents[0];
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            for (int slot = 3; slot < 15; ++slot) {
                if (this.contents[slot] != null) continue;
                this.contents[slot] = this.func_70298_a(0, 1);
                break;
            }
        }
    }

    public int gaugeEnergyScaled(int gaugeSize) {
        if (this.currentEnergy <= 0) {
            return 0;
        }
        int result = this.currentEnergy * gaugeSize / this.adjustedStorage;
        if (result > gaugeSize) {
            result = gaugeSize;
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveDescriptionData(int packetID, DataInputStream stream) {
        boolean b;
        int a;
        try {
            a = stream.readInt();
            b = stream.readBoolean();
        }
        catch (IOException e) {
            this.logDescPacketError(e);
            return;
        }
        this.chargeLevel = a;
        this.doingWork = b;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet250CustomPayload getDescriptionPacket() {
        return this.createDescPacket();
    }

    @Override
    protected void addUniqueDescriptionData(DataOutputStream data) throws IOException {
        data.writeInt(this.chargeLevel);
        data.writeBoolean(this.doingWork);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 1;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int[] func_94128_d(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return ChargingBenchSideInOut;
            }
        }
        return ChargingBenchSidePower;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 2) {
            return Utils.isItemDrainable(stack, this.powerTier);
        }
        if (i == 0) {
            return Utils.isItemChargeable(stack, this.powerTier);
        }
        return false;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0 || i == 2;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1 || i == 2;
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    @Override
    public String func_70303_b() {
        switch (this.baseTier) {
            case 1: {
                return Info.KEY_BLOCK_NAMES[0] + ".name";
            }
            case 2: {
                return Info.KEY_BLOCK_NAMES[1] + ".name";
            }
            case 3: {
                return Info.KEY_BLOCK_NAMES[2] + ".name";
            }
        }
        return "";
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (slot == 0 || slot == 1) {
            if (this.contents[0] != null && this.contents[1] == null && !this.isItemValid(0, this.contents[0])) {
                this.contents[1] = this.contents[0];
                this.contents[0] = null;
            }
        } else if (slot >= 15 && slot < 19) {
            this.doUpgradeEffects();
        } else if (slot >= 3 && slot < 15 || slot == 2) {
            // empty if block
        }
        super.func_70296_d();
    }

    public void func_70296_d() {
        this.doUpgradeEffects();
        super.func_70296_d();
    }
}

