/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import com.kaijin.AdvPowerMan.AdvancedPowerManagement;
import com.kaijin.AdvPowerMan.Info;
import com.kaijin.AdvPowerMan.MovingAverage;
import com.kaijin.AdvPowerMan.TECommonBench;
import com.kaijin.AdvPowerMan.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TEBatteryStation
extends TECommonBench
implements IEnergySource,
IInventory,
net.minecraft.inventory.ISidedInventory,
ISidedInventory {
    public int opMode;
    public int packetSize;
    public int currentEnergy = 0;
    private boolean invChanged = false;
    private boolean hasEnoughItems = false;
    public boolean doingWork;
    private int energyOut = 0;
    public MovingAverage outputTracker = new MovingAverage(12);
    private static final int[] BatteryStationSideInput = new int[]{0};
    private static final int[] BatteryStationSideOutput = new int[]{1};
    private static final int[] BatteryStationSideInOut = new int[]{0, 1};

    public TEBatteryStation() {
    }

    public TEBatteryStation(int i) {
        this.contents = new ItemStack[14];
        this.baseTier = i;
        this.opMode = 1;
        this.initializeValues();
    }

    private void initializeValues() {
        this.powerTier = this.baseTier;
        this.packetSize = (int)Math.pow(2.0, 2 * this.baseTier + 3);
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return true;
    }

    public int getMaxEnergyOutput() {
        return this.packetSize;
    }

    @Override
    public int getGuiID() {
        return 2;
    }

    @Override
    protected void selfDestroy() {
        this.dropContents();
        ItemStack stack = new ItemStack(AdvancedPowerManagement.blockAdvPwrMan, 1, 8 + this.baseTier - 1);
        this.dropItem(stack);
        this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70313_j();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IElectricItem) {
            IElectricItem item = (IElectricItem)stack.func_77973_b();
            if (slot == 1) {
                return true;
            }
            if (item.canProvideEnergy(stack) && item.getTier(stack) <= this.powerTier && (slot >= 2 && slot < 14 || slot == 0)) {
                return true;
            }
        }
        return false;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (Info.isDebugging) {
            System.out.println("BS ID: " + nbttagcompound.func_74779_i("id"));
        }
        this.baseTier = nbttagcompound.func_74762_e("baseTier");
        this.opMode = nbttagcompound.func_74762_e("opMode");
        this.currentEnergy = nbttagcompound.func_74762_e("currentEnergy");
        this.contents = new ItemStack[14];
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.initializeValues();
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("baseTier", this.baseTier);
        nbttagcompound.func_74768_a("opMode", this.opMode);
        nbttagcompound.func_74768_a("currentEnergy", this.currentEnergy);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70316_g() {
        if (AdvancedPowerManagement.proxy.isClient()) {
            return;
        }
        if (!this.initialized && this.field_70331_k != null) {
            EnergyTileLoadEvent loadEvent = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)loadEvent);
            this.initialized = true;
        }
        boolean lastWorkState = this.doingWork;
        this.doingWork = false;
        this.invChanged = false;
        this.hasEnoughItems = true;
        if (!this.receivingRedstoneSignal()) {
            this.drainPowerSource();
            this.energyOut = this.emitEnergy();
        } else {
            this.energyOut = 0;
        }
        this.moveOutputItems();
        this.repositionItems();
        this.acceptInputItems();
        this.outputTracker.tick(this.energyOut);
        if (this.invChanged) {
            this.func_70296_d();
        }
        if (lastWorkState != this.doingWork) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    private int emitEnergy() {
        if (this.currentEnergy >= this.packetSize) {
            EnergyTileSourceEvent sourceEvent = new EnergyTileSourceEvent((IEnergySource)this, this.packetSize);
            MinecraftForge.EVENT_BUS.post((Event)sourceEvent);
            int surplus = sourceEvent.amount;
            if (surplus < this.packetSize) {
                int sent = this.packetSize - surplus;
                this.currentEnergy -= sent;
                this.doingWork = true;
                return sent;
            }
        }
        return 0;
    }

    private void drainPowerSource() {
        this.hasEnoughItems = false;
        for (int i = 2; i < 14; ++i) {
            int chargeReturned;
            IElectricItem item;
            if (this.currentEnergy >= this.packetSize) {
                this.hasEnoughItems = true;
                break;
            }
            ItemStack stack = this.contents[i];
            if (stack == null || !(stack.func_77973_b() instanceof IElectricItem) || stack.field_77994_a != 1 || (item = (IElectricItem)stack.func_77973_b()).getTier(stack) > this.powerTier || !item.canProvideEnergy(stack)) continue;
            int emptyItemID = item.getEmptyItemId(stack);
            int chargedItemID = item.getChargedItemId(stack);
            if (stack.field_77993_c != chargedItemID) continue;
            int transferLimit = item.getTransferLimit(stack);
            if (transferLimit == 0) {
                transferLimit = this.packetSize;
            }
            if ((chargeReturned = ElectricItem.discharge((ItemStack)stack, (int)transferLimit, (int)this.powerTier, (boolean)false, (boolean)false)) > 0) {
                this.currentEnergy += chargeReturned;
                this.doingWork = true;
            }
            if (chargedItemID == emptyItemID || chargeReturned >= transferLimit && ElectricItem.discharge((ItemStack)stack, (int)1, (int)this.powerTier, (boolean)false, (boolean)true) != 0) continue;
            this.func_70299_a(i, new ItemStack(emptyItemID, 1, 0));
        }
    }

    private void moveOutputItems() {
        this.rejectInvalidInput();
        ItemStack outputStack = this.contents[1];
        if (outputStack == null || outputStack.func_77985_e() && outputStack.field_77994_a < outputStack.func_77976_d()) {
            for (int slot = 0; slot < this.contents.length; ++slot) {
                boolean empty;
                int chargedItemID;
                IElectricItem powerSource;
                ItemStack currentStack;
                if (slot == 1 || (currentStack = this.contents[slot]) == null || !(currentStack.func_77973_b() instanceof IElectricItem) || (powerSource = (IElectricItem)currentStack.func_77973_b()).getTier(currentStack) > this.powerTier) continue;
                int emptyItemID = powerSource.getEmptyItemId(currentStack);
                if (emptyItemID != (chargedItemID = powerSource.getChargedItemId(currentStack))) {
                    if (currentStack.field_77993_c != emptyItemID) continue;
                    if (outputStack == null) {
                        this.contents[1] = currentStack;
                        this.contents[slot] = null;
                    } else {
                        ++this.contents[1].field_77994_a;
                        --this.contents[slot].field_77994_a;
                        if (this.contents[slot].field_77994_a < 1) {
                            this.contents[slot] = null;
                        }
                    }
                    this.invChanged = true;
                    break;
                }
                if (outputStack != null) continue;
                boolean bl = empty = ElectricItem.discharge((ItemStack)currentStack, (int)1, (int)this.powerTier, (boolean)true, (boolean)true) == 0;
                if (!empty) continue;
                this.contents[1] = currentStack;
                this.contents[slot] = null;
                this.invChanged = true;
                break;
            }
        }
    }

    private void repositionItems() {
        int vacancy;
        int lastIndex = 13;
        for (vacancy = 2; vacancy < 13 && this.contents[vacancy] != null; ++vacancy) {
        }
        for (int hunt = vacancy + 1; vacancy < 13 && hunt <= 13; ++hunt) {
            if (this.contents[vacancy] != null || this.contents[hunt] == null) continue;
            this.contents[vacancy] = this.contents[hunt];
            this.contents[hunt] = null;
            this.invChanged = true;
            ++vacancy;
        }
    }

    private void acceptInputItems() {
        ItemStack stack = this.contents[0];
        if (stack == null || !(stack.func_77973_b() instanceof IElectricItem) || this.opMode == 1 && this.hasEnoughItems) {
            return;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (item.canProvideEnergy(stack)) {
            for (int slot = 2; slot < 14; ++slot) {
                if (this.contents[slot] != null) continue;
                this.contents[slot] = this.func_70298_a(0, 1);
                break;
            }
        }
    }

    private void rejectInvalidInput() {
        if (this.contents[0] != null && this.contents[1] == null && !this.isItemValid(0, this.contents[0])) {
            this.contents[1] = this.contents[0];
            this.contents[0] = null;
            this.invChanged = true;
        }
    }

    public int getTotalEnergy() {
        int energySum = 0;
        for (int i = 0; i < 14; ++i) {
            int chargeReturned;
            IElectricItem item;
            ItemStack stack;
            if (i == 1 || (stack = this.contents[i]) == null || !(stack.func_77973_b() instanceof IElectricItem) || stack.field_77994_a != 1 || (item = (IElectricItem)stack.func_77973_b()).getTier(stack) > this.powerTier || !item.canProvideEnergy(stack) || stack.field_77993_c != item.getChargedItemId(stack) || (chargeReturned = ElectricItem.discharge((ItemStack)stack, (int)Integer.MAX_VALUE, (int)this.powerTier, (boolean)true, (boolean)true)) <= 0) continue;
            energySum += chargeReturned;
        }
        return energySum;
    }

    public Packet250CustomPayload getDescriptionPacket() {
        return this.createDescPacket();
    }

    @Override
    protected void addUniqueDescriptionData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.doingWork);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveDescriptionData(int packetID, DataInputStream stream) {
        boolean b = this.doingWork;
        try {
            b = stream.readBoolean();
        }
        catch (IOException e) {
            this.logDescPacketError(e);
            return;
        }
        this.doingWork = b;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void receiveGuiButton(int buttonID) {
        if (buttonID == 0) {
            this.opMode ^= 1;
        }
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: 
            case DOWN: {
                return 0;
            }
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int[] func_94128_d(int side) {
        return BatteryStationSideInOut;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            return Utils.isItemDrainable(stack, this.powerTier);
        }
        return false;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public String func_70303_b() {
        switch (this.baseTier) {
            case 1: {
                return Info.KEY_BLOCK_NAMES[8] + ".name";
            }
            case 2: {
                return Info.KEY_BLOCK_NAMES[9] + ".name";
            }
            case 3: {
                return Info.KEY_BLOCK_NAMES[10] + ".name";
            }
        }
        return "";
    }

    @Override
    public void onInventoryChanged(int slot) {
        if (slot == 0 || slot == 1) {
            this.rejectInvalidInput();
        }
        super.func_70296_d();
    }
}

