/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import com.kaijin.AdvPowerMan.AdvancedPowerManagement;
import com.kaijin.AdvPowerMan.Info;
import com.kaijin.AdvPowerMan.TECommon;
import cpw.mods.fml.common.FMLLog;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TEAdvEmitter
extends TECommon
implements IEnergySource {
    protected boolean initialized;
    public int outputRate = 32;
    public int packetSize = 32;
    private int energyBuffer = 0;

    public TEAdvEmitter() {
    }

    public TEAdvEmitter(int i) {
        this.packetSize = this.outputRate = (int)Math.pow(2.0, 2 * i + 3);
        FMLLog.info((String)("[AdvancedPowerManagement] Updating old Emitter block of tier " + i), (Object[])new Object[0]);
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        int baseTier = nbttagcompound.func_74762_e("baseTier");
        if (baseTier > 0) {
            this.packetSize = this.outputRate = (int)Math.pow(2.0, 2 * baseTier + 3);
            FMLLog.info((String)("[AdvancedPowerManagement] Loading NBT data for old Emitter block with baseTier of " + baseTier + " and setting output to " + this.packetSize), (Object[])new Object[0]);
        } else {
            this.outputRate = nbttagcompound.func_74762_e("outputRate");
            this.packetSize = nbttagcompound.func_74762_e("packetSize");
            this.energyBuffer = nbttagcompound.func_74762_e("energyBuffer");
            if (this.packetSize > 2048) {
                this.packetSize = 2048;
            }
            if (this.packetSize < 4) {
                this.packetSize = 4;
            }
            if (this.outputRate > this.packetSize * 64) {
                this.outputRate = this.packetSize * 64;
            }
            if (this.outputRate > 32768) {
                this.outputRate = 32768;
            }
            if (this.outputRate < 1) {
                this.outputRate = 1;
            }
            if (this.energyBuffer > this.packetSize * 64) {
                this.energyBuffer = this.packetSize * 64;
            }
        }
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("outputRate", this.outputRate);
        nbttagcompound.func_74768_a("packetSize", this.packetSize);
        nbttagcompound.func_74768_a("energyBuffer", this.energyBuffer);
    }

    public void func_70313_j() {
        if (this.field_70331_k != null && this.initialized) {
            EnergyTileUnloadEvent unloadEvent = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)unloadEvent);
        }
        super.func_70313_j();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public int getGuiID() {
        return 4;
    }

    public void func_70316_g() {
        if (AdvancedPowerManagement.proxy.isClient()) {
            return;
        }
        if (!this.initialized) {
            if (this.field_70331_k == null) {
                return;
            }
            int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (meta != 7) {
                FMLLog.info((String)("[AdvancedPowerManagement] Resetting Emitter block meta value from " + meta + " to 7"), (Object[])new Object[0]);
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 7, 3);
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
            EnergyTileLoadEvent loadEvent = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)loadEvent);
            this.initialized = true;
        }
        if (this.receivingRedstoneSignal()) {
            this.energyBuffer += this.outputRate;
            EnergyNet net = EnergyNet.getForWorld((World)this.field_70331_k);
            while (this.energyBuffer >= this.packetSize) {
                EnergyTileSourceEvent sourceEvent = new EnergyTileSourceEvent((IEnergySource)this, this.packetSize);
                MinecraftForge.EVENT_BUS.post((Event)sourceEvent);
                this.energyBuffer -= this.packetSize;
            }
        }
    }

    protected boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public String getInvName() {
        return Info.KEY_BLOCK_NAMES[7] + ".name";
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return true;
    }

    public int getMaxEnergyOutput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void receiveGuiButton(int id) {
        switch (id) {
            case 0: {
                ++this.packetSize;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 1: {
                this.packetSize += 10;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 2: {
                this.packetSize += 64;
                if (this.packetSize == 68) {
                    this.packetSize = 64;
                }
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 3: {
                this.packetSize *= 2;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 4: {
                --this.packetSize;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 5: {
                this.packetSize -= 10;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 6: {
                this.packetSize -= 64;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 7: {
                this.packetSize /= 2;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 8: {
                ++this.outputRate;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 9: {
                this.outputRate += 10;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 10: {
                this.outputRate += 64;
                if (this.outputRate == 65) {
                    this.outputRate = 64;
                }
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 11: {
                this.outputRate *= 2;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 12: {
                --this.outputRate;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 13: {
                this.outputRate -= 10;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 14: {
                this.outputRate -= 64;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 15: {
                this.outputRate /= 2;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
            }
        }
    }
}

