/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

import com.kaijin.AdvPowerMan.AdvancedPowerManagement;
import com.kaijin.AdvPowerMan.Info;
import com.kaijin.AdvPowerMan.MovingAverage;
import com.kaijin.AdvPowerMan.TECommon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TEAdjustableTransformer
extends TECommon
implements IEnergySource,
IEnergySink {
    protected boolean initialized = false;
    public MovingAverage outputTracker = new MovingAverage(12);
    public MovingAverage inputTracker = new MovingAverage(12);
    protected int maxInput = 8192;
    public int energyBuffer = 0;
    public int energyReceived = 0;
    public int outputRate = 32;
    public int packetSize = 32;
    public int energyCap = 32;
    public byte[] sideSettings = new byte[]{0, 0, 0, 0, 0, 0};

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.outputRate = nbttagcompound.func_74762_e("outputRate");
        this.packetSize = nbttagcompound.func_74762_e("packetSize");
        this.energyBuffer = nbttagcompound.func_74762_e("energyBuffer");
        if (this.packetSize > 2048) {
            this.packetSize = 2048;
        }
        if (this.packetSize < 4) {
            this.packetSize = 4;
        }
        if (this.outputRate > this.packetSize * 64) {
            this.outputRate = this.packetSize * 64;
        }
        if (this.outputRate > 32768) {
            this.outputRate = 32768;
        }
        if (this.outputRate < 1) {
            this.outputRate = 1;
        }
        if (this.energyBuffer > this.packetSize * 64) {
            this.energyBuffer = this.packetSize * 64;
        }
        this.energyCap = Math.max(this.packetSize, this.outputRate);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("SideSettings");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound entry = (NBTTagCompound)nbttaglist.func_74743_b(i);
            if (i < 0 || i >= this.sideSettings.length) continue;
            this.sideSettings[i] = (byte)(entry.func_74771_c("Flags") & 0xFF);
        }
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("outputRate", this.outputRate);
        nbttagcompound.func_74768_a("packetSize", this.packetSize);
        nbttagcompound.func_74768_a("energyBuffer", this.energyBuffer);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.sideSettings.length; ++i) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74774_a("Flags", this.sideSettings[i]);
            nbttaglist.func_74742_a((NBTBase)entry);
        }
        nbttagcompound.func_74782_a("SideSettings", (NBTBase)nbttaglist);
    }

    public void func_70313_j() {
        if (this.field_70331_k != null && this.initialized) {
            EnergyTileUnloadEvent unloadEvent = new EnergyTileUnloadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)unloadEvent);
        }
        super.func_70313_j();
    }

    @Override
    public int getGuiID() {
        return 5;
    }

    public void func_70316_g() {
        if (AdvancedPowerManagement.proxy.isClient()) {
            return;
        }
        if (!this.initialized) {
            if (this.field_70331_k == null) {
                return;
            }
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.initialized = true;
        }
        int energySent = 0;
        if (!this.receivingRedstoneSignal()) {
            this.energyReceived = this.energyReceived > this.outputRate ? (this.energyReceived -= this.outputRate) : 0;
            if (this.energyBuffer >= this.packetSize) {
                boolean packetSent;
                EnergyNet net = EnergyNet.getForWorld((World)this.field_70331_k);
                do {
                    packetSent = false;
                    EnergyTileSourceEvent sourceEvent = new EnergyTileSourceEvent((IEnergySource)this, this.packetSize);
                    MinecraftForge.EVENT_BUS.post((Event)sourceEvent);
                    int surplus = sourceEvent.amount;
                    if (surplus >= this.packetSize) continue;
                    packetSent = true;
                    int amountSent = this.packetSize - surplus;
                    energySent += amountSent;
                    this.energyBuffer -= amountSent;
                } while (packetSent && this.energyBuffer >= this.packetSize && energySent < this.outputRate);
            }
        }
        this.outputTracker.tick(energySent);
    }

    protected boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public String getInvName() {
        return Info.KEY_BLOCK_NAMES[6] + ".name";
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    protected void selfDestroy() {
        ItemStack stack = new ItemStack(AdvancedPowerManagement.blockAdvPwrMan, 1, 6);
        this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.func_70313_j();
    }

    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return (this.sideSettings[direction.toSideValue()] & 1) == 1;
    }

    public int getMaxEnergyOutput() {
        return Integer.MAX_VALUE;
    }

    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return (this.sideSettings[direction.toSideValue()] & 1) == 0;
    }

    public int demandsEnergy() {
        if (!this.receivingRedstoneSignal()) {
            int tickAmt = Math.max(this.outputRate - this.energyReceived, 0);
            int capAmt = Math.max(this.energyCap - this.energyBuffer, 0);
            return Math.min(tickAmt, capAmt);
        }
        return 0;
    }

    public int injectEnergy(Direction directionFrom, int supply) {
        if (AdvancedPowerManagement.proxy.isServer()) {
            if (supply > this.maxInput) {
                this.selfDestroy();
                if (supply <= 1) {
                    return 0;
                }
                return supply - 1;
            }
            this.energyReceived += supply;
            this.energyBuffer += supply;
            this.inputTracker.tick(supply);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveDescriptionData(int packetID, DataInputStream stream) {
        try {
            for (int i = 0; i < 6; ++i) {
                this.sideSettings[i] = stream.readByte();
            }
        }
        catch (IOException e) {
            this.logDescPacketError(e);
            return;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet250CustomPayload getDescriptionPacket() {
        return this.createDescPacket();
    }

    @Override
    protected void addUniqueDescriptionData(DataOutputStream data) throws IOException {
        for (int i = 0; i < 6; ++i) {
            data.writeByte(this.sideSettings[i]);
        }
    }

    @Override
    public void receiveGuiButton(int id) {
        switch (id) {
            case 0: {
                ++this.packetSize;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 1: {
                this.packetSize += 10;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 2: {
                this.packetSize += 64;
                if (this.packetSize == 68) {
                    this.packetSize = 64;
                }
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 3: {
                this.packetSize *= 2;
                if (this.packetSize <= 2048) break;
                this.packetSize = 2048;
                break;
            }
            case 4: {
                --this.packetSize;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 5: {
                this.packetSize -= 10;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 6: {
                this.packetSize -= 64;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 7: {
                this.packetSize /= 2;
                if (this.packetSize < 4) {
                    this.packetSize = 4;
                }
                if (this.outputRate <= this.packetSize * 64) break;
                this.outputRate = this.packetSize * 64;
                break;
            }
            case 8: {
                ++this.outputRate;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 9: {
                this.outputRate += 10;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 10: {
                this.outputRate += 64;
                if (this.outputRate == 65) {
                    this.outputRate = 64;
                }
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 11: {
                this.outputRate *= 2;
                if (this.outputRate > this.packetSize * 64) {
                    this.outputRate = this.packetSize * 64;
                }
                if (this.outputRate <= 32768) break;
                this.outputRate = 32768;
                break;
            }
            case 12: {
                --this.outputRate;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 13: {
                this.outputRate -= 10;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 14: {
                this.outputRate -= 64;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 15: {
                this.outputRate /= 2;
                if (this.outputRate >= 1) break;
                this.outputRate = 1;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (this.initialized) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
                }
                this.initialized = false;
                int n = id - 16;
                this.sideSettings[n] = (byte)(this.sideSettings[n] ^ 1);
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.initialized = true;
            }
        }
        this.energyCap = Math.max(this.packetSize, this.outputRate);
        byte voltLevel = (byte)(this.packetSize <= 32 ? 0 : (this.packetSize <= 128 ? 2 : (this.packetSize <= 512 ? 4 : 6)));
        for (int i = 0; i < 6; ++i) {
            this.sideSettings[i] = (byte)(this.sideSettings[i] & 0xF9 | voltLevel);
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

