/*
 * Decompiled with CFR 0.152.
 */
package com.kaijin.AdvPowerMan;

public class MovingAverage {
    protected int[] packets = null;
    protected int[] delays = null;
    protected int position;
    protected int delay;
    protected int window;
    protected float average;
    protected float delta;

    public MovingAverage(int size) {
        this.packets = new int[size];
        this.delays = new int[size];
        this.position = 0;
        this.delay = 1;
        this.window = size;
        this.average = 0.0f;
        this.delta = 0.0f;
        for (int i = 0; i < size; ++i) {
            this.packets[i] = 0;
            this.delays[i] = 600;
        }
    }

    public void tick(int value) {
        if (value > 0 || this.delay >= 600) {
            ++this.position;
            if (this.position >= this.packets.length) {
                this.position = 0;
            }
            this.packets[this.position] = value;
            this.delays[this.position] = this.delay;
            this.delay = 1;
            this.window = this.sumDelays();
            float newAvg = (float)this.sumPackets() / (float)this.window;
            this.delta = newAvg - this.average;
            this.average = newAvg;
        } else {
            ++this.delay;
            if (this.delays.length * this.delay > this.window) {
                ++this.window;
                this.average = (float)this.sumPackets() / (float)this.window;
            }
        }
    }

    protected int sumDelays() {
        if (this.delays == null) {
            return 1;
        }
        int delayTotal = 0;
        for (int d : this.delays) {
            delayTotal += d;
        }
        return delayTotal;
    }

    protected int sumPackets() {
        if (this.packets == null) {
            return 0;
        }
        int packetTotal = 0;
        for (int p : this.packets) {
            packetTotal += p;
        }
        return packetTotal;
    }

    public float getAverage() {
        return this.average;
    }

    public int getWindow() {
        return this.window;
    }
}

