/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.api.Coord;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.GenericProxyPlayer;
import factorization.fzds.Hammer;
import factorization.fzds.Packet220FzdsWrap;
import factorization.fzds.api.IDeltaChunk;
import factorization.fzds.api.IFzdsEntryControl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet56MapChunks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class PacketProxyingPlayer
extends GenericProxyPlayer
implements IFzdsEntryControl {
    DimensionSliceEntity dimensionSlice;
    static boolean useShortViewRadius = false;
    private HashSet trackedPlayers = new HashSet();
    private final int PlayerManager_playerViewRadius_field = 4;
    private int ticks_since_last_update = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketProxyingPlayer(DimensionSliceEntity dimensionSlice, World shadowWorld) {
        super(MinecraftServer.func_71276_C(), shadowWorld, "FzdsPacket", new ItemInWorldManager(shadowWorld));
        this.dimensionSlice = dimensionSlice;
        Coord c = dimensionSlice.getCenter();
        c.y = -8;
        c.setAsEntityLocation((Entity)this);
        WorldServer ws = (WorldServer)dimensionSlice.field_70170_p;
        if (useShortViewRadius) {
            int orig = this.savePlayerViewRadius();
            try {
                MinecraftServer.func_71196_a((MinecraftServer)this.field_71133_b).func_72375_a((EntityPlayerMP)this, null);
            }
            finally {
                this.restorePlayerViewRadius(orig);
            }
        } else {
            MinecraftServer.func_71196_a((MinecraftServer)this.field_71133_b).func_72375_a((EntityPlayerMP)this, null);
        }
        this.ticks_since_last_update = (int)(Math.random() * 20.0);
    }

    int savePlayerViewRadius() {
        try {
            return (Integer)ObfuscationReflectionHelper.getPrivateValue(PlayerManager.class, (Object)this.func_71121_q().func_73040_p(), (int)4);
        }
        catch (Exception e) {
            return -1;
        }
    }

    void restorePlayerViewRadius(int orig) {
        if (orig == -1) {
            return;
        }
        ReflectionHelper.setPrivateValue(PlayerManager.class, (Object)this.func_71121_q().func_73040_p(), (Object)orig, (int)4);
    }

    public void func_70071_h_() {
        if (this.dimensionSlice.field_70128_L) {
            this.endProxy();
        } else if (this.ticks_since_last_update > 0) {
            --this.ticks_since_last_update;
        } else if (!this.field_70170_p.field_72995_K) {
            this.ticks_since_last_update = 20;
            List playerList = this.getTargetablePlayers();
            for (int i = 0; i < playerList.size(); ++i) {
                Object o = playerList.get(i);
                if (!(o instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)o;
                if (this.isPlayerInUpdateRange(player)) {
                    boolean new_player = this.trackedPlayers.add(player);
                    if (!new_player || !this.shouldShareChunks()) continue;
                    this.sendChunkMapDataToPlayer(player);
                    continue;
                }
                this.trackedPlayers.remove(player);
            }
        }
        super.func_70071_h_();
    }

    List getTargetablePlayers() {
        return this.dimensionSlice.field_70170_p.field_73010_i;
    }

    boolean isPlayerInUpdateRange(EntityPlayerMP player) {
        return !player.field_70128_L && this.dimensionSlice.func_70068_e((Entity)player) <= Hammer.DSE_ChunkUpdateRangeSquared;
    }

    boolean shouldShareChunks() {
        return true;
    }

    void sendChunkMapDataToPlayer(EntityPlayerMP target) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        ArrayList tileEntities = new ArrayList();
        Coord corner = this.dimensionSlice.getCorner();
        World world = DeltaChunk.getServerShadowWorld();
        Coord low = this.dimensionSlice.getCorner();
        Coord far = this.dimensionSlice.getFarCorner();
        int byteCount = 0;
        int chunkCount = 0;
        int teCount = 0;
        for (int x = low.x - 16; x <= far.x + 16; x += 16) {
            for (int z = low.z - 16; z <= far.z + 16; z += 16) {
                if (!world.func_72899_e(x + 1, 0, z + 1)) continue;
                Chunk chunk = world.func_72938_d(x, z);
                chunks.add(chunk);
                tileEntities.addAll(chunk.field_76648_i.values());
                ++chunkCount;
            }
        }
        NetServerHandler net = target.field_71135_a;
        if (!chunks.isEmpty()) {
            Packet220FzdsWrap toSend = new Packet220FzdsWrap((Packet)new Packet56MapChunks(chunks));
            net.func_72567_b((Packet)toSend);
            byteCount += toSend.func_73284_a() + 1;
        }
        teCount = tileEntities.size();
        if (!tileEntities.isEmpty()) {
            for (TileEntity te : tileEntities) {
                Packet description = te.func_70319_e();
                if (description == null) continue;
                Packet220FzdsWrap toSend = new Packet220FzdsWrap(description);
                net.func_72567_b((Packet)toSend);
                byteCount += toSend.func_73284_a() + 1;
            }
        }
        System.out.println("Sending data of " + chunkCount + " chunks with " + teCount + " tileEntities, totalling " + byteCount + " (reported) bytes");
    }

    public void endProxy() {
        WorldServer var2 = this.func_71121_q();
        var2.func_72900_e((Entity)this);
        var2.func_73040_p().func_72695_c((EntityPlayerMP)this);
        var2.func_73046_m().func_71203_ab().field_72404_b.remove(this.field_71135_a);
        this.func_70106_y();
        this.dimensionSlice.proxy = null;
    }

    boolean shouldForceChunkLoad() {
        return !this.trackedPlayers.isEmpty();
    }

    @Override
    public void func_74429_a(Packet packet) {
        if (this.trackedPlayers.isEmpty()) {
            return;
        }
        Packet220FzdsWrap wrappedPacket = new Packet220FzdsWrap(packet);
        Iterator it = this.trackedPlayers.iterator();
        while (it.hasNext()) {
            EntityPlayerMP player = (EntityPlayerMP)it.next();
            if (player.field_70128_L || player.field_70170_p != this.dimensionSlice.field_70170_p) {
                it.remove();
                continue;
            }
            player.field_71135_a.func_72567_b((Packet)wrappedPacket);
        }
    }

    @Override
    public boolean canEnter(IDeltaChunk dse) {
        return false;
    }

    @Override
    public boolean canExit(IDeltaChunk dse) {
        return false;
    }

    @Override
    public void onEnter(IDeltaChunk dse) {
    }

    @Override
    public void onExit(IDeltaChunk dse) {
    }
}

