/*
 * Decompiled with CFR 0.152.
 */
package factorization.fzds;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.common.Core;
import factorization.fzds.DSTeleporter;
import factorization.fzds.DeltaChunk;
import factorization.fzds.DimensionSliceEntity;
import factorization.fzds.Hammer;
import factorization.fzds.api.DeltaCapability;
import factorization.fzds.api.IDeltaChunk;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;

public class FZDSCommand
extends CommandBase {
    private static ArrayList subCommands = new ArrayList();
    public static SubCommand help;
    private static WeakReference currentSelection;
    private static Splitter comma;

    public String func_71517_b() {
        return "fzds";
    }

    public int func_82362_a() {
        return 2;
    }

    public static SubCommand add(SubCommand cmd, Requires ... reqs) {
        for (Requires r : reqs) {
            r.apply(cmd);
        }
        cmd.reqs = reqs;
        subCommands.add(cmd);
        return cmd;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            boolean op = MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(player.field_71092_bJ);
            boolean cr = player.field_71075_bZ.field_75098_d;
            if (!op && !cr) {
                sender.func_70006_a("You must be op or in creative mode to use these commands");
                return;
            }
        }
        if (args.length == 0) {
            this.runCommand(help, sender, new String[]{"help"});
            return;
        }
        String cmd = args[0];
        for (SubCommand sc : subCommands) {
            for (String alias : sc.altNames) {
                if (!alias.equalsIgnoreCase(cmd)) continue;
                this.runCommand(sc, sender, args);
                return;
            }
        }
        sender.func_70006_a("Not a command");
    }

    public static void setSelection(IDeltaChunk dse) {
        currentSelection = new WeakReference<IDeltaChunk>(dse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCommand(SubCommand cmd, ICommandSender sender, String[] args) {
        cmd.reset();
        cmd.setup(sender);
        ArrayList<String> cleanedArgs = new ArrayList<String>();
        for (String a : args) {
            if (Strings.isNullOrEmpty((String)a)) continue;
            if (a.startsWith("@")) {
                if (!cmd.op) {
                    throw new CommandException("You are not allowed to use arbitrary players", new Object[0]);
                }
                cmd.player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(a.substring(1));
                if (cmd.player != null) continue;
                throw new CommandException("Player not found", new Object[0]);
            }
            if (a.startsWith("#")) {
                if (!cmd.op) {
                    throw new CommandException("You are not allowed to use arbitrary locations", new Object[0]);
                }
                ArrayList<Integer> parts = new ArrayList<Integer>();
                for (String stupid : comma.split((CharSequence)a.substring(1))) {
                    parts.add(Integer.parseInt(stupid));
                }
                WorldServer w = DimensionManager.getWorld((int)((Integer)parts.get(0)));
                cmd.user = new Coord((World)w, (Integer)parts.get(1), (Integer)parts.get(2), (Integer)parts.get(3));
                continue;
            }
            cleanedArgs.add(a);
        }
        if (cmd.player != null) {
            cmd.user = new Coord((Entity)cmd.player);
        }
        if (cmd.user != null) {
            cmd.world = cmd.user.w;
        }
        if (cmd.needPlayer && cmd.player == null) {
            throw new CommandException("No player specified", new Object[0]);
        }
        if (cmd.needCoord && cmd.user == null) {
            throw new CommandException("No coordinate specified", new Object[0]);
        }
        if (cmd.needOp && !cmd.op) {
            throw new CommandException("Insufficient permissions", new Object[0]);
        }
        if (cmd.needSelection && cmd.selected == null) {
            throw new CommandException("No DSE selected", new Object[0]);
        }
        cmd.arg0 = (String)cleanedArgs.remove(0);
        try {
            String[] sc = new String[cleanedArgs.size()];
            cmd.call(cleanedArgs.toArray(sc));
        }
        finally {
            cmd.reset();
        }
    }

    static String join(ArrayList cmd) {
        String ret = "";
        for (SubCommand sc : cmd) {
            ret = ret + " ";
            if (sc.help.length == 1) {
                ret = ret + sc.help[0];
                continue;
            }
            ret = ret + "(" + sc.help[0];
            for (int i = 1; i < sc.help.length; ++i) {
                ret = ret + " " + sc.help[i];
            }
            ret = ret + ")";
        }
        return ret;
    }

    private static String pick(String ... bits) {
        for (int i = 0; i < bits.length - 1; i += 2) {
            if (!bits[i].equalsIgnoreCase(bits[i + 1])) continue;
            return bits[i + 1];
        }
        return bits[bits.length - 1];
    }

    static {
        currentSelection = new WeakReference<Object>(null);
        comma = Splitter.on((String)",");
        help = FZDSCommand.add(new SubCommand(new String[]{"help", "[subcmd]+"}){

            @Override
            String details() {
                return "Gives a list of all subcommands, or information about the given subcommands";
            }

            @Override
            void call(String[] args) {
                boolean any = false;
                block0: for (String s : args) {
                    any = true;
                    for (SubCommand sc : subCommands) {
                        for (String alt : sc.altNames) {
                            if (!alt.equalsIgnoreCase(s)) continue;
                            sc.arg0 = s;
                            sc.sender = this.sender;
                            sc.inform();
                            if (sc == this) break block0;
                            sc.reset();
                            break block0;
                        }
                    }
                }
                if (any) {
                    return;
                }
                ArrayList<SubCommand> good = new ArrayList<SubCommand>();
                for (SubCommand sc : subCommands) {
                    if (sc != this) {
                        sc.setup(this.sender);
                    }
                    if (sc.appropriate()) {
                        good.add(sc);
                    }
                    if (sc == this) continue;
                    sc.reset();
                }
                this.sender.func_70006_a(FZDSCommand.join(good));
                this.sender.func_70006_a("To specify a Coord or player: #worldId,x,y,z @PlayerName");
                this.sender.func_70006_a("Best commands: cut d drop");
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"go|gob|got"}){

            @Override
            String details() {
                return "Teleports player to the " + FZDSCommand.pick(new String[]{"gob", "bottom", "got", "top", "center"}) + " of the selection, in Hammerspace. Be ready to fly.";
            }

            @Override
            public void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = this.arg0.equalsIgnoreCase("gob") ? this.selected.getCorner() : (this.arg0.equalsIgnoreCase("got") ? this.selected.getFarCorner() : this.selected.getCenter());
                if (DimensionManager.getWorld((int)Core.dimension_slice_dimid) != this.player.field_70170_p) {
                    manager.transferPlayerToDimension(this.player, Core.dimension_slice_dimid, (Teleporter)tp);
                } else {
                    --tp.destination.x;
                    tp.destination.moveToTopBlock();
                    this.player.func_70634_a((double)tp.destination.x + 0.5, (double)tp.destination.y, (double)tp.destination.z + 0.5);
                }
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"enterhammer"}){

            @Override
            String details() {
                return "Teleports the player into hammerspace";
            }

            @Override
            void call(String[] args) {
                if (this.player.field_71093_bK == Hammer.dimensionID) {
                    return;
                }
                DSTeleporter tp = this.getTp();
                tp.destination.set(DeltaChunk.getServerShadowWorld(), 0, 64, 0);
                manager.transferPlayerToDimension(this.player, Hammer.dimensionID, (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"leave"}){

            @Override
            String details() {
                return "Teleports the player to the overworld";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                WorldServer w = DimensionManager.getWorld((int)0);
                if (w == this.player.field_70170_p) {
                    return;
                }
                ChunkCoordinates target = this.player.func_70997_bJ();
                if (target == null) {
                    target = w.func_72861_E();
                }
                if (target != null) {
                    tp.destination.set(target);
                }
                manager.transferPlayerToDimension(this.player, 0, (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"jump"}){

            @Override
            String details() {
                return "Warps player to the selection";
            }

            @Override
            void call(String[] args) {
                DSTeleporter tp = this.getTp();
                tp.destination = new Coord(this.selected);
                manager.transferPlayerToDimension(this.player, this.selected.field_71093_bK, (Teleporter)tp);
            }
        }, Requires.PLAYER, Requires.CREATIVE, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"tome"}){

            @Override
            String details() {
                return "Warps selection to player";
            }

            @Override
            void call(String[] args) {
                this.selected.field_70165_t = this.user.x;
                this.selected.field_70163_u = this.user.y;
                this.selected.field_70161_v = this.user.z;
            }
        }, Requires.COORD, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"cut|rcut|copy|rcopy", "x,y,z", "x,y,z"}){

            @Override
            String details() {
                return "Creates a Slice from the range given" + FZDSCommand.pick(new String[]{"rcut", ", relative to user's position", ""});
            }

            @Override
            void call(String[] args) {
                Coord base = this.arg0.startsWith("r") ? this.user.copy() : new Coord(this.user.w, 0, 0, 0);
                boolean copy = this.arg0.contains("copy");
                Coord low = base.add(DeltaCoord.parse(args[0]));
                Coord up = base.add(DeltaCoord.parse(args[1]));
                Coord.sort(low, up);
                DeltaCoord dimensions = up.difference(low);
                int area = Math.abs(dimensions.x * dimensions.y * dimensions.z);
                if (area > Hammer.max_fzds_grab_area) {
                    this.sender.func_70006_a("The area is too big: " + area);
                    return;
                }
                final Coord lower = low.copy();
                final Coord upper = up.copy();
                Core.notify(null, lower, "Low", new String[0]);
                Core.notify(null, upper, "High", new String[0]);
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, lower, upper, new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                        Coord here = user.copy();
                        for (int x = lower.x; x <= upper.x; ++x) {
                            for (int y = lower.y; y <= upper.y; ++y) {
                                for (int z = lower.z; z <= upper.z; ++z) {
                                    here.set(here.w, x, y, z);
                                    destination.include(here);
                                }
                            }
                        }
                    }
                }, !copy);
                dse.permit(DeltaCapability.ROTATE).forbid(DeltaCapability.COLLIDE);
                dse.field_70170_p.func_72838_d((Entity)dse);
                FZDSCommand.setSelection(dse);
            }
        }, Requires.COORD);
        FZDSCommand.add(new SubCommand(new String[]{"include"}){

            @Override
            void call(String[] args) {
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"drop"}){

            @Override
            String details() {
                return "Returns a Slice's blocks to the world, destroying the Slice";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, true);
                DeltaChunk.clear(this.selected);
                this.selected.func_70106_y();
                FZDSCommand.setSelection(null);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"paste"}){

            @Override
            String details() {
                return "Clones a Slice's blocks into the world";
            }

            @Override
            void call(String[] args) {
                DeltaChunk.paste(this.selected, true);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"oracle"}){

            @Override
            void call(String[] args) {
                DeltaChunk.AreaMap do_nothing = new DeltaChunk.AreaMap(){

                    @Override
                    public void fillDse(DeltaChunk.DseDestination destination) {
                    }
                };
                IDeltaChunk dse = DeltaChunk.makeSlice(Hammer.fzds_command_channel, this.user, this.user, do_nothing, false);
                dse.permit(DeltaCapability.ORACLE);
                dse.field_70170_p.func_72838_d((Entity)dse);
            }
        }, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"grass"}){

            @Override
            String details() {
                return "Places a grass block at the user's feet";
            }

            @Override
            void call(String[] args) {
                this.user.add(0, -1, 0).setId((Block)Block.field_71980_u);
            }
        }, Requires.COORD, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"snap"}){

            @Override
            String details() {
                return "Rounds the Slice's position down to integers";
            }

            @Override
            void call(String[] args) {
                this.selected.field_70165_t = (int)this.selected.field_70165_t;
                this.selected.field_70163_u = (int)this.selected.field_70163_u;
                this.selected.field_70161_v = (int)this.selected.field_70161_v;
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"removeall"}){

            @Override
            String details() {
                return "Removes all Slices";
            }

            @Override
            void call(String[] args) {
                int i = 0;
                for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
                    for (Entity ent : w.field_72996_f) {
                        if (!(ent instanceof DimensionSliceEntity)) continue;
                        ent.func_70106_y();
                        ++i;
                    }
                }
                DeltaChunk.getSlices((World)MinecraftServer.func_71276_C().func_71218_a(0)).clear();
                this.sender.func_70006_a("Removed " + i);
            }
        }, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"selection"}){

            @Override
            String details() {
                return "Prints the selection";
            }

            @Override
            void call(String[] args) {
                this.sender.func_70006_a("> " + (Object)((Object)this.selected));
                FZDSCommand.setSelection(this.selected);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"rot?"}){

            @Override
            String details() {
                return "Gives the rotation & angular velocity of the selection";
            }

            @Override
            void call(String[] args) {
                this.sender.func_70006_a("r = " + this.selected.getRotation());
                this.sender.func_70006_a("\u03c9 = " + this.selected.getRotationalVelocity());
                if (!this.selected.can(DeltaCapability.ROTATE)) {
                    this.sender.func_70006_a("(Does not have the ROTATE cap, so this is meaningless)");
                }
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"+|-"}){

            @Override
            String details() {
                return "Changes which (loaded) Slice is selected";
            }

            @Override
            void call(String[] args) {
                boolean add = this.arg0.equals("+");
                Iterator it = DeltaChunk.getSlices((World)MinecraftServer.func_71276_C().func_71218_a(0)).iterator();
                IDeltaChunk first = null;
                IDeltaChunk prev = null;
                IDeltaChunk next = null;
                IDeltaChunk last = null;
                boolean found_current = false;
                while (it.hasNext()) {
                    IDeltaChunk here = (IDeltaChunk)((Object)it.next());
                    if (here.field_70128_L) {
                        Core.logWarning((Object)((Object)here) + " was not removed", new Object[0]);
                        it.remove();
                        continue;
                    }
                    last = here;
                    if (first == null) {
                        first = last;
                    }
                    if (!found_current) {
                        prev = last;
                    }
                    if (found_current && next == null) {
                        next = last;
                    }
                    if (last != this.selected) continue;
                    found_current = true;
                }
                if (first == null) {
                    this.sender.func_70006_a("There are no DSEs loaded");
                    FZDSCommand.setSelection(null);
                    return;
                }
                this.selected = this.selected == null ? (add ? first : last) : (this.selected == last && add ? first : (this.selected == first && !add ? last : (add ? next : prev)));
                this.sender.func_70006_a("> " + (Object)((Object)this.selected));
                FZDSCommand.setSelection(this.selected);
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"remove"}){

            @Override
            String details() {
                return "Destroys the selection";
            }

            @Override
            void call(String[] args) {
                this.selected.func_70106_y();
                FZDSCommand.setSelection(null);
                this.sender.func_70006_a("Made dead");
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"sr|sw", "angle\u00b0", "[direction=UP]"}){

            @Override
            String details() {
                return "Sets the Slice's rotation";
            }

            @Override
            void call(String[] args) {
                ForgeDirection dir;
                if (args.length != 2 && args.length != 1) {
                    throw new SyntaxErrorException();
                }
                if (!this.selected.can(DeltaCapability.ROTATE)) {
                    this.sender.func_70006_a("Selection does not have the rotation cap");
                    return;
                }
                double theta = Math.toRadians(Double.parseDouble(args[0]));
                try {
                    dir = args.length == 2 ? ForgeDirection.valueOf((String)args[1].toUpperCase()) : ForgeDirection.UP;
                }
                catch (IllegalArgumentException e) {
                    String msg = "Direction must be:";
                    for (ForgeDirection d : ForgeDirection.values()) {
                        if (d == ForgeDirection.UNKNOWN) continue;
                        msg = msg + " " + d;
                    }
                    this.sender.func_70006_a(msg);
                    return;
                }
                int derivative = -1;
                if (this.arg0.equalsIgnoreCase("sr")) {
                    derivative = 0;
                } else if (this.arg0.equalsIgnoreCase("sw")) {
                    derivative = 1;
                } else {
                    throw new SyntaxErrorException();
                }
                Quaternion toMod = derivative == 0 ? this.selected.getRotation() : this.selected.getRotationalVelocity();
                toMod.update(Quaternion.getRotationQuaternionRadians(theta, dir));
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"d|s|v|r|w", "+|=", "[W=1]", "X", "Y", "Z"}){

            @Override
            String details() {
                return "Changes or sets displacement/velocity/rotation/angular_velocity";
            }

            @Override
            void call(String[] args) {
                int type = this.arg0.charAt(0);
                int n = type = type == 115 ? 100 : (int)type;
                if (args.length != 4 && args.length != 5) {
                    if (type == 100 || type == 118) {
                        this.sender.func_70006_a("Usage: /fzds d(isplacement)|v(elocity) +|= X Y Z");
                    }
                    if (type == 114 || type == 119) {
                        this.sender.func_70006_a("Usage: /fzds r(otation)|w(rotational velocity) +|= [W=1] X Y Z (a quaternion; cmds sr & sw are simpler)");
                    }
                    return;
                }
                int i = 0;
                double w = 1.0;
                if (args.length == 5) {
                    w = Double.parseDouble(args[1]);
                    i = 1;
                }
                double x = Double.parseDouble(args[1 + i]);
                double y = Double.parseDouble(args[2 + i]);
                double z = Double.parseDouble(args[3 + i]);
                if (!(type != 114 && type != 119 || this.selected.can(DeltaCapability.ROTATE))) {
                    this.sender.func_70006_a("Selection does not have the ROTATE cap");
                    return;
                }
                if (args[0].equals("+")) {
                    if (type == 100 || type == 115) {
                        this.selected.func_70107_b(this.selected.field_70165_t + x, this.selected.field_70163_u + y, this.selected.field_70161_v + z);
                    } else if (type == 118) {
                        this.selected.func_70024_g(x / 20.0, y / 20.0, z / 20.0);
                    } else if (type == 114) {
                        this.selected.getRotation().incrAdd(new Quaternion(w, x, y, z));
                    } else if (type == 119) {
                        this.selected.getRotationalVelocity().incrAdd(new Quaternion(w, x, y, z));
                    } else {
                        this.sender.func_70006_a("Not a command?");
                    }
                } else if (args[0].equals("=")) {
                    if (type == 100 || type == 115) {
                        this.selected.func_70107_b(x, y, z);
                    } else if (type == 118) {
                        this.selected.field_70159_w = 0.0;
                        this.selected.field_70181_x = 0.0;
                        this.selected.field_70179_y = 0.0;
                        this.selected.func_70024_g(x / 20.0, y / 20.0, z / 20.0);
                    } else if (type == 114) {
                        this.selected.setRotation(new Quaternion(w, x, y, z));
                    } else if (type == 119) {
                        Quaternion omega = new Quaternion(w, x, y, z);
                        this.selected.setRotationalVelocity(omega);
                    } else {
                        this.sender.func_70006_a("Not a command?");
                    }
                    this.selected.getRotation().incrNormalize();
                    this.selected.getRotationalVelocity().incrNormalize();
                } else {
                    this.sender.func_70006_a("+ or =?");
                }
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"dirty"}){

            @Override
            String details() {
                return "[Moves the selection back and forth]";
            }

            @Override
            void call(String[] args) {
                this.selected.getRotationalVelocity().w *= -1.0;
                this.selected.getRotation().w *= -1.0;
                this.selected.getRotation().w += 0.1;
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"caps"}){

            @Override
            String details() {
                return "Lists the available Caps";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (DeltaCapability cap : DeltaCapability.values()) {
                    r = r + " " + (Object)((Object)cap);
                }
                this.sender.func_70006_a(r);
            }
        }, new Requires[0]);
        FZDSCommand.add(new SubCommand(new String[]{"cap?"}){

            @Override
            String details() {
                return "Lists the Caps enabled on the selection";
            }

            @Override
            void call(String[] args) {
                String r = "";
                for (DeltaCapability cap : DeltaCapability.values()) {
                    if (!this.selected.can(cap)) continue;
                    r = r + " " + (Object)((Object)cap);
                }
                this.sender.func_70006_a(r);
            }
        }, Requires.SELECTION);
        FZDSCommand.add(new SubCommand(new String[]{"cap+|cap-", "CAP+"}){

            @Override
            String details() {
                return "Gives or takes away Caps. May cause client desyncing.";
            }

            @Override
            void call(String[] args) {
                for (String a : args) {
                    DeltaCapability cap = DeltaCapability.valueOf(a);
                    if (this.arg0.equalsIgnoreCase("cap+")) {
                        this.selected.permit(cap);
                        continue;
                    }
                    this.selected.forbid(cap);
                }
            }
        }, Requires.SELECTION, Requires.OP);
        FZDSCommand.add(new SubCommand(new String[]{"scale", "newScale"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(DeltaCapability.SCALE)) {
                    this.sender.func_70006_a("Selection doesn't have the SCALE cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).scale = Float.parseFloat(args[0]);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"alpha", "newOpacity"}){

            @Override
            void call(String[] args) {
                if (!this.selected.can(DeltaCapability.TRANSPARENT)) {
                    this.sender.func_70006_a("Selection doesn't have the TRANSPARENT cap");
                    return;
                }
                ((DimensionSliceEntity)this.selected).opacity = Float.parseFloat(args[0]);
            }
        }, Requires.SELECTION, Requires.CREATIVE);
        FZDSCommand.add(new SubCommand(new String[]{"setBlockMethod 0=intrusive_lowlevel;1=world.isRemote;2=world.setBlock"}){

            @Override
            void call(String[] args) {
                int mode = Integer.parseInt(args[0]);
            }
        }, Requires.OP, Requires.CREATIVE);
    }

    public static enum Requires {
        OP,
        PLAYER,
        COORD,
        SELECTION,
        CREATIVE;


        void apply(SubCommand sc) {
            switch (this) {
                case OP: {
                    sc.needOp = true;
                    break;
                }
                case PLAYER: {
                    sc.needPlayer = true;
                    break;
                }
                case COORD: {
                    sc.needCoord = true;
                    break;
                }
                case SELECTION: {
                    sc.needSelection = true;
                    break;
                }
                case CREATIVE: {
                    sc.needCreative = true;
                }
            }
        }
    }

    public static abstract class SubCommand {
        String[] help;
        ArrayList altNames = new ArrayList();
        private boolean needOp;
        private boolean needPlayer;
        private boolean needCoord;
        private boolean needSelection;
        private boolean needCreative;
        Requires[] reqs;
        private static Splitter pipe = Splitter.on((char)'|');
        static ServerConfigurationManager manager = MinecraftServer.func_71196_a((MinecraftServer)MinecraftServer.func_71276_C());
        String arg0;
        ICommandSender sender;
        EntityPlayerMP player;
        World world;
        Coord user;
        boolean op;
        boolean creative;
        IDeltaChunk selected;

        public SubCommand(String ... help) {
            this.help = help;
            if (help.length == 0) {
                throw new IllegalArgumentException("No subcommand name");
            }
            for (String s : pipe.split((CharSequence)help[0])) {
                this.altNames.add(s);
            }
        }

        public SubCommand() {
        }

        abstract void call(String[] var1);

        private void reset() {
            this.sender = null;
            this.player = null;
            this.world = null;
            this.user = null;
            this.op = false;
            this.creative = false;
            this.selected = null;
        }

        private void setup(ICommandSender sender) {
            this.sender = sender;
            if (sender instanceof EntityPlayerMP) {
                this.player = (EntityPlayerMP)sender;
            }
            if (sender instanceof TileEntity) {
                this.user = new Coord((TileEntity)sender);
            }
            this.selected = (IDeltaChunk)((Object)currentSelection.get());
            if (sender.func_70003_b(4, "stop")) {
                this.op = true;
            }
            if (sender instanceof TileEntityCommandBlock) {
                this.op = true;
            }
            if (this.op) {
                this.creative = true;
            }
        }

        DSTeleporter getTp() {
            DSTeleporter tp = new DSTeleporter((WorldServer)this.player.field_70170_p);
            tp.destination = new Coord(this.player.field_70170_p, 0, 0, 0);
            return tp;
        }

        boolean appropriate() {
            if (this.needOp && !this.op) {
                return false;
            }
            return !this.needCreative || this.creative;
        }

        String details() {
            return null;
        }

        final String getHelp() {
            String msg = "";
            boolean first = true;
            for (String m : this.help) {
                if (first) {
                    first = false;
                } else {
                    msg = msg + " ";
                }
                msg = msg + m;
            }
            return msg;
        }

        final String getNeeds() {
            if (this.reqs.length == 0) {
                return "";
            }
            String ret = "[Need:";
            for (Requires r : this.reqs) {
                ret = ret + " " + (Object)((Object)r);
            }
            return ret + "]";
        }

        void inform() {
            String msg = this.getHelp();
            String d = this.details();
            if (d != null) {
                msg = msg + ": " + d;
            }
            this.sender.func_70006_a(msg);
        }
    }
}

