/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.servo.Instruction;
import factorization.common.servo.ServoMotor;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class SetDirection
extends Instruction {
    ForgeDirection dir = ForgeDirection.UP;

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return BlockIcons.servo$set_direction.side_W;
        }
        return BlockIcons.servo$set_direction.get(this.dir.getOpposite(), side);
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block2, ForgeDirection side) {
        if (SetDirection.playerHasProgrammer(player)) {
            int i = this.dir.ordinal();
            this.dir = ForgeDirection.getOrientation((int)((i + 1) % 6));
            return true;
        }
        return false;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        ForgeDirection d = this.dir.getOpposite();
        if (motor.testDirection(d)) {
            motor.nextDirection = d;
            motor.swapOrientations();
        } else {
            motor.nextDirection = d;
        }
    }

    @Override
    public String getName() {
        return "fz.instruction.setdirection";
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.dir = (ForgeDirection)data.as(Share.MUTABLE, "dir").putEnum((Enum)this.dir);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return new ItemStack(Item.field_77704_l);
    }
}

