/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo.instructions;

import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.servo.ActuatorItem;
import factorization.common.servo.Instruction;
import factorization.common.servo.ServoMotor;
import factorization.common.servo.ServoStack;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ConfigureActuator
extends Instruction {
    boolean dump_config = false;

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        this.dump_config = data.as(Share.VISIBLE, prefix + "dump").putBoolean(this.dump_config);
        return this;
    }

    @Override
    protected ItemStack getRecipeItem() {
        return Core.registry.dark_iron_sprocket;
    }

    @Override
    public void motorHit(ServoMotor motor) {
        ServoStack config = motor.getServoStack(1);
        ItemStack actuator = null;
        FactorizationUtil.FzInv inv = motor.getInv();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack is = inv.get(i);
            if (is == null || !(is.func_77973_b() instanceof ActuatorItem)) continue;
            actuator = is;
            break;
        }
        if (actuator == null) {
            motor.putError("No actuator to configure");
            return;
        }
        ActuatorItem actualator = (ActuatorItem)actuator.func_77973_b();
        try {
            DataHelper stack;
            if (this.dump_config) {
                stack = config.getDataHelper(false);
                DataInNBT nbt = new DataInNBT(FactorizationUtil.getTag(actuator));
                stack.as(Share.VISIBLE, "");
                nbt.as(Share.VISIBLE, "");
                stack.put(nbt.put(actualator.getState()));
            } else {
                stack = config.getDataHelper(true);
                DataOutNBT nbt = new DataOutNBT(FactorizationUtil.getTag(actuator));
                stack.as(Share.VISIBLE, "");
                nbt.as(Share.VISIBLE, "");
                nbt.put(stack.put(actualator.getState()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Icon getIcon(ForgeDirection side) {
        if (this.dump_config) {
            return BlockIcons.servo$deconfigure;
        }
        return BlockIcons.servo$configure;
    }

    @Override
    public String getName() {
        return "fz.instruction.configureactuator";
    }

    @Override
    public boolean onClick(EntityPlayer player, Coord block2, ForgeDirection side) {
        if (ConfigureActuator.playerHasProgrammer(player)) {
            this.dump_config = !this.dump_config;
            return true;
        }
        return false;
    }

    @Override
    public String getInfo() {
        return this.dump_config ? "Dump Configuration" : "Load Configuration";
    }
}

