/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataInPacket;
import factorization.api.datahelpers.DataOutNBT;
import factorization.api.datahelpers.DataOutPacket;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.servo.Instruction;
import factorization.common.servo.ServoMotor;
import factorization.common.servo.ServoStack;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public abstract class ServoComponent
implements IDataSerializable {
    private static HashMap componentMap = new HashMap(50, 0.5f);
    private static final String componentTagKey = "SCId";
    private static BiMap the_idMap = null;

    public static void register(Class componentClass) {
        String name2;
        try {
            ServoComponent decor = (ServoComponent)componentClass.newInstance();
            name2 = decor.getName();
        }
        catch (Throwable e) {
            Core.logSevere("Unable to instantiate %s: %s", componentClass, e);
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        componentMap.put(name2, componentClass);
    }

    public static Class getComponent(String name2) {
        return (Class)componentMap.get(name2);
    }

    private static BiMap getPacketIdMap() {
        if (the_idMap == null) {
            ArrayList names = new ArrayList(componentMap.keySet());
            Collections.sort(names);
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (short i = 0; i < names.size(); i = (short)(i + 1)) {
                builder.put((Object)i, componentMap.get(names.get(i)));
            }
            the_idMap = builder.build();
        }
        return the_idMap;
    }

    public static Iterable getComponents() {
        return ServoComponent.getPacketIdMap().values();
    }

    public short getNetworkId() {
        BiMap map = ServoComponent.getPacketIdMap().inverse();
        Short o = (Short)map.get(this.getClass());
        if (o == null) {
            throw new IllegalArgumentException(this.getClass() + " is not a registered ServoComponent");
        }
        return o;
    }

    static ServoComponent load(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b(componentTagKey)) {
            return null;
        }
        String componentName = tag.func_74779_i(componentTagKey);
        Class componentClass = ServoComponent.getComponent(componentName);
        if (componentClass == null) {
            Core.logWarning("Unknown servo component with ID %s", componentName);
            return null;
        }
        try {
            ServoComponent decor = (ServoComponent)componentClass.newInstance();
            new DataInNBT(tag).as(Share.VISIBLE, "sc").put(decor);
            return decor;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final void save(NBTTagCompound tag) {
        tag.func_74778_a(componentTagKey, this.getName());
        try {
            new DataOutNBT(tag).as(Share.VISIBLE, "sc").put(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void writeToPacket(DataOutputStream dos) throws IOException {
        dos.writeShort(this.getNetworkId());
        new DataOutPacket(dos, Side.SERVER).as(Share.VISIBLE, "sc").put(this);
    }

    static ServoComponent readFromPacket(DataInputStream dis) throws IOException {
        short id = dis.readShort();
        Class componentClass = (Class)ServoComponent.getPacketIdMap().get((Object)id);
        if (componentClass == null) {
            Core.logWarning("Unknown servo component with #ID %s", id);
            return null;
        }
        try {
            ServoComponent decor = (ServoComponent)componentClass.newInstance();
            new DataInPacket(dis, Side.CLIENT).as(Share.VISIBLE, "sc").put(decor);
            return decor;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack toItem() {
        ItemStack ret = this instanceof Instruction ? new ItemStack((Item)Core.registry.servo_widget_instruction) : new ItemStack((Item)Core.registry.servo_widget_decor);
        NBTTagCompound tag = new NBTTagCompound();
        this.save(tag);
        ret.func_77982_d(tag);
        String name2 = this.getName();
        int dmg = Math.abs(name2.hashCode()) % Short.MAX_VALUE;
        ret.func_77964_b(dmg);
        return ret;
    }

    public static ServoComponent fromItem(ItemStack is) {
        if (!is.func_77942_o()) {
            return null;
        }
        return ServoComponent.load(is.func_77978_p());
    }

    public abstract boolean onClick(EntityPlayer var1, Coord var2, ForgeDirection var3);

    public abstract boolean onClick(EntityPlayer var1, ServoMotor var2);

    public abstract String getName();

    public final boolean configure(ServoStack stack) {
        try {
            stack.getDataHelper(true).put(this);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public final void deconfigure(LinkedList stack) {
        ServoStack out = new ServoStack();
        out.setContentsList(stack);
        try {
            out.getDataHelper(false).put(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(Coord var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic() {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderStatic(null, FactorizationUtil.getRB());
        tess.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List info) {
    }

    public static void registerRecursivelyFromPackage(String packageName) {
        ClassPath cp;
        ClassLoader loader = ServoComponent.class.getClassLoader();
        try {
            cp = ClassPath.from((ClassLoader)loader);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        for (ClassPath.ClassInfo ci : cp.getTopLevelClassesRecursive(packageName)) {
            Class<?> someClass;
            try {
                someClass = loader.loadClass(ci.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            if (!ServoComponent.class.isAssignableFrom(someClass) || someClass.isInterface() || Modifier.isAbstract(someClass.getModifiers())) continue;
            Class<?> cl = someClass;
            ServoComponent.register(cl);
        }
    }

    public static void setupRecipes() {
        for (Class klazz : componentMap.values()) {
            try {
                ((ServoComponent)klazz.newInstance()).addRecipes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addRecipes() {
    }

    static {
        ServoComponent.registerRecursivelyFromPackage("factorization.common.servo");
    }
}

