/*
 * Decompiled with CFR 0.152.
 */
package factorization.common.servo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.servo.Decorator;
import factorization.common.servo.Instruction;
import factorization.common.servo.ServoComponent;
import factorization.common.servo.TileEntityServoRail;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemServoRailWidget
extends Item {
    private List subItemsCache = null;

    public ItemServoRailWidget(int itemId) {
        super(itemId);
        this.func_77655_b("factorization:servo/component");
        Core.tab(this, Core.TabType.SERVOS);
    }

    public String func_77667_c(ItemStack is) {
        ServoComponent sc = this.get(is);
        if (sc == null) {
            return super.func_77658_a();
        }
        return super.func_77667_c(is) + "." + sc.getName();
    }

    public String func_77628_j(ItemStack is) {
        String s = super.func_77628_j(is);
        if (s == null || s.length() == 0) {
            s = this.func_77667_c(is);
        }
        return s;
    }

    ServoComponent get(ItemStack is) {
        if (!is.func_77942_o()) {
            return null;
        }
        return ServoComponent.load(is.func_77978_p());
    }

    void update(ItemStack is, ServoComponent sc) {
        if (sc != null) {
            sc.save(FactorizationUtil.getTag(is));
        } else {
            is.func_77982_d(null);
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        ServoComponent sc = this.get(is);
        if (sc == null) {
            return is;
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float vx, float vy, float vz) {
        ServoComponent sc = this.get(is);
        if (sc == null) {
            return false;
        }
        if (sc instanceof Decorator) {
            Decorator dec = (Decorator)sc;
            Coord here = new Coord(world, x, y, z);
            TileEntityServoRail rail = (TileEntityServoRail)here.getTE(TileEntityServoRail.class);
            if (rail != null && rail.decoration == null) {
                rail.setDecoration(dec);
            }
            if (world.field_72995_K) {
                here.redraw();
            } else {
                here.markBlockForUpdate();
            }
            if (!dec.isFreeToPlace() && !player.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
        }
        return super.func_77648_a(is, player, world, x, y, z, side, vx, vy, vz);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        super.func_77624_a(is, player, list, verbose);
        Core.brand(is, list);
        ServoComponent sc = this.get(is);
        if (sc != null) {
            sc.addInformation(list);
        }
    }

    void loadSubItems() {
        if (this.subItemsCache != null) {
            return;
        }
        this.subItemsCache = new ArrayList(100);
        ArrayList temp = new ArrayList();
        for (Class scClass : ServoComponent.getComponents()) {
            try {
                ServoComponent sc = (ServoComponent)scClass.newInstance();
                if (sc instanceof Instruction && this == Core.registry.servo_widget_instruction) {
                    this.subItemsCache.add(sc.toItem());
                    continue;
                }
                if (this != Core.registry.servo_widget_decor || sc instanceof Instruction) continue;
                this.subItemsCache.add(sc.toItem());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tab, List list) {
        this.loadSubItems();
        list.addAll(this.subItemsCache);
    }

    public Icon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.getIcon(stack, renderPass);
    }

    public Icon getIcon(ItemStack stack, int pass) {
        if (pass != 0) {
            return null;
        }
        ServoComponent sc = this.get(stack);
        Icon ret = null;
        if (sc instanceof Decorator) {
            ret = ((Decorator)sc).getIcon(ForgeDirection.UNKNOWN);
        }
        if (ret == null) {
            ret = BlockIcons.uv_test;
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 1;
    }
}

