/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityWrathLamp
extends TileEntityCommon {
    static final int radius = 6;
    static final int radiusSq = 36;
    static final int diameter = 12;
    static final int maxDepth = 24;
    private short[] beamDepths = new short[169];
    private Updater updater = new Idler();
    static boolean isUpdating = false;
    static int update_count;
    static final int update_limit = 512;
    static PriorityQueue airToUpdate;
    static final int NOTIFY_NEIGHBORS = 1;
    static final int UPDATE_CLIENT = 2;
    static boolean spammed_console;
    static final int[] deltas;
    static HashSet toVisit;

    public static void handleAirUpdates() {
        update_count = 0;
        while (update_count < 512 && airToUpdate.size() > 0) {
            ((Coord)airToUpdate.remove()).check();
        }
    }

    @Override
    void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        super.onPlacedBy(player, is, side);
        this.updater = new InitialBuild();
    }

    static void doAirCheck(World w, int x, int y, int z) {
        if (w.field_72995_K) {
            return;
        }
        if (update_count > 512) {
            if (airToUpdate.size() > 8192) {
                if (!spammed_console) {
                    Core.logSevere("TileEntityWrathLamp.airToUpdate has %i entries!", airToUpdate.size());
                    spammed_console = true;
                }
                return;
            }
            airToUpdate.add(new Coord(w, x, y, z));
            return;
        }
        TileEntityWrathLamp lamp = TileEntityWrathLamp.findLightAirParent(w, x, y, z);
        if (lamp == null) {
            ++update_count;
            w.func_72832_d(x, y, z, 0, 0, 3);
        } else {
            lamp.activate(y);
        }
    }

    private int getDepthIndex(int x, int z) {
        int dx = this.field_70329_l - x;
        int dz = this.field_70327_n - z;
        dz += 6;
        if ((dx += 6) < 0 || dx > 12) {
            throw new IndexOutOfBoundsException("x = " + dx);
        }
        if (dz < 0 || dz > 12) {
            throw new IndexOutOfBoundsException("z = " + dz);
        }
        return dx + dz * 12;
    }

    static TileEntityWrathLamp findLightAirParent(World world, int x, int y, int z) {
        toVisit.clear();
        for (int dcx : deltas) {
            for (int dcz : deltas) {
                if (!world.func_72899_e(x + dcx, y, z + dcz)) continue;
                toVisit.add(world.func_72938_d(x + dcx, z + dcz));
            }
        }
        for (Chunk chunk : toVisit) {
            for (Object o : chunk.field_76648_i.values()) {
                TileEntityWrathLamp lamp;
                if (!(o instanceof TileEntityWrathLamp) || !(lamp = (TileEntityWrathLamp)o).lightsBlock(x, y, z)) continue;
                return lamp;
            }
        }
        return null;
    }

    private boolean inArea(int x, int y, int z) {
        if (y > this.field_70330_m) {
            return false;
        }
        if (y < this.field_70330_m - 24) {
            return false;
        }
        return this.field_70329_l - 6 <= x && x <= this.field_70329_l + 6 && this.field_70327_n - 6 <= z && z <= this.field_70327_n + 6;
    }

    private boolean lightsBlock(int x, int y, int z) {
        if (!this.inArea(x, y, z)) {
            return false;
        }
        short depth = this.beamDepths[this.getDepthIndex(x, z)];
        return y >= depth && depth != -1;
    }

    public void func_70316_g() {
        Core.profileStart("WrathLamp");
        isUpdating = true;
        this.updater = this.updater.update();
        isUpdating = false;
        Core.profileEnd();
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        Core.profileStart("WrathLamp");
        for (int x = this.field_70329_l - 6; x <= this.field_70329_l + 6; ++x) {
            for (int z = this.field_70327_n - 6; z <= this.field_70327_n + 6; ++z) {
                int id = this.field_70331_k.func_72798_a(x, this.field_70330_m, z);
                if (id != Core.registry.lightair_block.field_71990_ca) continue;
                if (this.field_70331_k.field_72995_K) {
                    this.field_70331_k.func_72832_d(x, this.field_70330_m, z, 0, 0, 1);
                    continue;
                }
                this.field_70331_k.func_94575_c(x, this.field_70330_m, z, 0);
            }
        }
        Core.profileEnd();
        if (this.field_70331_k.field_72995_K) {
            RelightTask task = new RelightTask(this.field_70331_k);
            task.func_70107_b(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72838_d((Entity)task);
        }
    }

    double dist(int x, int y, int z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    boolean eq(double a, double b) {
        return Math.abs(a - b) < 0.9;
    }

    float div(int a, int b) {
        if (b == 0) {
            return Math.signum(a) * 4095.0f;
        }
        return a / b;
    }

    boolean myTrace(int x, int z) {
        int dx = x - this.field_70329_l;
        int dz = z - this.field_70327_n;
        float idealm = this.div(dz, dx);
        float old_dist = Float.MAX_VALUE;
        while (x != this.field_70329_l || z != this.field_70327_n) {
            int id = this.field_70331_k.func_72798_a(x, this.field_70330_m, z);
            if (Block.field_71973_m[id] != null && Block.field_71973_m[id].func_71926_d() && Block.field_71971_o[id] != 0) {
                return false;
            }
            dx = x - this.field_70329_l;
            dz = z - this.field_70327_n;
            float m = this.div(dz, dx);
            int addx = (int)(-Math.signum(dx));
            int addz = (int)(-Math.signum(dz));
            if (addx == 0 && addz == 0) {
                return true;
            }
            if (addx == 0) {
                z += addz;
                continue;
            }
            if (addz == 0) {
                x += addx;
                continue;
            }
            float m_x = this.div(dz, dx + addx);
            float m_z = this.div(dz + addz, dx);
            if (Math.abs(idealm - m_x) <= Math.abs(idealm - m_z)) {
                x += addx;
                continue;
            }
            z += addz;
        }
        return true;
    }

    boolean clearTo(int x, int y, int z) {
        return this.myTrace(x, z);
    }

    @Override
    public void neighborChanged() {
        this.activate(this.field_70330_m);
    }

    void activate(int at_height) {
        this.updater = this.updater.getActive(at_height);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LAMP;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Lamp;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.dark_iron_block;
    }

    static {
        airToUpdate = new PriorityQueue(1024);
        spammed_console = false;
        deltas = new int[]{0, -16, 16};
        toVisit = new HashSet(45);
    }

    public static class RelightTask
    extends Entity {
        int delay;

        public RelightTask(World par1World) {
            super(par1World);
        }

        protected void func_70088_a() {
            this.delay = 80;
        }

        protected void func_70037_a(NBTTagCompound var1) {
        }

        protected void func_70014_b(NBTTagCompound var1) {
        }

        public void func_70071_h_() {
            --this.delay;
            if (this.delay == 0) {
                int r = 21;
                int x = (int)(this.field_70165_t - (double)r);
                while ((double)x <= this.field_70165_t + (double)r) {
                    int z = (int)(this.field_70161_v - (double)r);
                    while ((double)z <= this.field_70161_v + (double)r) {
                        int y = (int)this.field_70163_u;
                        while ((double)y >= this.field_70163_u - 24.0) {
                            this.field_70170_p.func_72969_x(x, y, z);
                            --y;
                        }
                        ++z;
                    }
                    ++x;
                }
                this.func_70106_y();
            }
        }
    }

    class Idler
    extends Updater {
        Idler() {
        }

        boolean couldUpdate(int dx, int dz) {
            return TileEntityWrathLamp.this.field_70331_k.func_72798_a(TileEntityWrathLamp.this.field_70329_l + dx, TileEntityWrathLamp.this.field_70330_m, TileEntityWrathLamp.this.field_70327_n + dz) == 0;
        }

        @Override
        public Updater update() {
            if (this.couldUpdate(0, 1) || this.couldUpdate(0, -1) || this.couldUpdate(1, 0) || this.couldUpdate(-1, 0)) {
                return new InitialBuild();
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            InitialBuild r = new InitialBuild();
            r.start_height = Math.max(r.start_height, start_height);
            return r;
        }
    }

    class InitialBuild
    extends Updater {
        int height;
        int start_delay;
        Updater next_updater;

        InitialBuild() {
            this.height = -100;
            this.start_delay = 20;
            this.next_updater = new Idler();
        }

        @Override
        public Updater update() {
            int z;
            int x;
            if (this.start_delay >= 0) {
                --this.start_delay;
                return this;
            }
            this.height = this.height == -100 ? (this.start_height == -100 ? TileEntityWrathLamp.this.field_70330_m : this.start_height) : --this.height;
            if (this.height < TileEntityWrathLamp.this.field_70330_m - 24) {
                return this.next_updater;
            }
            if (this.height == TileEntityWrathLamp.this.field_70330_m) {
                Arrays.fill(TileEntityWrathLamp.this.beamDepths, (short)0);
                for (x = TileEntityWrathLamp.this.field_70329_l - 6; x <= TileEntityWrathLamp.this.field_70329_l + 6; ++x) {
                    for (z = TileEntityWrathLamp.this.field_70327_n - 6; z <= TileEntityWrathLamp.this.field_70327_n + 6; ++z) {
                        if (TileEntityWrathLamp.this.clearTo(x, TileEntityWrathLamp.this.field_70330_m, z)) continue;
                        ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[((TileEntityWrathLamp)TileEntityWrathLamp.this).getDepthIndex((int)x, (int)z)] = -1;
                    }
                }
            }
            for (x = TileEntityWrathLamp.this.field_70329_l - 6; x <= TileEntityWrathLamp.this.field_70329_l + 6; ++x) {
                for (z = TileEntityWrathLamp.this.field_70327_n - 6; z <= TileEntityWrathLamp.this.field_70327_n + 6; ++z) {
                    int index = TileEntityWrathLamp.this.getDepthIndex(x, z);
                    if (TileEntityWrathLamp.this.beamDepths[index] != 0) continue;
                    int block2 = TileEntityWrathLamp.this.field_70331_k.func_72798_a(x, this.height, z);
                    int belowBlock = TileEntityWrathLamp.this.field_70331_k.func_72798_a(x, this.height - 3, z);
                    if (belowBlock != 0 && belowBlock != Core.registry.lightair_block.field_71990_ca && this.height != TileEntityWrathLamp.this.field_70330_m) {
                        ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[index] = (short)this.height;
                        continue;
                    }
                    if (block2 == 0 && TileEntityWrathLamp.this.field_70331_k.func_72798_a(x, this.height - 1, z) == Block.field_82515_ce.field_71990_ca) {
                        block2 = -1;
                    }
                    if (block2 == 0) {
                        Chunk chunk = TileEntityWrathLamp.this.field_70331_k.func_72938_d(x, z);
                        chunk.func_76592_a(x & 0xF, this.height, z & 0xF, Core.registry.lightair_block.field_71990_ca, 0);
                        TileEntityWrathLamp.this.field_70331_k.func_72902_n(x, this.height, z);
                        continue;
                    }
                    if (block2 == Core.registry.lightair_block.field_71990_ca || x == TileEntityWrathLamp.this.field_70329_l && this.height == TileEntityWrathLamp.this.field_70330_m && z == TileEntityWrathLamp.this.field_70327_n) continue;
                    ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[index] = (short)this.height;
                }
            }
            if (this.height == 0) {
                return this.next_updater;
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            if (!(this.next_updater instanceof InitialBuild)) {
                this.next_updater = new InitialBuild();
            }
            this.next_updater.start_height = Math.max(++start_height, this.next_updater.start_height);
            return this;
        }
    }

    abstract class Updater {
        int start_height = -100;

        Updater() {
        }

        abstract Updater update();

        abstract Updater getActive(int var1);
    }

    private static class Coord
    implements Comparable {
        World w;
        int x;
        int y;
        int z;

        Coord(World w, int x, int y, int z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void check() {
            TileEntityWrathLamp.doAirCheck(this.w, this.x, this.y, this.z);
        }

        public int compareTo(Coord o) {
            return o.y - this.y;
        }
    }
}

