/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.WireConnections;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityWire
extends TileEntityCommon
implements IChargeConductor {
    public byte supporting_side;
    private boolean extended_wire = false;
    Charge charge = new Charge(this);

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEADWIRE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        return false;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    byte getExtraInfo() {
        return this.supporting_side;
    }

    @Override
    void useExtraInfo(byte b) {
        this.supporting_side = b;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("side", this.supporting_side);
        this.charge.writeToNBT(tag, "charge");
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.supporting_side = tag.func_74771_c("side");
    }

    boolean find_support() {
        if (!this.extended_wire) {
            return false;
        }
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            if (!this.canPlaceAgainst(null, this.getCoord().towardSide(side), side)) continue;
            this.supporting_side = (byte)side;
            this.shareInfo();
            return true;
        }
        return false;
    }

    boolean is_directly_supported() {
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        if (!supporter.blockExists()) {
            return true;
        }
        return supporter.isSolidOnSide(this.supporting_side);
    }

    boolean is_supported() {
        if (this.is_directly_supported()) {
            return true;
        }
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null) {
            this.extended_wire = true;
            return parent.is_supported();
        }
        return false;
    }

    @Override
    boolean canPlaceAgainst(EntityPlayer player, Coord supporter, int side) {
        if (supporter.isSolidOnSide(side)) {
            return true;
        }
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null && parent.is_directly_supported()) {
            return parent.supporting_side != side && parent.supporting_side != CubeFace.oppositeSide(side);
        }
        return false;
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.charge.update();
    }

    @Override
    public void neighborChanged() {
        if (!this.is_supported()) {
            Core.registry.factory_block.func_71897_c(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, BlockClass.Wire.md, 0);
            Coord here = this.getCoord();
            here.setId(0);
            here.rmTE();
        }
    }

    int getComplexity(byte new_side) {
        this.supporting_side = new_side;
        int complexity = new WireConnections(this).getComplexity();
        for (Coord ne : this.getCoord().getNeighborsAdjacent()) {
            TileEntityWire w = (TileEntityWire)ne.getTE(TileEntityWire.class);
            if (w == null) continue;
            complexity += new WireConnections(w).getComplexity();
        }
        TileEntityWire below = (TileEntityWire)this.getCoord().add(ForgeDirection.getOrientation((int)this.supporting_side)).getTE(TileEntityWire.class);
        if (below != null && below.supporting_side == this.supporting_side) {
            complexity += 16;
        }
        return complexity;
    }

    @Override
    void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        side = (new int[]{1, 0, 3, 2, 5, 4})[side];
        if (player.func_70093_af()) {
            this.supporting_side = (byte)side;
            if (this.is_supported()) {
                this.shareInfo();
                return;
            }
        }
        byte best_side = (byte)side;
        int best_complexity = this.getComplexity(best_side) - 1;
        if (!this.is_supported()) {
            best_complexity = 2457;
        }
        for (byte s = 0; s < 6; s = (byte)((byte)(s + 1))) {
            int test;
            if (s == side) continue;
            this.supporting_side = s;
            if (!this.is_supported() || (test = this.getComplexity(s)) >= best_complexity) continue;
            best_complexity = test;
            best_side = s;
        }
        this.supporting_side = best_side;
        this.shareInfo();
    }

    void shareInfo() {
        this.broadcastMessage(null, 121, this.supporting_side);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 startVec, Vec3 endVec) {
        return new WireConnections(this).collisionRayTrace(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, startVec, endVec);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public void setBlockBounds(Block b) {
        new WireConnections(this).setBlockBounds(b);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 121) {
            byte new_side = input.readByte();
            if (new_side != this.supporting_side) {
                this.supporting_side = new_side;
                this.getCoord().redraw();
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.wire;
    }
}

