/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemMachineUpgrade;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.regex.Matcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityRouter
extends TileEntityFactorization {
    public final int maxSearchPerTick = 16;
    public int guiLastButtonSet = 0;
    public boolean upgradeItemFilter = false;
    public boolean upgradeMachineFilter = false;
    public boolean upgradeSpeed = false;
    public boolean upgradeThorough = false;
    public boolean upgradeThroughput = false;
    public boolean upgradeEject = false;
    public int target_side = 1;
    public int target_slot = -1;
    public boolean is_input = true;
    public boolean match_to_visit = false;
    public int eject_direction;
    public String match;
    ItemStack buffer = null;
    ItemStack[] filter = new ItemStack[9];
    Coord lastSeenAt;
    private HashSet visited = new HashSet();
    private LinkedList frontier = new LinkedList();
    private static Random random = new Random();
    int delayDistance;
    private int ticksSinceLastSpam = 9999;
    int last_eject = 0;
    private static final int[] side_info = new int[]{0};

    public TileEntityRouter() {
        this.match = new String("");
    }

    void resetGraph() {
        this.visited.clear();
        this.visited.add(this);
        this.frontier.add(this);
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.DarkIron;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return BlockIcons.router$top;
            }
            case DOWN: {
                return BlockIcons.router$bottom;
            }
            case NORTH: {
                return BlockIcons.router$north.get(this);
            }
            case SOUTH: {
                return BlockIcons.router$south.get(this);
            }
            case EAST: {
                return BlockIcons.router$east.get(this);
            }
            case WEST: {
                return BlockIcons.router$west.get(this);
            }
        }
        return super.getIcon(dir);
    }

    void putParticles(World world) {
        double vz;
        double vy;
        double vx;
        double pz;
        double py;
        double px;
        int i;
        if (this.lastSeenAt == null) {
            return;
        }
        if (this.draw_active == 0) {
            return;
        }
        int out_count = 1;
        int in_count = 1;
        if (this.is_input) {
            in_count = this.upgradeThroughput ? (in_count += 5) : (in_count += 3);
        } else if (this.upgradeThroughput) {
            out_count += 5;
        } else {
            in_count += 3;
        }
        for (i = out_count; i != 0; --i) {
            px = (double)this.field_70329_l + 0.5 + (double)(random.nextFloat() / 2.0f);
            py = (double)this.field_70330_m + 0.5 + (double)(random.nextFloat() / 2.0f);
            pz = (double)this.field_70327_n + 0.5 + (double)(random.nextFloat() / 2.0f);
            vx = (double)this.lastSeenAt.x - px + (double)(random.nextFloat() / 2.0f);
            vy = (double)this.lastSeenAt.y - py + (double)(random.nextFloat() / 2.0f);
            vz = (double)this.lastSeenAt.z - pz + (double)(random.nextFloat() / 2.0f);
            world.func_72869_a("portal", px, py, pz, vx, vy, vz);
        }
        for (i = in_count; i != 0; --i) {
            px = (double)this.lastSeenAt.x + 0.5 + (double)(random.nextFloat() / 2.0f);
            py = (double)this.lastSeenAt.y + 0.5 + (double)(random.nextFloat() / 2.0f);
            pz = (double)this.lastSeenAt.z + 0.5 + (double)(random.nextFloat() / 2.0f);
            vx = (double)this.field_70329_l - px + (double)(random.nextFloat() / 2.0f);
            vy = (double)this.field_70330_m - py + (double)(random.nextFloat() / 2.0f);
            vz = (double)this.field_70327_n - pz + (double)(random.nextFloat() / 2.0f);
            world.func_72869_a("portal", px, py, pz, vx, vy, vz);
        }
    }

    boolean tryInsert(TileEntity ent) {
        if (ent.func_70320_p()) {
            return false;
        }
        if (ent instanceof IInventory && this.actOn((IInventory)ent)) {
            this.draw_active = (byte)(this.draw_active + 1);
            Coord here = new Coord(ent);
            this.delayDistance = !this.upgradeSpeed ? (int)here.distance(this.lastSeenAt) : 1;
            this.lastSeenAt = here;
            this.broadcastItem(24, null);
            return true;
        }
        return false;
    }

    Coord getEjectCoord() {
        if (!this.upgradeEject) {
            return null;
        }
        return this.getCoord().add(ForgeDirection.getOrientation((int)this.eject_direction).getOpposite());
    }

    void eject() {
        if (this.last_eject != 0) {
            --this.last_eject;
        }
        this.last_eject = 20;
        Coord target = this.getEjectCoord();
        IInventory target_inv = (IInventory)target.getTE(IInventory.class);
        if (target_inv == null) {
            return;
        }
        this.buffer = FactorizationUtil.openInventory(target_inv, this.eject_direction).push(this.buffer);
    }

    @Override
    void doLogic() {
        Core.profileStart("router");
        this.needLogic();
        ++this.ticksSinceLastSpam;
        if (this.lastSeenAt == null) {
            this.lastSeenAt = this.getCoord();
        }
        if (this.frontier.size() == 0) {
            this.resetGraph();
        }
        if (this.upgradeEject && !this.is_input && this.buffer != null && this.buffer.field_77994_a > 0) {
            this.eject();
        }
        if (this.delayDistance > 0) {
            --this.delayDistance;
            return;
        }
        int i = 16;
        if (this.upgradeSpeed) {
            i *= 2;
        }
        while (i-- != 0 && this.shouldUpdate() && this.frontier.size() > 0) {
            this.updateFrontier();
            if (this.delayDistance == 0) continue;
        }
        Core.profileEnd();
    }

    TileEntity popFrontier() {
        if (this.upgradeSpeed) {
            return (TileEntity)this.frontier.remove();
        }
        int closestDistance = Integer.MAX_VALUE;
        int closestIndex = 0;
        int end = Math.min(8, this.frontier.size());
        for (int i = 0; i < end; ++i) {
            int d = this.lastSeenAt.distanceSq(new Coord((TileEntity)this.frontier.get(i)));
            if (d < closestDistance) {
                closestDistance = d;
                closestIndex = i;
            }
            if (closestDistance != 1) continue;
            return (TileEntity)this.frontier.remove(i);
        }
        return (TileEntity)this.frontier.remove(closestIndex);
    }

    void updateFrontier() {
        if (this.frontier.size() == 0) {
            return;
        }
        TileEntity here = this.popFrontier();
        if (here != this && this.tryInsert(here) && this.upgradeThorough) {
            this.resetGraph();
            this.frontier.add(here);
            return;
        }
        for (Coord neighbor : new Coord(here).getNeighborsAdjacent()) {
            TileEntity ent = neighbor.getTE();
            if (!(ent instanceof IInventory) || this.visited.contains(ent) || this.match_to_visit && !this.matchIInventory((IInventory)ent)) continue;
            this.frontier.add(ent);
            this.visited.add(ent);
        }
    }

    boolean shouldUpdate() {
        if (this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n) > 0) {
            return false;
        }
        if (this.is_input) {
            return this.buffer != null;
        }
        if (this.buffer == null) {
            return true;
        }
        return this.buffer.field_77994_a < this.buffer.func_77976_d();
    }

    boolean isIInventoryBanned(String name2) {
        if (Core.routerBan == null) {
            return false;
        }
        Matcher m = Core.routerBan.matcher(name2);
        return m.matches();
    }

    public String getIInventoryName(IInventory t) {
        String invName = t.func_70303_b();
        if (invName == null || invName.length() == 0) {
            String className = t.getClass().getSimpleName();
            if (className == null || className.length() == 0) {
                return t.toString();
            }
            return className.toLowerCase();
        }
        return invName;
    }

    boolean matchIInventory(IInventory t) {
        if (t == null) {
            return false;
        }
        String invName = this.getIInventoryName(t);
        if (invName == null || this.isIInventoryBanned(invName)) {
            return false;
        }
        if (this.upgradeEject && t == this.getEjectCoord().getTE(IInventory.class)) {
            return false;
        }
        if (this.match == null || this.match.length() == 0 || !this.upgradeMachineFilter) {
            return true;
        }
        invName = invName.toLowerCase();
        for (String comp : this.match.split("\\|")) {
            if ((comp = comp.toLowerCase()).startsWith("!")) {
                if (!invName.startsWith(comp = comp.replaceFirst("!", ""))) continue;
                return false;
            }
            if (!invName.startsWith(comp)) continue;
            return true;
        }
        return false;
    }

    boolean itemPassesInsertFilter(FactorizationUtil.FzInv inv, ItemStack is) {
        ItemStack here;
        int i;
        if (!this.upgradeItemFilter) {
            return true;
        }
        int matching_count = 0;
        boolean empty_filter = true;
        for (i = 0; i < this.filter.length; ++i) {
            here = this.filter[i];
            if (here == null) continue;
            empty_filter = false;
            if (!FactorizationUtil.couldMerge(here, is)) continue;
            matching_count += here.field_77994_a;
        }
        if (empty_filter) {
            return true;
        }
        for (i = 0; i < inv.size(); ++i) {
            here = inv.get(i);
            if (here == null || !FactorizationUtil.couldMerge(here, is)) continue;
            matching_count -= here.field_77994_a;
        }
        return matching_count > 0;
    }

    boolean itemPassesExtractFilter(ItemStack is) {
        if (!this.upgradeItemFilter) {
            return true;
        }
        if (is == null) {
            return false;
        }
        int hits = 0;
        for (int i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            ++hits;
            if (FactorizationUtil.couldMerge(this.filter[i], is)) {
                return true;
            }
            if (this.filter[i].field_77993_c != is.field_77993_c || !is.func_77973_b().func_77645_m() || !this.filter[i].func_77951_h() || !is.func_77951_h()) continue;
            return true;
        }
        return hits == 0;
    }

    boolean actOn(IInventory t) {
        FactorizationUtil.FzInv inv;
        int end;
        int start;
        if (t == null) {
            return false;
        }
        if (t instanceof TileEntityRouter && (!this.upgradeMachineFilter || this.match == null || this.match.isEmpty())) {
            return false;
        }
        if (!this.matchIInventory(t)) {
            return false;
        }
        if (this.target_slot >= 0) {
            if (!FactorizationUtil.canAccessSlot(t, this.target_slot)) {
                return false;
            }
            if (this.target_slot >= t.func_70302_i_()) {
                return false;
            }
            start = this.target_slot;
            end = this.target_slot + 1;
            inv = new FactorizationUtil.PlainInvWrapper(t);
        } else {
            inv = FactorizationUtil.openInventory(t, this.target_side, false);
            if (inv == null) {
                return false;
            }
            start = 0;
            end = inv.size();
        }
        FactorizationUtil.FzInv me = FactorizationUtil.openInventory((IInventory)this, 0, false);
        int toMove = this.upgradeThroughput ? 64 : 1;
        for (int slot = start; slot < end; ++slot) {
            if (this.is_input) {
                if (!this.itemPassesInsertFilter(inv, this.buffer)) {
                    return false;
                }
                if (!me.transfer(0, inv, slot, toMove)) continue;
                return true;
            }
            if (!this.itemPassesExtractFilter(inv.get(slot)) || !inv.transfer(slot, me, 0, toMove)) continue;
            return true;
        }
        return false;
    }

    void verifyUpgrades() {
        if (!this.upgradeItemFilter) {
            for (int i = 0; i < this.filter.length; ++i) {
                this.filter[i] = null;
            }
        }
        if (!this.upgradeMachineFilter) {
            this.match_to_visit = false;
            this.match = null;
        }
    }

    @Override
    public void dropContents() {
        super.dropContents();
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        if (this.upgradeItemFilter) {
            toDrop.add(new ItemStack((Item)Core.registry.router_item_filter));
        }
        if (this.upgradeMachineFilter) {
            toDrop.add(new ItemStack((Item)Core.registry.router_machine_filter));
        }
        if (this.upgradeSpeed) {
            toDrop.add(new ItemStack((Item)Core.registry.router_speed));
        }
        if (this.upgradeThorough) {
            toDrop.add(new ItemStack((Item)Core.registry.router_thorough));
        }
        if (this.upgradeThroughput) {
            toDrop.add(new ItemStack((Item)Core.registry.router_throughput));
        }
        if (this.upgradeEject) {
            toDrop.add(new ItemStack((Item)Core.registry.router_eject));
        }
        Coord here = this.getCoord();
        for (ItemStack is : toDrop) {
            FactorizationUtil.spawnItemStack(here, is);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.verifyUpgrades();
        tag.func_74768_a("target_side", this.target_side);
        tag.func_74768_a("use_slot", this.target_slot);
        tag.func_74757_a("is_input", this.is_input);
        this.writeSlotsToNBT(tag);
        if (this.match != null) {
            tag.func_74778_a("match", this.match);
        }
        tag.func_74757_a("match_to_visit", this.match_to_visit);
        tag.func_74768_a("eject_side", this.eject_direction);
        tag.func_74757_a("upgrade_item_filter", this.upgradeItemFilter);
        tag.func_74757_a("upgrade_machine_filter", this.upgradeMachineFilter);
        tag.func_74757_a("upgrade_speed", this.upgradeSpeed);
        tag.func_74757_a("upgrade_thorough", this.upgradeThorough);
        tag.func_74757_a("upgrade_throughput", this.upgradeThroughput);
        tag.func_74757_a("upgrade_eject", this.upgradeEject);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.target_side = tag.func_74762_e("target_side");
        if (this.target_side == 6) {
            this.target_side = 1;
        }
        if (this.target_side == -7) {
            this.target_side = -2;
        }
        this.target_slot = tag.func_74762_e("use_slot");
        this.is_input = tag.func_74767_n("is_input");
        if (tag.func_74764_b("buffer")) {
            this.buffer = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("buffer"));
        } else {
            this.readSlotsFromNBT(tag);
        }
        this.match = tag.func_74779_i("match");
        this.match_to_visit = tag.func_74767_n("match_to_visit");
        this.eject_direction = tag.func_74762_e("eject_side");
        this.upgradeItemFilter = tag.func_74767_n("upgrade_item_filter");
        this.upgradeMachineFilter = tag.func_74767_n("upgrade_machine_filter");
        this.upgradeSpeed = tag.func_74767_n("upgrade_speed");
        this.upgradeThorough = tag.func_74767_n("upgrade_thorough");
        this.upgradeThroughput = tag.func_74767_n("upgrade_throughput");
        this.upgradeEject = tag.func_74767_n("upgrade_eject");
    }

    @Override
    public boolean takeUpgrade(ItemStack is) {
        ItemMachineUpgrade upgrade = (ItemMachineUpgrade)is.func_77973_b();
        if (upgrade == Core.registry.router_item_filter) {
            if (this.upgradeItemFilter) {
                return false;
            }
            this.upgradeItemFilter = true;
        } else if (upgrade == Core.registry.router_machine_filter) {
            if (this.upgradeMachineFilter) {
                return false;
            }
            this.upgradeMachineFilter = true;
        } else if (upgrade == Core.registry.router_speed) {
            if (this.upgradeSpeed) {
                return false;
            }
            this.upgradeSpeed = true;
        } else if (upgrade == Core.registry.router_thorough) {
            if (this.upgradeThorough) {
                return false;
            }
            this.upgradeThorough = true;
        } else if (upgrade == Core.registry.router_throughput) {
            if (this.upgradeThroughput) {
                return false;
            }
            this.upgradeThroughput = true;
        } else if (upgrade == Core.registry.router_eject) {
            if (this.upgradeEject) {
                return false;
            }
            this.upgradeEject = true;
        } else {
            return false;
        }
        return true;
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.buffer;
        }
        int f = i - 1;
        if (f >= 0 && f < this.filter.length) {
            return this.filter[f];
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.buffer = itemstack;
            return;
        }
        int f = i - 1;
        if (f >= 0 && f < this.filter.length) {
            this.filter[f] = itemstack;
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Item Router";
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.ROUTER;
    }

    public boolean handleMessageFromAny(int messageType, DataInput input) throws IOException {
        boolean need_share;
        switch (messageType) {
            case 21: {
                int m = input.readInt();
                need_share = this.target_side != m;
                this.target_side = m;
                break;
            }
            case 20: {
                int m = input.readInt();
                need_share = m != this.target_slot;
                this.target_slot = m;
                break;
            }
            case 23: {
                boolean b = input.readBoolean();
                need_share = b != this.is_input;
                this.is_input = b;
                break;
            }
            case 22: {
                String s = input.readUTF();
                need_share = this.match == null || !this.match.equals(s);
                this.match = s;
                break;
            }
            case 25: {
                boolean b = input.readBoolean();
                need_share = b != this.match_to_visit;
                this.match_to_visit = b;
                break;
            }
            case 28: {
                int m = input.readInt();
                need_share = m != this.eject_direction;
                this.eject_direction = m;
                break;
            }
            default: {
                return false;
            }
        }
        if (need_share && !this.field_70331_k.field_72995_K) {
            this.broadcastItem(messageType, null);
        }
        return true;
    }

    @Override
    void sendFullDescription(EntityPlayer player) {
        super.sendFullDescription(player);
        this.broadcastItem(-1, player);
    }

    public void broadcastItem(int messageType, EntityPlayer who) {
        boolean all;
        boolean bl = all = messageType == -1;
        if (all || messageType == 21) {
            this.broadcastMessage(who, 21, this.target_side);
        }
        if (all || messageType == 20) {
            this.broadcastMessage(who, 20, this.target_slot);
        }
        if (all || messageType == 23) {
            this.broadcastMessage(who, 23, this.is_input);
        }
        if (all || messageType == 27) {
            this.broadcastMessage(who, 27, this.upgradeItemFilter, this.upgradeMachineFilter, this.upgradeSpeed, this.upgradeThorough, this.upgradeThroughput, this.upgradeEject);
        }
        if (all || messageType == 22) {
            if (this.match == null) {
                this.match = "";
            }
            this.broadcastMessage(who, 22, this.match);
        }
        if (all || messageType == 25) {
            this.broadcastMessage(who, 25, this.match_to_visit);
        }
        if (all || messageType == 28) {
            this.broadcastMessage(who, 28, this.eject_direction);
        }
        if (messageType == 24 && this.lastSeenAt != null && this.ticksSinceLastSpam > 10) {
            this.broadcastMessage(who, 24, this.lastSeenAt.x, this.lastSeenAt.y, this.lastSeenAt.z);
            this.ticksSinceLastSpam = 0;
        }
    }

    @Override
    public void broadcastMessage(EntityPlayer who, int messageType, Object ... items) {
        Core.network.broadcastMessage(who, this.getCoord(), messageType, items);
    }

    public void removeUpgrade(int upgradeType, EntityPlayer player) {
        ItemStack drop = null;
        if (upgradeType == Core.registry.router_item_filter.upgradeId && this.upgradeItemFilter) {
            for (int i = 0; i < this.filter.length; ++i) {
                ItemStack is = this.filter[i];
                if (is == null) continue;
                player.field_71071_by.func_70441_a(is);
                this.filter[i] = null;
            }
            drop = new ItemStack((Item)Core.registry.router_item_filter);
            this.upgradeItemFilter = false;
        } else if (upgradeType == Core.registry.router_machine_filter.upgradeId && this.upgradeMachineFilter) {
            drop = new ItemStack((Item)Core.registry.router_machine_filter);
            this.upgradeMachineFilter = false;
        } else if (upgradeType == Core.registry.router_speed.upgradeId && this.upgradeSpeed) {
            drop = new ItemStack((Item)Core.registry.router_speed);
            this.upgradeSpeed = false;
        } else if (upgradeType == Core.registry.router_thorough.upgradeId && this.upgradeThorough) {
            drop = new ItemStack((Item)Core.registry.router_thorough);
            this.upgradeThorough = false;
        } else if (upgradeType == Core.registry.router_throughput.upgradeId && this.upgradeThroughput) {
            drop = new ItemStack((Item)Core.registry.router_throughput);
            this.upgradeThroughput = false;
        } else if (upgradeType == Core.registry.router_eject.upgradeId && this.upgradeEject) {
            drop = new ItemStack((Item)Core.registry.router_eject);
            this.upgradeEject = false;
        }
        this.verifyUpgrades();
        if (drop != null) {
            player.field_71071_by.func_70441_a(drop);
        } else if (!this.field_70331_k.field_72995_K) {
            // empty if block
        }
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (this.handleMessageFromAny(messageType, input)) {
            return true;
        }
        if (messageType == 26) {
            this.removeUpgrade(input.readInt(), Core.network.getCurrentPlayer());
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (this.handleMessageFromAny(messageType, input)) {
            return true;
        }
        if (messageType == 24) {
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            this.lastSeenAt = new Coord(this.field_70331_k, x, y, z);
            this.drawActive(1);
            return true;
        }
        if (messageType == 27) {
            this.upgradeItemFilter = input.readBoolean();
            this.upgradeMachineFilter = input.readBoolean();
            this.upgradeSpeed = input.readBoolean();
            this.upgradeThorough = input.readBoolean();
            this.upgradeThroughput = input.readBoolean();
            this.upgradeEject = input.readBoolean();
            this.verifyUpgrades();
            return true;
        }
        return false;
    }

    @Override
    int getLogicSpeed() {
        return 2;
    }

    @Override
    void makeNoise() {
        this.putParticles(this.field_70331_k);
        if ((double)rand.nextFloat() > 0.9898 && this.lastSeenAt != null) {
            Sound.routerCluck.playAt(this);
        }
    }

    public int[] func_94128_d(int s) {
        return side_info;
    }

    public boolean func_94041_b(int s, ItemStack itemstack) {
        if (this.upgradeItemFilter && this.is_input) {
            return this.itemPassesExtractFilter(itemstack);
        }
        return s == 0;
    }
}

