/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemCraft;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityMaker
extends TileEntityFactorization {
    public boolean[] targets = new boolean[9];
    ItemStack input;
    ItemStack paper;
    ItemStack craft;
    ItemStack output;
    private static final int input_slot = 0;
    private static final int paper_slot = 1;
    private static final int craft_slot = 2;
    private static final int output_slot = 3;
    private static final int[] PACKET_s = new int[]{1, 2};
    private static final int[] MATERIAL_s = new int[]{0};
    private static final int[] OUT_s = new int[]{3};

    public TileEntityMaker() {
        this.targets[4] = true;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Icon getIcon(ForgeDirection dir) {
        return BlockIcons.maker.get(this, dir);
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        switch (i) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.paper;
            }
            case 2: {
                return this.craft;
            }
            case 3: {
                return this.output;
            }
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        switch (i) {
            case 0: {
                this.input = itemstack;
                break;
            }
            case 1: {
                this.paper = itemstack;
                break;
            }
            case 2: {
                this.craft = itemstack;
                break;
            }
            case 3: {
                this.output = itemstack;
            }
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "Craft Maker";
    }

    public void setTargets(int id, boolean flag) {
        if (this.targets[id] != flag) {
            this.targets[id] = flag;
            this.broadcastTarget(null, id);
        }
    }

    boolean insertItem(int targetSlot, boolean doTarget) {
        if (!doTarget) {
            return true;
        }
        if (this.craft == null) {
            return false;
        }
        ItemCraft ic = (ItemCraft)this.craft.func_77973_b();
        if (this.input == null) {
            return ic.isSlotSet(this.craft, targetSlot);
        }
        ItemStack toAdd = this.input.func_77946_l();
        toAdd.field_77994_a = 1;
        if (ic.addItem(this.craft, targetSlot, toAdd, this)) {
            --this.input.field_77994_a;
            if (this.input.field_77994_a < 1) {
                this.input = null;
            }
            return true;
        }
        return ic.isSlotSet(this.craft, targetSlot);
    }

    boolean havePaper() {
        if (this.paper == null) {
            return false;
        }
        return this.paper.func_77973_b() == Item.field_77759_aK;
    }

    void eatPaper() {
        assert (this.paper.func_77973_b() == Item.field_77759_aK);
        --this.paper.field_77994_a;
        this.paper = FactorizationUtil.normalize(this.paper);
    }

    @Override
    int getLogicSpeed() {
        return 16;
    }

    @Override
    void doLogic() {
        int free;
        if (this.paper != null && this.craft == null && this.paper.func_77973_b() instanceof ItemCraft) {
            this.craft = this.paper;
            this.paper = null;
        }
        if (this.paper == null && this.craft != null && this.craft.func_77973_b() == Item.field_77759_aK) {
            this.paper = this.craft;
            this.craft = null;
        }
        if (this.paper != null && this.paper.func_77973_b() == Item.field_77759_aK && this.craft != null && this.craft.func_77973_b() == Item.field_77759_aK && (free = this.paper.func_77976_d() - this.paper.field_77994_a) > 0) {
            free = Math.min(free, this.craft.field_77994_a);
            this.craft.field_77994_a -= free;
            this.paper.field_77994_a += free;
            this.craft = FactorizationUtil.normalize(this.craft);
        }
        boolean have_craft = this.craft != null && this.craft.func_77973_b() instanceof ItemCraft;
        boolean is_armed = this.input != null && this.input.field_77994_a > 0 && !(this.input.func_77973_b() instanceof ItemCraft) && this.output == null;
        boolean could_move = this.craft != null && this.output == null;
        boolean haveFlag = false;
        for (boolean target : this.targets) {
            haveFlag |= target;
        }
        if (!haveFlag) {
            is_armed = false;
        }
        if (is_armed && this.havePaper() && this.craft == null) {
            this.craft = new ItemStack((Item)Core.registry.item_craft);
            have_craft = true;
            this.eatPaper();
        }
        if (have_craft && (is_armed || could_move)) {
            boolean success = true;
            for (int index = 0; index < 9; ++index) {
                success &= this.insertItem(index, this.targets[index]);
            }
            if (success) {
                this.output = this.craft;
                this.craft = null;
                this.drawActive(3);
                this.pulse();
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        for (int i = 0; i < 9; ++i) {
            tag.func_74757_a("target" + i, this.targets[i]);
        }
        TileEntityMaker.saveItem("input", tag, this.input);
        TileEntityMaker.saveItem("craft", tag, this.craft);
        TileEntityMaker.saveItem("output", tag, this.output);
        TileEntityMaker.saveItem("paper", tag, this.paper);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        for (int i = 0; i < 9; ++i) {
            this.targets[i] = tag.func_74767_n("target" + i);
        }
        this.input = TileEntityMaker.readItem("input", tag);
        this.craft = TileEntityMaker.readItem("craft", tag);
        this.output = TileEntityMaker.readItem("output", tag);
        this.paper = TileEntityMaker.readItem("paper", tag);
    }

    public int[] func_94128_d(int s) {
        ForgeDirection side = ForgeDirection.getOrientation((int)s);
        switch (side) {
            case DOWN: {
                return OUT_s;
            }
            case UP: {
                return MATERIAL_s;
            }
        }
        return PACKET_s;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return slotIndex == 0 || slotIndex == 1 && itemstack.func_77973_b() == Core.registry.item_craft || itemstack.func_77973_b() == Item.field_77759_aK;
    }

    @Override
    void sendFullDescription(EntityPlayer player) {
        super.sendFullDescription(player);
        for (int i = 0; i < 9; ++i) {
            this.broadcastTarget(player, i);
        }
    }

    void broadcastTarget(EntityPlayer who, int slot) {
        this.broadcastMessage(who, 11, slot, this.targets[slot]);
    }

    boolean handleMessageFromAny(int messageType, DataInput input) throws IOException {
        if (messageType == 11) {
            int target_id = input.readInt();
            boolean state = input.readBoolean();
            if (!this.field_70331_k.field_72995_K) {
                this.setTargets(target_id, state);
                this.needLogic();
            } else {
                this.targets[target_id] = state;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        return this.handleMessageFromAny(messageType, input);
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        return this.handleMessageFromAny(messageType, input);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MAKER;
    }

    @Override
    void makeNoise() {
        Sound.makerUse.playAt(this);
    }
}

