/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.api.IFactoryType;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntityFactorization
extends TileEntityCommon
implements IInventory,
ISidedInventory,
ICoord,
IFactoryType {
    public byte draw_active;
    public byte facing_direction = (byte)3;
    static Random rand = new Random();
    boolean need_logic_check = true;

    @Override
    public abstract FactoryType getFactoryType();

    public void click(EntityPlayer entityplayer) {
    }

    void makeNoise() {
    }

    abstract void doLogic();

    int getLogicSpeed() {
        return 4;
    }

    boolean canFaceVert() {
        return false;
    }

    @Override
    void onPlacedBy(EntityPlayer player, ItemStack is, int side) {
        if (player == null) {
            return;
        }
        this.setFacingDirectionFromEntity((Entity)player);
    }

    void setFacingDirectionFromEntity(Entity player) {
        float yaw = player.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (this.canFaceVert()) {
            if (player.field_70125_A <= -45.0f) {
                this.facing_direction = 0;
                return;
            }
            if (player.field_70125_A >= 65.0f) {
                this.facing_direction = 1;
                return;
            }
        }
        int y = (int)yaw / 45;
        switch (y) {
            case 0: 
            case 7: {
                this.facing_direction = (byte)2;
                break;
            }
            case 1: 
            case 2: {
                this.facing_direction = (byte)5;
                break;
            }
            case 3: 
            case 4: {
                this.facing_direction = (byte)3;
                break;
            }
            case 5: 
            case 6: {
                this.facing_direction = (byte)4;
            }
        }
    }

    void needLogic() {
        this.need_logic_check = true;
    }

    @Override
    public final Coord getCoord() {
        return new Coord(this);
    }

    @Override
    byte getExtraInfo() {
        return this.facing_direction;
    }

    @Override
    byte getExtraInfo2() {
        return this.draw_active > 127 ? (byte)127 : (byte)this.draw_active;
    }

    @Override
    void useExtraInfo(byte b) {
        if (this.field_70331_k.field_72995_K) {
            this.facing_direction = b;
        }
    }

    @Override
    void useExtraInfo2(byte b) {
        if (this.field_70331_k.field_72995_K) {
            this.draw_active = b;
        }
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.dropContents();
    }

    public void dropContents() {
        Coord here = this.getCoord();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            FactorizationUtil.spawnItemStack(here, this.func_70301_a(i));
        }
    }

    double round(double c) {
        if (Math.abs(c) < 0.5) {
            return 0.0;
        }
        return Math.copySign(1.0, c);
    }

    void ejectItem(ItemStack is, boolean violent, EntityPlayer player, int to_side) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (is == null || is.field_77994_a == 0) {
            return;
        }
        if (player == null) {
            to_side = -1;
        }
        double mult = 0.02;
        if (violent) {
            mult = 0.2;
        }
        Vec3 pos = this.field_70331_k.func_82732_R().func_72345_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5);
        Vec3 vel = this.field_70331_k.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        if (to_side != -1) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)to_side);
            double d = 0.75;
            pos.field_72450_a += (double)dir.offsetX * d;
            pos.field_72448_b += (double)dir.offsetY * d;
            pos.field_72449_c += (double)dir.offsetZ * d;
            vel.field_72450_a = dir.offsetX;
            vel.field_72448_b = dir.offsetY;
            vel.field_72449_c = dir.offsetZ;
        } else if (player != null) {
            Vec3 vec = Vec3.func_72443_a((double)(player.field_70165_t - (double)this.field_70329_l), (double)(player.field_70163_u - (double)this.field_70330_m), (double)(player.field_70161_v - (double)this.field_70327_n));
            vel = vec = vec.func_72432_b();
            double d = 0.25;
            pos.field_72450_a += vec.field_72450_a * d;
            pos.field_72448_b += vec.field_72448_b * d;
            pos.field_72449_c += vec.field_72449_c * d;
        } else {
            vel.field_72450_a = rand.nextGaussian();
            vel.field_72448_b = rand.nextGaussian();
            vel.field_72449_c = rand.nextGaussian();
        }
        EntityItem ent = new EntityItem(this.field_70331_k, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, is);
        ent.field_70159_w = vel.field_72450_a * mult;
        ent.field_70181_x = vel.field_72448_b * mult;
        ent.field_70179_y = vel.field_72449_c * mult;
        this.field_70331_k.func_72838_d((Entity)ent);
    }

    public ItemStack func_70298_a(int i, int amount) {
        ItemStack target = this.func_70301_a(i);
        if (target == null) {
            return null;
        }
        if (target.field_77994_a <= amount) {
            ItemStack ret = target;
            this.func_70299_a(i, null);
            this.func_70296_d();
            return ret;
        }
        ItemStack ret = target.func_77979_a(amount);
        if (target.field_77994_a == 0) {
            this.func_70299_a(i, null);
        }
        this.func_70296_d();
        return ret;
    }

    public final void func_70296_d() {
        super.func_70296_d();
        this.needLogic();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return 64.0 >= player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5);
    }

    public final void func_70295_k_() {
    }

    public final void func_70305_f() {
    }

    public boolean func_94042_c() {
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("draw_active_byte", this.draw_active);
        tag.func_74774_a("facing", this.facing_direction);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.draw_active = tag.func_74771_c("draw_active_byte");
        this.facing_direction = tag.func_74771_c("facing");
    }

    public final void readSlotsFromNBT(NBTTagCompound tag) {
        NBTTagList invlist = tag.func_74761_m("Items");
        for (int i = 0; i < invlist.func_74745_c(); ++i) {
            NBTTagCompound comp = (NBTTagCompound)invlist.func_74743_b(i);
            this.func_70299_a(comp.func_74762_e("Slot"), ItemStack.func_77949_a((NBTTagCompound)comp));
        }
    }

    public final void writeSlotsToNBT(NBTTagCompound tag) {
        NBTTagList invlist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74768_a("Slot", i);
            stack.func_77955_b(comp);
            invlist.func_74742_a((NBTBase)comp);
        }
        tag.func_74782_a("Items", (NBTBase)invlist);
    }

    static void saveItem(String name2, NBTTagCompound tag, ItemStack is) {
        if (is == null) {
            return;
        }
        NBTTagCompound itag = new NBTTagCompound();
        is.func_77955_b(itag);
        tag.func_74766_a(name2, itag);
    }

    static ItemStack readItem(String name2, NBTTagCompound tag) {
        if (tag.func_74764_b(name2)) {
            return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(name2));
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public void drawActive(int add_time) {
        int new_active = this.draw_active + add_time;
        if (new_active < 0) {
            new_active = 0;
        }
        if (new_active > 32) {
            new_active = 32;
        }
        if (this.draw_active != new_active) {
            this.draw_active = (byte)new_active;
            if (!this.field_70331_k.field_72995_K) {
                this.broadcastMessage(null, 0, this.draw_active);
            }
        }
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            if (this.draw_active > 0) {
                this.makeNoise();
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.draw_active = (byte)(this.draw_active - 1);
            }
        } else {
            byte by = this.draw_active = this.draw_active > 0 ? (byte)(this.draw_active - 1) : (byte)0;
            if (this.need_logic_check && 0L == this.field_70331_k.func_72820_D() % (long)this.getLogicSpeed()) {
                this.need_logic_check = false;
                this.doLogic();
            }
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInputStream input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 0) {
            this.draw_active = input.readByte();
            this.getCoord().redraw();
            return true;
        }
        return false;
    }
}

