/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import factorization.api.IActOnCraft;
import factorization.common.BasicGlazes;
import factorization.common.BlockClass;
import factorization.common.BlockFactorization;
import factorization.common.BlockLightAir;
import factorization.common.BlockOreStorageShatterable;
import factorization.common.BlockRenderHelper;
import factorization.common.BlockResource;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemAcidBottle;
import factorization.common.ItemAngularSaw;
import factorization.common.ItemBagOfHolding;
import factorization.common.ItemBattery;
import factorization.common.ItemBlockProxy;
import factorization.common.ItemBlockResource;
import factorization.common.ItemChargeMeter;
import factorization.common.ItemCraft;
import factorization.common.ItemCraftingComponent;
import factorization.common.ItemFactorization;
import factorization.common.ItemGlazeBucket;
import factorization.common.ItemInverium;
import factorization.common.ItemMachineUpgrade;
import factorization.common.ItemMatrixProgrammer;
import factorization.common.ItemOreProcessing;
import factorization.common.ItemPocketTable;
import factorization.common.ItemSculptingTool;
import factorization.common.ItemWandOfCooling;
import factorization.common.ItemWrathIgniter;
import factorization.common.ResourceType;
import factorization.common.Sound;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityFzNull;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntityLeydenJar;
import factorization.common.TileEntitySlagFurnace;
import factorization.common.TileEntityWrathFire;
import factorization.common.TileEntityWrathLamp;
import factorization.common.servo.ItemServoMotor;
import factorization.common.servo.ItemServoRailWidget;
import factorization.common.servo.ServoComponent;
import factorization.common.servo.ServoMotor;
import factorization.common.servo.actuators.ActuatorItemSyringe;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Registry
implements ICraftingHandler,
IWorldGenerator,
ITickHandler {
    public ItemFactorization item_factorization;
    public ItemBlockResource item_resource;
    public BlockFactorization factory_block;
    public BlockFactorization factory_rendering_block = null;
    public BlockRenderHelper blockRender = null;
    public BlockRenderHelper serverTraceHelper = null;
    public BlockRenderHelper clientTraceHelper = null;
    public BlockLightAir lightair_block;
    public BlockResource resource_block;
    public ItemStack router_item;
    public ItemStack servorail_item;
    public ItemStack maker_item;
    public ItemStack stamper_item;
    public ItemStack packager_item;
    public ItemStack barrel_item;
    public ItemStack lamp_item;
    public ItemStack air_item;
    public ItemStack slagfurnace_item;
    public ItemStack battery_item_hidden;
    public ItemStack leydenjar_item;
    public ItemStack leydenjar_item_full;
    public ItemStack heater_item;
    public ItemStack steamturbine_item;
    public ItemStack solarboiler_item;
    public ItemStack mirror_item_hidden;
    public ItemStack leadwire_item;
    public ItemStack grinder_item;
    public ItemStack mixer_item;
    public ItemStack crystallizer_item;
    public ItemStack greenware_item;
    public ItemStack rocket_engine_item_hidden;
    public ItemStack parasieve_item;
    public ItemStack silver_ore_item;
    public ItemStack silver_block_item;
    public ItemStack lead_block_item;
    public ItemStack dark_iron_block_item;
    public ItemStack is_factory;
    public ItemStack is_lamp;
    public ItemStack is_lightair;
    public ItemCraft item_craft;
    public ItemBagOfHolding bag_of_holding;
    public ItemPocketTable pocket_table;
    public ItemWandOfCooling wand_of_cooling;
    public ItemCraftingComponent diamond_shard;
    public IRecipe diamond_shard_recipe;
    public ItemStack diamond_shard_packet;
    public IRecipe boh_upgrade_recipe;
    public ItemWrathIgniter wrath_igniter;
    public ItemCraftingComponent silver_ingot;
    public ItemCraftingComponent lead_ingot;
    public ItemCraftingComponent dark_iron;
    public ItemMachineUpgrade router_item_filter;
    public ItemMachineUpgrade router_machine_filter;
    public ItemMachineUpgrade router_speed;
    public ItemMachineUpgrade router_thorough;
    public ItemMachineUpgrade router_throughput;
    public ItemMachineUpgrade router_eject;
    public ItemMachineUpgrade barrel_enlarge;
    public ItemStack fake_is;
    public ItemAcidBottle acid;
    public ItemCraftingComponent magnet;
    public ItemCraftingComponent insulated_coil;
    public ItemCraftingComponent motor;
    public ItemCraftingComponent fan;
    public ItemCraftingComponent diamond_cutting_head;
    public ItemStack sulfuric_acid;
    public ItemStack aqua_regia;
    public ItemChargeMeter charge_meter;
    public ItemBlockProxy mirror;
    public ItemBattery battery;
    public ItemOreProcessing ore_dirty_gravel;
    public ItemOreProcessing ore_clean_gravel;
    public ItemOreProcessing ore_reduced;
    public ItemOreProcessing ore_crystal;
    public ItemCraftingComponent sludge;
    public ItemCraftingComponent inverium;
    public ItemSculptingTool sculpt_tool;
    public ItemGlazeBucket glaze_bucket;
    public ItemStack base_common;
    public ItemStack base_matte;
    public ItemStack base_translucent;
    public ItemStack base_shiny;
    public ItemStack base_bright;
    public ItemStack base_unreal;
    public ItemStack glaze_base_mimicry;
    public ItemAngularSaw angular_saw;
    public ItemCraftingComponent heatHole;
    public ItemCraftingComponent logicMatrix;
    public ItemCraftingComponent logicMatrixIdentifier;
    public ItemCraftingComponent logicMatrixProgrammer;
    public Item fz_steam;
    public ItemCraftingComponent nether_powder;
    public ItemCraftingComponent rocket_fuel;
    public Item rocket_fuel_liquid_entry;
    public ItemBlockProxy rocket_engine;
    public LiquidStack liquidStackRocketFuel;
    public ItemCraftingComponent bucket_rocket_fuel;
    public ItemServoMotor servo_motor_placer;
    public ItemServoRailWidget servo_widget_instruction;
    public ItemServoRailWidget servo_widget_decor;
    public ActuatorItemSyringe actuator_item_manipulator;
    public ItemStack dark_iron_sprocket;
    public ItemStack sprocket_motor;
    public Material materialMachine = new Material(MapColor.field_76288_h);
    WorldGenMinable silverGen;
    final int WILDCARD = Short.MAX_VALUE;
    HashSet added_ids = new HashSet();
    private EnumSet serverTicks = EnumSet.of(TickType.SERVER);

    void makeBlocks() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.blockRender = new BlockRenderHelper();
            this.factory_rendering_block = new BlockFactorization(Core.factory_block_id);
            Block.field_71973_m[this.factory_rendering_block.field_71990_ca] = null;
        }
        this.serverTraceHelper = new BlockRenderHelper();
        this.clientTraceHelper = new BlockRenderHelper();
        this.factory_block = new BlockFactorization(Core.factory_block_id);
        this.lightair_block = new BlockLightAir(Core.lightair_id);
        this.resource_block = new BlockResource(Core.resource_id);
        this.is_factory = new ItemStack((Block)this.factory_block);
        this.is_lightair = new ItemStack((Block)this.lightair_block);
        GameRegistry.registerBlock((Block)this.factory_block, ItemFactorization.class, (String)"FZ factory");
        GameRegistry.registerBlock((Block)this.lightair_block, (String)"FZ Lightair");
        GameRegistry.registerBlock((Block)this.resource_block, ItemBlockResource.class, (String)"FZ resource");
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        Core.tab((Block)this.factory_block, Core.TabType.MATERIALS);
        Block vanillaDiamond = Block.field_72071_ax;
        int diamondId = vanillaDiamond.field_71990_ca;
        Block.field_71973_m[diamondId] = null;
        BlockOreStorageShatterable newDiamond = new BlockOreStorageShatterable(diamondId, vanillaDiamond);
        newDiamond.func_71848_c(5.0f).func_71894_b(10.0f).func_71884_a(Block.field_71977_i).func_71864_b("blockDiamond");
    }

    void registerSimpleTileEntities() {
        FactoryType.registerTileEntities();
        GameRegistry.registerTileEntity(TileEntityFzNull.class, (String)"fz.null");
        EntityRegistry.registerModEntity(TileEntityWrathLamp.RelightTask.class, (String)"factory_relight_task", (int)0, (Object)Core.instance, (int)1, (int)10, (boolean)false);
        EntityRegistry.registerModEntity(ServoMotor.class, (String)"factory_servo", (int)1, (Object)Core.instance, (int)100, (int)1, (boolean)true);
    }

    public int itemID(String name2, int default_id) {
        int id = Core.config.getItem("item", name2, default_id).getInt();
        if (this.added_ids.contains(default_id)) {
            throw new RuntimeException("Default ID already used: " + default_id);
        }
        if (Item.field_77698_e[id] != null) {
            throw new RuntimeException("Item ID conflict: " + id + " is already taken by " + Item.field_77698_e[id] + "; tried to use it for Factorization " + name2);
        }
        this.added_ids.add(default_id);
        return id;
    }

    void makeItems() {
        this.ore_dirty_gravel = new ItemOreProcessing(this.itemID("oreDirtyGravel", 9034), 36, "gravel");
        this.ore_clean_gravel = new ItemOreProcessing(this.itemID("oreCleanGravel", 9035), 37, "clean");
        this.ore_reduced = new ItemOreProcessing(this.itemID("oreReduced", 9036), 38, "reduced");
        this.ore_crystal = new ItemOreProcessing(this.itemID("oreCrystal", 9037), 39, "crystal");
        this.sludge = new ItemCraftingComponent(this.itemID("sludge", 9039), "sludge");
        OreDictionary.registerOre((String)"FZ.sludge", (Item)this.sludge);
        this.item_factorization = (ItemFactorization)Item.field_77698_e[this.factory_block.field_71990_ca];
        this.item_resource = (ItemBlockResource)Item.field_77698_e[this.resource_block.field_71990_ca];
        Core.tab(this.resource_block, Core.TabType.MATERIALS);
        this.router_item = FactoryType.ROUTER.itemStack();
        this.servorail_item = FactoryType.SERVORAIL.itemStack();
        this.parasieve_item = FactoryType.PARASIEVE.itemStack();
        this.barrel_item = FactoryType.BARREL.itemStack();
        this.maker_item = FactoryType.MAKER.itemStack();
        this.stamper_item = FactoryType.STAMPER.itemStack();
        this.lamp_item = FactoryType.LAMP.itemStack();
        this.packager_item = FactoryType.PACKAGER.itemStack();
        this.slagfurnace_item = FactoryType.SLAGFURNACE.itemStack();
        this.battery_item_hidden = FactoryType.BATTERY.itemStack();
        this.leydenjar_item = FactoryType.LEYDENJAR.itemStack();
        this.steamturbine_item = FactoryType.STEAMTURBINE.itemStack();
        this.solarboiler_item = FactoryType.SOLARBOILER.itemStack();
        this.heater_item = FactoryType.HEATER.itemStack();
        this.mirror_item_hidden = FactoryType.MIRROR.itemStack();
        this.leadwire_item = FactoryType.LEADWIRE.itemStack();
        this.grinder_item = FactoryType.GRINDER.itemStack();
        this.mixer_item = FactoryType.MIXER.itemStack();
        this.crystallizer_item = FactoryType.CRYSTALLIZER.itemStack();
        this.greenware_item = FactoryType.CERAMIC.itemStack();
        this.rocket_engine_item_hidden = FactoryType.ROCKETENGINE.itemStack();
        this.silver_ore_item = ResourceType.SILVERORE.itemStack("Silver Ore");
        this.silver_block_item = ResourceType.SILVERBLOCK.itemStack("Block of Silver");
        this.lead_block_item = ResourceType.LEADBLOCK.itemStack("Block of Lead");
        this.dark_iron_block_item = ResourceType.DARKIRONBLOCK.itemStack("Block of Dark Iron");
        this.lead_ingot = new ItemCraftingComponent(this.itemID("leadIngot", 9014), "lead_ingot");
        this.silver_ingot = new ItemCraftingComponent(this.itemID("silverIngot", 9015), "silver_ingot");
        OreDictionary.registerOre((String)"oreSilver", (ItemStack)this.silver_ore_item);
        OreDictionary.registerOre((String)"ingotSilver", (ItemStack)new ItemStack((Item)this.silver_ingot));
        OreDictionary.registerOre((String)"ingotLead", (ItemStack)new ItemStack((Item)this.lead_ingot));
        OreDictionary.registerOre((String)"blockSilver", (ItemStack)this.silver_block_item);
        OreDictionary.registerOre((String)"blockLead", (ItemStack)this.lead_block_item);
        this.diamond_shard = new ItemCraftingComponent(this.itemID("diamondShard", 9006), "diamond_shard");
        OreDictionary.registerOre((String)"FZ.diamondShard", (Item)this.diamond_shard);
        this.wrath_igniter = new ItemWrathIgniter(this.itemID("wrathIgniter", 9007));
        this.dark_iron = new ItemCraftingComponent(this.itemID("darkIron", 9008), "dark_iron_ingot");
        OreDictionary.registerOre((String)"FZ.darkIron", (Item)this.dark_iron);
        this.bag_of_holding = new ItemBagOfHolding(this.itemID("bagOfHolding", 9001));
        this.logicMatrixProgrammer = new ItemMatrixProgrammer(this.itemID("logicMatrixProgrammer", 9043), "tool.matrix_programmer");
        ChestGenHooks dungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        dungeon.addItem(new WeightedRandomChestContent(new ItemStack((Item)this.logicMatrixProgrammer), 1, 1, 25));
        this.logicMatrix = new ItemCraftingComponent(this.itemID("logicMatrix", 9044), "logic_matrix");
        this.logicMatrixIdentifier = new ItemCraftingComponent(this.itemID("logicMatrixID", 9045), "logic_matrix_identifier");
        this.heatHole = new ItemCraftingComponent(this.itemID("heatHole", 9046), "heat_hole");
        this.wand_of_cooling = new ItemWandOfCooling(this.itemID("wandOfCooling", 9005));
        this.router_item_filter = new ItemMachineUpgrade(this.itemID("routerItemFilter", 9016), "router/item_filter", "Router Upgrade", FactoryType.ROUTER, 0);
        this.router_machine_filter = new ItemMachineUpgrade(this.itemID("routerMachineFilter", 9017), "router/machine_filter", "Router Upgrade", FactoryType.ROUTER, 1);
        this.router_speed = new ItemMachineUpgrade(this.itemID("routerSpeed", 9018), "router/speed", "Router Upgrade", FactoryType.ROUTER, 2);
        this.router_thorough = new ItemMachineUpgrade(this.itemID("routerThorough", 9019), "router/thorough", "Router Upgrade", FactoryType.ROUTER, 3);
        this.router_throughput = new ItemMachineUpgrade(this.itemID("routerThroughput", 9020), "router/bandwidth", "Router Upgrade", FactoryType.ROUTER, 4);
        this.router_eject = new ItemMachineUpgrade(this.itemID("routerEject", 9031), "router/eject", "Router Upgrade", FactoryType.ROUTER, 5);
        this.barrel_enlarge = new ItemMachineUpgrade(this.itemID("barrelEnlarge", 9032), "barrel_upgrade", "Barrel Upgrade", FactoryType.BARREL, 6);
        this.acid = new ItemAcidBottle(this.itemID("acid", 9024));
        this.sulfuric_acid = new ItemStack((Item)this.acid, 1);
        this.aqua_regia = new ItemStack((Item)this.acid, 1, 1);
        OreDictionary.registerOre((String)"sulfuricAcid", (ItemStack)this.sulfuric_acid);
        OreDictionary.registerOre((String)"aquaRegia", (ItemStack)this.aqua_regia);
        this.magnet = new ItemCraftingComponent(this.itemID("magnet", 9025), "magnet");
        this.insulated_coil = new ItemCraftingComponent(this.itemID("coil", 9026), "insulated_coil");
        this.motor = new ItemCraftingComponent(this.itemID("motor", 9027), "motor");
        this.fan = new ItemCraftingComponent(this.itemID("fan", 9028), "fan");
        this.diamond_cutting_head = new ItemCraftingComponent(this.itemID("diamondCuttingHead", 9038), "diamond_cutting_head");
        this.charge_meter = new ItemChargeMeter(this.itemID("chargemeter", 9029));
        this.mirror = new ItemBlockProxy(this.itemID("mirror", 9030), this.mirror_item_hidden);
        this.mirror.func_77655_b("factorization:mirror");
        this.battery = new ItemBattery(this.itemID("battery", 9033));
        this.leydenjar_item_full = ItemStack.func_77944_b((ItemStack)this.leydenjar_item);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("storage", TileEntityLeydenJar.max_storage);
        this.leydenjar_item_full.func_77982_d(tag);
        this.item_craft = new ItemCraft(this.itemID("itemCraftId", 9000));
        this.angular_saw = new ItemAngularSaw(this.itemID("angularSaw", 9042));
        MinecraftForge.setToolClass((Item)this.angular_saw, (String)"pickaxe", (int)3);
        this.sculpt_tool = new ItemSculptingTool(this.itemID("sculptTool", 9041));
        this.glaze_bucket = new ItemGlazeBucket(this.itemID("glazeBucket", 9055));
        this.inverium = new ItemInverium(this.itemID("inverium", 9040), "rocket/inverium_drop");
        OreDictionary.registerOre((String)"FZ.inverium", (Item)this.inverium);
        this.pocket_table = new ItemPocketTable(this.itemID("pocketCraftingTable", 9002));
        this.fz_steam = new Item(this.itemID("steam", 9049));
        this.fz_steam.func_77655_b("factorization:charge/steam");
        this.nether_powder = new ItemCraftingComponent(this.itemID("netherPowder", 9050), "nether_powder");
        if (Core.enable_dimension_slice) {
            this.rocket_fuel = new ItemCraftingComponent(this.itemID("heldRocketFuel", 9051), "rocket/powder_rocket_fuel");
            this.rocket_fuel_liquid_entry = new Item(this.itemID("liquidRocketFuel", 9052));
            this.rocket_fuel_liquid_entry.func_77655_b("factorization:rocket/powder_rocket_fuel");
            this.rocket_engine = new ItemBlockProxy(this.itemID("rocketEngine", 9053), this.rocket_engine_item_hidden);
            this.rocket_engine.func_77655_b("factorization:rocket/rocket_engine").func_77625_d(1);
            this.bucket_rocket_fuel = new ItemCraftingComponent(this.itemID("bucketRocketFuel", 9054), "rocket/rocket_fuel_bucket");
            this.bucket_rocket_fuel.func_77625_d(1);
            this.bucket_rocket_fuel.func_77642_a(Item.field_77788_aw);
        }
        this.servo_motor_placer = new ItemServoMotor(this.itemID("servoMotorPlacer", 9056));
        this.servo_widget_decor = new ItemServoRailWidget(this.itemID("servoWidgetDecor", 9057));
        this.servo_widget_instruction = new ItemServoRailWidget(this.itemID("servoWidgetInstruction", 9061));
        this.servo_widget_decor.func_77625_d(16);
        this.servo_widget_instruction.func_77625_d(1);
        this.actuator_item_manipulator = new ActuatorItemSyringe(this.itemID("actuatorItemManipulator", 9058));
        this.dark_iron_sprocket = new ItemStack((Item)new ItemCraftingComponent(this.itemID("darkIronSprocket", 9059), "servo/sprocket"));
        this.sprocket_motor = new ItemStack((Item)new ItemCraftingComponent(this.itemID("servoMotor", 9060), "servo/servo_motor"));
    }

    public void recipe(ItemStack res, Object ... params) {
        GameRegistry.addRecipe((ItemStack)res, (Object[])params);
    }

    public void shapelessRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        GameRegistry.addShapelessRecipe((ItemStack)res, (Object[])params);
    }

    public void oreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(res, params));
    }

    public void shapelessOreRecipe(ItemStack res, Object ... params) {
        if (res == null) {
            return;
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(res, params));
    }

    void makeRecipes() {
        this.recipe(new ItemStack((Block)Block.field_72085_aj), "-", "-", Character.valueOf('-'), new ItemStack((Block)Block.field_72079_ak, 1));
        this.recipe(new ItemStack((Block)Block.field_72085_aj, 4, 8), "##", "##", Character.valueOf('#'), new ItemStack((Block)Block.field_72085_aj));
        this.shapelessRecipe(new ItemStack((Item)this.dark_iron, 4), this.dark_iron_block_item);
        this.recipe(this.dark_iron_block_item, new Object[]{"II", "II", Character.valueOf('I'), this.dark_iron});
        ItemStack BOH = new ItemStack((Item)this.bag_of_holding, 1);
        this.recipe(BOH, new Object[]{"LOL", "ILI", " I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('O'), Item.field_77730_bn, Character.valueOf('L'), Item.field_77770_aF});
        this.shapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, Item.field_77730_bn, Item.field_77770_aF});
        this.boh_upgrade_recipe = FactorizationUtil.createShapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, Item.field_77730_bn, Item.field_77770_aF});
        this.recipe(new ItemStack((Item)this.pocket_table), " #", "| ", Character.valueOf('#'), Block.field_72060_ay, Character.valueOf('|'), Item.field_77669_D);
        this.recipe(new ItemStack((Item)this.logicMatrixIdentifier), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), Item.field_94583_ca, Character.valueOf('X'), this.logicMatrixProgrammer});
        this.recipe(new ItemStack((Item)this.logicMatrixProgrammer), new Object[]{"MiX", Character.valueOf('M'), this.logicMatrix, Character.valueOf('i'), this.dark_iron, Character.valueOf('X'), this.logicMatrixProgrammer});
        TileEntityCrystallizer.addRecipe(new ItemStack(Block.field_71981_t), new ItemStack((Item)this.logicMatrix), 1.0f, new ItemStack((Item)Item.field_77726_bs), 1);
        TileEntityCrystallizer.addRecipe(new ItemStack(Item.field_77725_bx), new ItemStack((Item)this.heatHole), 1.0f, new ItemStack((Item)Item.field_77726_bs), 1);
        this.recipe(new ItemStack((Item)this.wand_of_cooling), new Object[]{" OD", " IO", "I  ", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('D'), this.heatHole, Character.valueOf('I'), Item.field_77703_o});
        this.diamond_shard_recipe = FactorizationUtil.createShapedRecipe(new ItemStack((Item)this.diamond_shard, 18), "OTO", "TDT", "OTO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('T'), Block.field_72091_am, Character.valueOf('D'), Block.field_72071_ax);
        ItemCraft.addStamperRecipe(this.diamond_shard_recipe);
        this.diamond_shard_packet = new ItemStack((Item)this.item_craft);
        this.diamond_shard_packet.func_77964_b(255);
        for (int i : new int[]{0, 2, 6, 8}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new ItemStack(Block.field_72089_ap), null);
        }
        for (int i : new int[]{1, 3, 5, 7}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new ItemStack(Block.field_72091_am), null);
        }
        this.item_craft.addItem(this.diamond_shard_packet, 4, new ItemStack(Block.field_72071_ax), null);
        this.recipe(this.diamond_shard_packet, "OTO", "TDT", "OTO", Character.valueOf('O'), Block.field_72089_ap, Character.valueOf('T'), Block.field_72091_am, Character.valueOf('D'), Block.field_72071_ax);
        this.recipe(new ItemStack((Item)this.wrath_igniter), new Object[]{"D ", " B", Character.valueOf('D'), this.diamond_shard, Character.valueOf('B'), Item.field_94584_bZ});
        this.recipe(new ItemStack((Item)this.lead_ingot, 9), "#", Character.valueOf('#'), this.lead_block_item);
        this.recipe(new ItemStack((Item)this.silver_ingot, 9), "#", Character.valueOf('#'), this.silver_block_item);
        this.oreRecipe(this.lead_block_item, "###", "###", "###", Character.valueOf('#'), "ingotLead");
        this.oreRecipe(this.silver_block_item, "###", "###", "###", Character.valueOf('#'), "ingotSilver");
        FurnaceRecipes.func_77602_a().addSmelting(this.resource_block.field_71990_ca, 0, new ItemStack((Item)this.silver_ingot), 0.3f);
        this.recipe(new ItemStack((Item)this.sculpt_tool), " c", "/ ", Character.valueOf('c'), Item.field_77757_aI, Character.valueOf('/'), Item.field_77669_D);
        ItemSculptingTool.addModeChangeRecipes();
        this.oreRecipe(new ItemStack((Item)this.glaze_bucket), "_ _", "# #", "#_#", Character.valueOf('_'), "slabWood", Character.valueOf('#'), "plankWood");
        this.base_common = this.glaze_bucket.makeCraftingGlaze("base_common");
        this.base_matte = this.glaze_bucket.makeCraftingGlaze("base_matte");
        this.base_translucent = this.glaze_bucket.makeCraftingGlaze("base_translucent");
        this.base_shiny = this.glaze_bucket.makeCraftingGlaze("base_shiny");
        this.base_bright = this.glaze_bucket.makeCraftingGlaze("base_bright");
        this.base_unreal = this.glaze_bucket.makeCraftingGlaze("base_unreal");
        this.glaze_base_mimicry = this.glaze_bucket.makeCraftingGlaze("base_mimicry");
        this.glaze_bucket.add(this.glaze_base_mimicry);
        ItemStack charcoal = new ItemStack(Item.field_77705_m, 1, 1);
        ItemStack bonemeal = new ItemStack(Item.field_77756_aW, 1, 15);
        ItemStack lapis = new ItemStack(Item.field_77756_aW, 1, 4);
        ItemStack lead_chunks = new ItemStack((Item)this.ore_reduced, 1, ItemOreProcessing.OreType.LEAD.ID);
        ItemStack iron_chunks = new ItemStack((Item)this.ore_reduced, 1, ItemOreProcessing.OreType.IRON.ID);
        Item netherquartz = Item.field_94583_ca;
        Item netherbrick = Item.field_94584_bZ;
        this.shapelessOreRecipe(this.base_common, new ItemStack((Item)this.glaze_bucket), Item.field_77786_ax, Block.field_71939_E, Item.field_77757_aI);
        this.shapelessOreRecipe(this.base_matte, this.base_common, Item.field_77757_aI, Block.field_71939_E, charcoal);
        this.shapelessOreRecipe(this.base_translucent, this.base_common, Block.field_71939_E, Block.field_71939_E, Block.field_71939_E);
        this.shapelessOreRecipe(this.base_shiny, this.base_common, netherquartz, Block.field_71939_E, charcoal);
        this.shapelessOreRecipe(this.base_bright, new Object[]{this.base_shiny, bonemeal, this.nether_powder, lead_chunks});
        this.shapelessOreRecipe(this.base_unreal, new Object[]{this.base_bright, this.diamond_shard, Item.field_77748_bA, this.dark_iron});
        this.shapelessOreRecipe(this.glaze_base_mimicry, this.base_unreal, Item.field_77748_bA, Item.field_77761_aM, lapis);
        ItemStack blackWool = new ItemStack(Block.field_72101_ab, 1, 15);
        BasicGlazes.ST_VECHS_BLACK.recipe(this.base_matte, blackWool);
        BasicGlazes.TEMPLE_WHITE.recipe(this.base_common, bonemeal);
        BasicGlazes.SALLYS_WHITE.recipe(this.base_shiny, netherquartz);
        BasicGlazes.CLEAR.recipe(this.base_translucent, Block.field_71939_E);
        BasicGlazes.REDSTONE_OXIDE.recipe(this.base_common, Item.field_77767_aC);
        BasicGlazes.LAPIS_OXIDE.recipe(this.base_common, lapis);
        BasicGlazes.PURPLE_OXIDE.recipe(this.base_common, Item.field_77767_aC, lapis);
        BasicGlazes.LEAD_OXIDE.recipe(this.base_common, lead_chunks);
        BasicGlazes.FIRE_ENGINE_RED.recipe(this.base_bright, Item.field_77767_aC);
        BasicGlazes.CELEDON.recipe(this.base_translucent, Item.field_77761_aM);
        BasicGlazes.IRON_BLUE.recipe(this.base_shiny, lapis, iron_chunks);
        BasicGlazes.STONEWARE_SLIP.recipe(new Object[]{this.base_common, this.sludge});
        BasicGlazes.TENMOKU.recipe(this.base_common, netherbrick);
        BasicGlazes.PEKING_BLUE.recipe(this.base_bright, lapis);
        BasicGlazes.SHINO.recipe(this.base_matte, Item.field_77767_aC, netherquartz);
        Core.registry.glaze_bucket.doneMakingStandardGlazes();
        GameRegistry.addRecipe((IRecipe)new IRecipe(){

            ArrayList merge(InventoryCrafting inv) {
                if (inv.field_70466_a.length < 2) {
                    return null;
                }
                ArrayList<ItemStack> match = new ArrayList<ItemStack>(2);
                boolean part_count = false;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack is = inv.func_70301_a(i);
                    if (is == null) continue;
                    if (!is.func_77942_o()) {
                        return null;
                    }
                    Item item2 = is.func_77973_b();
                    if (FactorizationUtil.similar(Core.registry.greenware_item, is)) {
                        match.add(is);
                        continue;
                    }
                    return null;
                }
                if (match.size() < 2) {
                    return null;
                }
                return match;
            }

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                ArrayList matching = this.merge(inventorycrafting);
                if (matching == null) {
                    return false;
                }
                int partCount = 0;
                TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                for (ItemStack is : matching) {
                    rep.loadParts(is.func_77978_p());
                    if (rep.getState() != TileEntityGreenware.ClayState.WET) {
                        return false;
                    }
                    if ((partCount += rep.parts.size()) < TileEntityGreenware.MAX_PARTS) continue;
                    return false;
                }
                return true;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.greenware_item.func_77946_l();
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                ArrayList matching = this.merge(inventorycrafting);
                TileEntityGreenware target = new TileEntityGreenware();
                for (ItemStack is : matching) {
                    TileEntityGreenware rep = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
                    rep.loadParts(is.func_77978_p());
                    target.parts.addAll(rep.parts);
                }
                return target.getItem();
            }
        });
        GameRegistry.addRecipe((IRecipe)new IRecipe(){

            public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
                int mimic_items = 0;
                int other_items = 0;
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    ItemStack is = inventorycrafting.func_70301_a(i);
                    if (is == null) continue;
                    if (FactorizationUtil.couldMerge(Registry.this.glaze_base_mimicry, is)) {
                        ++mimic_items;
                        continue;
                    }
                    if (is.field_77993_c >= Block.field_71973_m.length) {
                        return false;
                    }
                    int d = is.func_77960_j();
                    if (d < 0 || d > 16) {
                        return false;
                    }
                    Block b = Block.field_71973_m[is.field_77993_c];
                    if (b == null) {
                        return false;
                    }
                    ++other_items;
                }
                return mimic_items == 1 && other_items == 1;
            }

            public int func_77570_a() {
                return 2;
            }

            public ItemStack func_77571_b() {
                return Registry.this.glaze_base_mimicry;
            }

            public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
                int[] side_map = new int[]{1, 2, 1, 4, 0, 5, 0, 3, 0};
                for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                    Block b;
                    int d;
                    ItemStack is = inventorycrafting.func_70301_a(i);
                    if (is == null || FactorizationUtil.couldMerge(Registry.this.glaze_base_mimicry, is) || is.field_77993_c >= Block.field_71973_m.length || (d = is.func_77960_j()) < 0 || d > 16 || (b = Block.field_71973_m[is.field_77993_c]) == null) continue;
                    int side = 0;
                    try {
                        side = side_map[i];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    return Registry.this.glaze_bucket.makeMimicingGlaze(is.field_77993_c, is.func_77960_j(), side);
                }
                return null;
            }
        });
        this.oreRecipe(new ItemStack((Item)this.inverium, 1, 1), "LGL", "GDG", "LGL", Character.valueOf('L'), "ingotLead", Character.valueOf('G'), Item.field_77717_p, Character.valueOf('D'), Item.field_77702_n);
        this.recipe(this.router_item, new Object[]{"MMM", "oIO", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), Item.field_77764_aP, Character.valueOf('o'), Item.field_77730_bn, Character.valueOf('O'), Item.field_77748_bA});
        this.recipe(this.router_item, new Object[]{"MMM", "OIo", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), Item.field_77764_aP, Character.valueOf('o'), Item.field_77730_bn, Character.valueOf('O'), Item.field_77748_bA});
        this.recipe(new ItemStack((Item)this.router_item_filter), new Object[]{"ITI", "GDG", "ICI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), Block.field_72035_aQ, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('G'), Item.field_77717_p, Character.valueOf('C'), Block.field_72077_au});
        this.oreRecipe(new ItemStack((Item)this.router_machine_filter), new Object[]{"ITI", "SDS", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), Block.field_72035_aQ, Character.valueOf('D'), this.logicMatrixIdentifier, Character.valueOf('S'), "ingotSilver", Character.valueOf('B'), Item.field_77760_aL});
        this.recipe(new ItemStack((Item)this.router_speed), new Object[]{"ISI", "SCS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), Item.field_77747_aY, Character.valueOf('C'), Item.field_77746_aZ});
        this.recipe(new ItemStack((Item)this.router_thorough), new Object[]{"ISI", "SSS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), Block.field_72013_bc});
        this.recipe(new ItemStack((Item)this.router_throughput), new Object[]{"IBI", "B!B", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('B'), Item.field_77722_bw, Character.valueOf('!'), Item.field_77764_aP});
        this.oreRecipe(new ItemStack((Item)this.router_eject), new Object[]{"IWI", "C_C", "IPI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), "plankWood", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('_'), Block.field_72046_aM, Character.valueOf('P'), Block.field_71963_Z});
        this.recipe(new ItemStack((Item)this.barrel_enlarge), new Object[]{"IOI", "BWB", "ILI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), this.barrel_item, Character.valueOf('O'), Item.field_77730_bn, Character.valueOf('B'), Item.field_77731_bo, Character.valueOf('L'), Item.field_77770_aF});
        this.oreRecipe(this.barrel_item, "W-W", "W W", "WWW", Character.valueOf('W'), "logWood", Character.valueOf('-'), "slabWood");
        this.recipe(this.maker_item, "#p#", "# #", "#C#", Character.valueOf('#'), Block.field_71978_w, Character.valueOf('p'), Block.field_71963_Z, Character.valueOf('C'), Block.field_72060_ay);
        this.fake_is = this.maker_item;
        this.recipe(this.stamper_item, "#p#", "III", "#C#", Character.valueOf('#'), Block.field_71978_w, Character.valueOf('p'), Block.field_71963_Z, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Block.field_72060_ay);
        this.recipe(this.packager_item, "#M#", "# #", "#S#", Character.valueOf('#'), Block.field_71978_w, Character.valueOf('M'), this.maker_item, Character.valueOf('S'), this.stamper_item);
        this.oreRecipe(this.lamp_item, new Object[]{"ISI", "GWG", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), "ingotSilver", Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('W'), new ItemStack((Item)this.wrath_igniter, 1, Short.MAX_VALUE)});
        this.recipe(this.slagfurnace_item, "CFC", "C C", "CFC", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('F'), Block.field_72051_aB);
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(Block.field_71949_H));
        OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(Block.field_71941_G));
        OreDictionary.registerOre((String)"ingotIron", (ItemStack)new ItemStack(Item.field_77703_o));
        OreDictionary.registerOre((String)"ingotGold", (ItemStack)new ItemStack(Item.field_77717_p));
        TileEntitySlagFurnace.SlagRecipes.register(Block.field_72047_aN, 5.8f, Item.field_77767_aC, 0.2f, Block.field_71981_t);
        this.oreRecipe(this.greenware_item, "c", "-", Character.valueOf('c'), Item.field_77757_aI, Character.valueOf('-'), "slabWood");
        this.shapelessRecipe(this.sulfuric_acid, Item.field_77677_M, Item.field_77677_M, Item.field_77705_m, Item.field_77726_bs);
        this.shapelessOreRecipe(this.sulfuric_acid, "dustSulfur", Item.field_77705_m, Item.field_77726_bs);
        this.shapelessRecipe(this.aqua_regia, new Object[]{this.sulfuric_acid, this.nether_powder, Item.field_77811_bE});
        this.recipe(new ItemStack((Item)this.fan), "I I", " I ", "I I", Character.valueOf('I'), Item.field_77703_o);
        if (Core.enable_solar_steam) {
            this.recipe(this.solarboiler_item, "I#I", "I I", "III", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('#'), Block.field_72002_bp);
        }
        this.oreRecipe(this.steamturbine_item, new Object[]{"I#I", "GXG", "LML", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('#'), Block.field_72002_bp, Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('X'), this.fan, Character.valueOf('L'), "ingotLead", Character.valueOf('M'), this.motor});
        this.oreRecipe(new ItemStack((Item)this.charge_meter), "WSW", "W/W", "LIL", Character.valueOf('W'), "plankWood", Character.valueOf('S'), Item.field_77792_au, Character.valueOf('/'), Item.field_77669_D, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Item.field_77703_o);
        this.oreRecipe(new ItemStack((Item)this.battery, 1, 2), new Object[]{"ILI", "LAL", "ILI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('L'), "ingotLead", Character.valueOf('A'), this.acid});
        for (int damage : new int[]{1, 2}) {
            this.recipe(new ItemStack((Item)this.magnet), "WWW", "WIW", "WBW", Character.valueOf('W'), this.leadwire_item, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('B'), new ItemStack((Item)this.battery, 1, damage));
            this.recipe(new ItemStack((Item)this.battery, 1, damage - 1), "W", "B", "W", Character.valueOf('W'), this.leadwire_item, Character.valueOf('B'), new ItemStack((Item)this.battery, 1, damage));
        }
        this.oreRecipe(this.leydenjar_item, "#G#", "#L#", "L#L", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('G'), Block.field_71946_M, Character.valueOf('L'), "ingotLead");
        this.oreRecipe(this.heater_item, new Object[]{"CCC", "L L", "CCC", Character.valueOf('C'), this.insulated_coil, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new ItemStack((Item)this.insulated_coil, 4), "LLL", "LCL", "LLL", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), Block.field_72041_aW);
        this.oreRecipe(new ItemStack((Item)this.motor), new Object[]{"CIC", "CMC", "LIL", Character.valueOf('C'), this.insulated_coil, Character.valueOf('M'), this.magnet, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Item.field_77703_o});
        if (Core.enable_solar_steam) {
            this.oreRecipe(new ItemStack((Item)this.mirror), "SSS", "S#S", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), Block.field_72003_bq);
        }
        ItemStack with_8 = this.leadwire_item.func_77946_l();
        with_8.field_77994_a = 8;
        this.oreRecipe(with_8, "LLL", Character.valueOf('L'), "ingotLead");
        this.recipe(new ItemStack((Item)this.diamond_cutting_head), new Object[]{"SSS", "SIS", "SSS", Character.valueOf('S'), this.diamond_shard, Character.valueOf('I'), Item.field_77703_o});
        this.oreRecipe(this.grinder_item, new Object[]{"LIL", "I*I", "IMI", Character.valueOf('L'), "ingotLead", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('*'), this.diamond_cutting_head, Character.valueOf('M'), this.motor});
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71981_t), new ItemStack(Block.field_71978_w), 1.0f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_71940_F), 1.0f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71940_F), new ItemStack(Block.field_71939_E), 1.0f);
        TileEntityGrinder.addRecipe(new ItemStack((Block)Block.field_71980_u), new ItemStack(Block.field_71979_v), 1.0f);
        TileEntityGrinder.addRecipe(new ItemStack((Block)Block.field_71994_by), new ItemStack(Block.field_71979_v), 1.0f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_72073_aw), new ItemStack(Item.field_77702_n), 2.25f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_72068_bR), new ItemStack(Item.field_77817_bH), 2.25f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_72047_aN), new ItemStack(Item.field_77767_aC), 6.5f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71947_N), new ItemStack(Item.field_77756_aW, 1, 4), 8.0f);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_71950_I), new ItemStack(Item.field_77705_m), 3.5f);
        this.oreRecipe(this.mixer_item, new Object[]{" X ", "WMW", "LUL", Character.valueOf('X'), this.fan, Character.valueOf('W'), Item.field_77786_ax, Character.valueOf('M'), this.motor, Character.valueOf('L'), "ingotLead", Character.valueOf('U'), Item.field_77721_bz});
        FurnaceRecipes.func_77602_a().addSmelting(this.sludge.field_77779_bT, 0, new ItemStack(Item.field_77757_aI), 0.1f);
        this.recipe(this.crystallizer_item, "-", "S", "U", Character.valueOf('-'), Item.field_77669_D, Character.valueOf('S'), Item.field_77683_K, Character.valueOf('U'), Item.field_77721_bz);
        ItemStack lime = new ItemStack(Item.field_77756_aW, 1, 10);
        TileEntityCrystallizer.addRecipe(lime, new ItemStack(Item.field_77761_aM), 1.0f, new ItemStack(Item.field_77771_aG), 0);
        TileEntityGrinder.addRecipe(new ItemStack(Block.field_72012_bb), new ItemStack((Item)this.nether_powder, 1), 1.0f);
        if (Core.enable_dimension_slice) {
            this.shapelessRecipe(new ItemStack((Item)this.rocket_fuel, 3), new Object[]{this.nether_powder, this.nether_powder, this.nether_powder, Item.field_77811_bE});
            this.liquidStackRocketFuel = new LiquidStack(this.rocket_fuel_liquid_entry, 0);
            LiquidDictionary.getOrCreateLiquid((String)"powderRocketFuel", (LiquidStack)this.liquidStackRocketFuel);
            this.recipe(new ItemStack((Item)this.rocket_engine), new Object[]{"#F#", "#I#", "I I", Character.valueOf('#'), Block.field_72083_ai, Character.valueOf('F'), this.rocket_fuel, Character.valueOf('I'), Item.field_77703_o});
            this.shapelessRecipe(new ItemStack((Item)this.bucket_rocket_fuel), new Object[]{Item.field_77788_aw, this.rocket_fuel, this.rocket_fuel});
            ItemStack air = new ItemStack(Item.field_77788_aw, 0);
            ItemStack emptyBucket = new ItemStack(Item.field_77788_aw, 1);
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack(this.rocket_fuel_liquid_entry, 500), new ItemStack((Item)this.rocket_fuel, 1), air));
            LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(new LiquidStack(this.rocket_fuel_liquid_entry, 1000), new ItemStack((Item)this.bucket_rocket_fuel, 1), emptyBucket));
        }
        if (Core.servos_enabled) {
            this.makeServoRecipes();
        }
    }

    private void makeServoRecipes() {
        ItemStack rails = this.servorail_item.func_77946_l();
        rails.field_77994_a = 8;
        this.oreRecipe(rails, new Object[]{"DLD", Character.valueOf('D'), this.dark_iron, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(this.dark_iron_sprocket, new Object[]{" D ", "DSD", " D ", Character.valueOf('D'), this.dark_iron, Character.valueOf('S'), "ingotSilver"});
        this.recipe(this.sprocket_motor, new Object[]{" S ", "rMc", Character.valueOf('S'), this.dark_iron_sprocket, Character.valueOf('r'), Item.field_77742_bb, Character.valueOf('M'), this.motor, Character.valueOf('c'), Item.field_94585_bY});
        this.oreRecipe(new ItemStack((Item)this.servo_motor_placer), new Object[]{"MS ", " #P", "MS ", Character.valueOf('M'), this.sprocket_motor, Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), this.logicMatrix, Character.valueOf('P'), this.logicMatrixProgrammer});
        this.oreRecipe(new ItemStack((Item)this.actuator_item_manipulator), "| |", "|#|", "|P|", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('|'), Block.field_72003_bq, Character.valueOf('-'), Block.field_72046_aM, Character.valueOf('P'), Block.field_71963_Z);
        ServoComponent.setupRecipes();
        this.recipe(this.parasieve_item, new Object[]{"I#I", "DmD", "IHI", Character.valueOf('#'), Block.field_72002_bp, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('D'), this.dark_iron, Character.valueOf('H'), Block.field_94340_cs, Character.valueOf('m'), this.logicMatrixIdentifier});
    }

    public void setToolEffectiveness() {
        for (String tool : new String[]{"pickaxe", "axe", "shovel"}) {
            MinecraftForge.removeBlockEffectiveness((Block)this.factory_block, (String)tool);
            MinecraftForge.removeBlockEffectiveness((Block)this.resource_block, (String)tool);
        }
        BlockClass.DarkIron.harvest("pickaxe", 2);
        BlockClass.Barrel.harvest("axe", 1);
        BlockClass.Machine.harvest("pickaxe", 0);
        BlockClass.MachineLightable.harvest("pickaxe", 0);
        MinecraftForge.setBlockHarvestLevel((Block)this.resource_block, (String)"pickaxe", (int)2);
    }

    public void makeOther() {
        this.silverGen = new WorldGenMinable(this.resource_block.field_71990_ca, Core.silver_ore_node_size);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!Core.gen_silver_ore) {
            return;
        }
        if ((chunkZ + 3 * chunkX) % 5 != 0) {
            return;
        }
        int x = chunkX * 16 + rand.nextInt(16);
        int z = chunkZ * 16 + rand.nextInt(16);
        int y = 5 + rand.nextInt(48);
        this.silverGen.func_76484_a(world, rand, x, y, z);
    }

    public void onTickServer() {
        TileEntityWrathLamp.handleAirUpdates();
        TileEntityWrathFire.updateCount = 0;
    }

    public boolean extractEnergy(EntityPlayer player, int chargeCount) {
        ItemStack is;
        int i;
        InventoryPlayer inv = player.field_71071_by;
        int totalCharge = 0;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            is = inv.func_70301_a(i);
            if (is == null || is.func_77973_b() != this.battery) continue;
            totalCharge += this.battery.getStorage(is);
        }
        if (totalCharge < chargeCount) {
            return false;
        }
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            is = inv.func_70301_a(i);
            if (is == null || is.func_77973_b() != this.battery) continue;
            int storage = this.battery.getStorage(is);
            int delta = Math.min(chargeCount, storage);
            storage -= delta;
            chargeCount -= delta;
            if (delta > 0) {
                this.battery.setStorage(is, storage);
            }
            if (chargeCount > 0) continue;
            return true;
        }
        return false;
    }

    @ForgeSubscribe
    public boolean onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        EntityItem item2 = event.item;
        ItemStack is = item2.func_92059_d();
        if (item2 == null || is == null || is.field_77994_a == 0) {
            return true;
        }
        if (player.field_70128_L) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        int remaining_size = is.field_77994_a;
        int free_slots = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int free;
            ItemStack here = inv.func_70301_a(i);
            if (here == null) {
                ++free_slots;
                continue;
            }
            if (FactorizationUtil.couldMerge(is, here) && (remaining_size -= (free = here.func_77976_d() - here.field_77994_a)) <= 0) break;
        }
        if (remaining_size > 0) {
            ArrayList<ItemStack> bags = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack here = inv.func_70301_a(i);
                if (here == null || here.func_77973_b() != this.bag_of_holding) continue;
                bags.add(here);
            }
            boolean success = false;
            for (ItemStack bag : bags) {
                if (is.field_77994_a < 0) break;
                success = this.bag_of_holding.insertItem(bag, is);
            }
            if (success) {
                Sound.bagSlurp.playAt((Entity)player);
            }
        }
        Core.proxy.pokePocketCrafting();
        return true;
    }

    public void onCrafting(EntityPlayer player, ItemStack stack, IInventory craftMatrix) {
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            Item item2;
            ItemStack here = craftMatrix.func_70301_a(i);
            if (here == null || !((item2 = here.func_77973_b()) instanceof IActOnCraft)) continue;
            ((IActOnCraft)item2).onCraft(here, craftMatrix, i, stack, player);
        }
        if (stack.func_77973_b() == this.item_craft && stack.func_77960_j() == this.diamond_shard_packet.func_77960_j()) {
            stack.func_77982_d((NBTTagCompound)this.diamond_shard_packet.func_77978_p().func_74737_b());
            stack.func_77964_b(1);
        }
    }

    public void onSmelting(EntityPlayer player, ItemStack item2) {
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        this.onTickServer();
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return this.serverTicks;
    }

    public String getLabel() {
        return "FZ_registry";
    }

    public void loadLanguages() {
        URL url = this.getClass().getResource(Core.language_file);
        if (url == null) {
            Core.logSevere("Language file %s was not found", url);
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
                String[] parts = line.split("=");
                String key = parts[0];
                String value = parts[1];
                LanguageRegistry.instance().addStringLocalization(key, value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendIMC() {
        for (String msg : new String[]{"factorization crystallizer recipes@fz.crystallizing", "factorization grinder recipes@fz.grinding", "factorization mixer recipes@fz.mixing", "factorization slag furnace recipes@fz.slagging"}) {
            FMLInterModComms.sendRuntimeMessage((Object)Core.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("Factorization@" + msg));
        }
    }
}

