/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.IActOnCraft;
import factorization.common.Core;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemOreProcessing
extends Item
implements IActOnCraft {
    public static ArrayList OD_ores = new ArrayList();
    public static ArrayList OD_ingots = new ArrayList();
    String stateName;

    protected ItemOreProcessing(int itemID, int icon, String stateName) {
        super(itemID);
        this.func_77627_a(true);
        this.stateName = stateName;
        Core.tab(this, Core.TabType.MATERIALS);
        this.func_77655_b("factorization:ore/" + stateName);
    }

    public int func_82790_a(ItemStack is, int renderPass) {
        try {
            return OreType.values()[is.func_77960_j()].color;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0xFFFF00;
        }
    }

    public String func_77667_c(ItemStack is) {
        return "item.factorization:ore/" + this.stateName + "/" + (Object)((Object)OreType.values()[is.func_77960_j()]);
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (OreType oreType : OreType.values()) {
            if (!oreType.enabled) continue;
            boolean show = true;
            if ((this == Core.registry.ore_crystal || this == Core.registry.ore_reduced) && oreType == OreType.GALENA) {
                show = false;
            }
            if (!(this != Core.registry.ore_dirty_gravel && this != Core.registry.ore_clean_gravel || oreType != OreType.SILVER && oreType != OreType.LEAD)) {
                show = false;
            }
            if (!show) continue;
            list.add(new ItemStack((Item)this, 1, oreType.ID));
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        Core.brand(is, infoList);
    }

    public ItemStack makeStack(OreType ot) {
        return new ItemStack((Item)this, 1, ot.ID);
    }

    @Override
    public void onCraft(ItemStack is, IInventory craftMatrix, int craftSlot, ItemStack result, EntityPlayer player) {
        if (result == null) {
            return;
        }
        if (result.func_77973_b() != Core.registry.ore_clean_gravel) {
            return;
        }
        if (is.func_77973_b() != Core.registry.ore_dirty_gravel) {
            return;
        }
        if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K) {
            return;
        }
        boolean any = false;
        for (int stack_index = 0; stack_index < is.field_77994_a; ++stack_index) {
            ItemStack pi;
            int i;
            if (Math.random() > 0.25) continue;
            any = true;
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                pi = player.field_71071_by.func_70301_a(i);
                if (pi == null || pi.func_77973_b() != Core.registry.sludge || pi.field_77994_a >= pi.func_77976_d()) continue;
                ++pi.field_77994_a;
                return;
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                pi = player.field_71071_by.func_70301_a(i);
                if (pi != null) continue;
                player.field_71071_by.func_70299_a(i, new ItemStack((Item)Core.registry.sludge, 1));
                return;
            }
            player.func_71021_b(new ItemStack((Item)Core.registry.sludge, 1));
        }
        if (any) {
            Core.proxy.updatePlayerInventory(player);
        }
    }

    public static enum OreType {
        IRON(0, 0xD8D8D8, "Iron", "oreIron", "ingotIron"),
        GOLD(1, 15657768, "Gold", "oreGold", "ingotGold"),
        LEAD(2, 3091516, "Lead", null, "ingotLead"),
        TIN(3, 0xD7F7FF, "Tin", "oreTin", "ingotTin"),
        COPPER(4, 14060601, "Copper", "oreCopper", "ingotCopper"),
        SILVER(5, 8099513, "Silver", null, "ingotSilver"),
        GALENA(6, 6847385, "Galena", "oreSilver", null);

        int ID;
        int color;
        String en_name;
        String OD_ore;
        String OD_ingot;
        boolean enabled = false;
        ItemStack processingResult = null;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private OreType(String ID, String color, String en_name) {
            void OD_ingot;
            void OD_ore;
            this.ID = (int)ID;
            this.color = (int)color;
            this.en_name = en_name;
            this.OD_ore = OD_ore;
            this.OD_ingot = OD_ingot;
            if (OD_ore != null) {
                OD_ores.add(OD_ore);
            }
            if (OD_ingot != null) {
                OD_ingots.add(OD_ingot);
            }
        }

        public void enable() {
            if (!this.enabled) {
                ItemStack dirty = Core.registry.ore_dirty_gravel.makeStack(this);
                ItemStack clean = Core.registry.ore_clean_gravel.makeStack(this);
                ItemStack reduced = Core.registry.ore_reduced.makeStack(this);
                ItemStack crystal = Core.registry.ore_crystal.makeStack(this);
                OreDictionary.registerOre((String)("dirtyGravel" + this.en_name), (ItemStack)dirty);
                OreDictionary.registerOre((String)("cleanGravel" + this.en_name), (ItemStack)clean);
                OreDictionary.registerOre((String)("reduced" + this.en_name), (ItemStack)reduced);
                OreDictionary.registerOre((String)("crystalline" + this.en_name), (ItemStack)crystal);
            }
            this.enabled = true;
        }

        public static OreType fromOreClass(String oreClass) {
            for (OreType ot : OreType.values()) {
                if (ot.OD_ingot != null && ot.OD_ingot.equals(oreClass)) {
                    return ot;
                }
                if (ot.OD_ore == null || !ot.OD_ore.equals(oreClass)) continue;
                return ot;
            }
            return null;
        }
    }
}

