/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.IActOnCraft;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemBagOfHolding
extends Item
implements IActOnCraft {
    final String pearlcount = "pearlcount";

    public ItemBagOfHolding(int id) {
        super(id);
        this.func_77625_d(1);
        Core.tab(this, Core.TabType.TOOLS);
        this.func_77655_b("factorization:tool/bag_of_holding");
    }

    public void init(ItemStack is) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            is.func_77982_d(tag);
        }
        if (!tag.func_74764_b("pearlcount")) {
            tag.func_74768_a("pearlcount", 0);
        }
    }

    public void addPearl(ItemStack is) {
        this.init(is);
        NBTTagCompound tag = is.func_77978_p();
        int i = 1 + tag.func_74762_e("pearlcount");
        tag.func_74768_a("pearlcount", i);
    }

    int getNumOfCols(ItemStack is) {
        if (is == null) {
            return 3;
        }
        this.init(is);
        return 3 + is.func_77978_p().func_74762_e("pearlcount");
    }

    private ArrayList padRow(ArrayList row, int columnCount) {
        columnCount -= row.size();
        while (columnCount > 0) {
            --columnCount;
            row.add(null);
        }
        return row;
    }

    ArrayList getRow(ItemStack is, int row) {
        int colCount = this.getNumOfCols(is);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            return this.padRow(ret, colCount);
        }
        NBTTagList items = tag.func_74761_m("row" + row);
        if (items == null || items.func_74745_c() != colCount) {
            return this.padRow(ret, colCount);
        }
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item2 = (NBTTagCompound)items.func_74743_b(i);
            ret.add(ItemStack.func_77949_a((NBTTagCompound)item2));
        }
        return this.padRow(ret, colCount);
    }

    void writeRow(ItemStack is, ArrayList items, int row) {
        this.init(is);
        NBTTagList list = new NBTTagList("row" + row);
        for (ItemStack i : items) {
            NBTTagCompound add = new NBTTagCompound();
            if (i != null) {
                list.func_74742_a((NBTBase)i.func_77955_b(add));
                continue;
            }
            list.func_74742_a((NBTBase)add);
        }
        NBTTagCompound tag = is.func_77978_p();
        tag.func_74782_a("row" + row, (NBTBase)list);
    }

    public void useBag(EntityPlayer player, boolean reverse) {
        if (reverse) {
            this.swapItemsReverse(player);
        } else {
            this.swapItems(player);
        }
        Core.proxy.pokePocketCrafting();
    }

    int findBag(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            ItemStack is = inv.field_70462_a[i];
            if (is == null || is.func_77973_b() != this) continue;
            return i;
        }
        return -1;
    }

    void swapItems(EntityPlayer player) {
        int i = this.findBag(player);
        if (i == -1) {
            return;
        }
        InventoryPlayer inv = player.field_71071_by;
        int bag_col = i % 9;
        int bag_height = i / 9;
        ItemStack is = inv.field_70462_a[i];
        if (bag_col == 8) {
            return;
        }
        for (int row = 0; row < 4; ++row) {
            ArrayList items = this.getRow(is, row);
            while (items.size() < this.getNumOfCols(is)) {
                items.add(null);
            }
            for (int j = row * 9 + bag_col + 1; j < (1 + row) * 9; ++j) {
                ItemStack removed;
                items.add(inv.field_70462_a[j]);
                inv.field_70462_a[j] = removed = (ItemStack)items.remove(0);
                if (removed == null) continue;
                removed.field_77992_b = 3;
            }
            this.writeRow(is, items, row);
        }
    }

    void swapItemsReverse(EntityPlayer player) {
        int i = this.findBag(player);
        if (i == -1) {
            return;
        }
        InventoryPlayer inv = player.field_71071_by;
        int bag_col = i % 9;
        int bag_height = i / 9;
        ItemStack is = inv.field_70462_a[i];
        if (bag_col == 8) {
            return;
        }
        for (int row = 0; row < 4; ++row) {
            ArrayList items = this.getRow(is, row);
            while (items.size() < this.getNumOfCols(is)) {
                items.add(0, null);
            }
            for (int j = (1 + row) * 9 - 1; j >= row * 9 + bag_col + 1; --j) {
                ItemStack removed;
                items.add(0, inv.field_70462_a[j]);
                inv.field_70462_a[j] = removed = (ItemStack)items.remove(items.size() - 1);
                if (removed == null) continue;
                removed.field_77992_b = 3;
            }
            this.writeRow(is, items, row);
        }
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        if (is.func_77978_p() == null) {
            Core.brand(is, list);
            return;
        }
        int n = this.getNumOfCols(is);
        list.add("Stores " + n + " columns");
        Core.brand(is, list);
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof IInventory)) {
            return false;
        }
        FactorizationUtil.FzInv inv = FactorizationUtil.openInventory((IInventory)te, side);
        for (int row = 0; row < 4; ++row) {
            ArrayList items = this.getRow(is, row);
            for (int i = 0; i < items.size(); ++i) {
                ItemStack row_is = (ItemStack)items.get(i);
                if (row_is == null) continue;
                items.set(i, inv.push(row_is));
            }
            this.writeRow(is, items, row);
        }
        return true;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return System.currentTimeMillis() / 75000L % 7L == 5L;
    }

    public boolean insertItem(ItemStack is, ItemStack add) {
        ArrayList<ArrayList> contents = new ArrayList<ArrayList>(4);
        for (int i = 0; i < 4; ++i) {
            contents.add(this.getRow(is, i));
        }
        boolean did_something = false;
        int num_cols = this.getNumOfCols(is);
        boolean should_add = false;
        block1: for (int col = 0; col < num_cols; ++col) {
            for (int row_id = 0; row_id < 4; ++row_id) {
                ArrayList row = (ArrayList)contents.get(row_id);
                ItemStack here = (ItemStack)row.get(col);
                if (here == null && should_add) {
                    should_add = false;
                    here = ItemStack.func_77944_b((ItemStack)add);
                    here.field_77994_a = 0;
                    row.set(col, here);
                }
                if (here == null || !FactorizationUtil.couldMerge(here, add)) continue;
                should_add = true;
                int free = here.func_77976_d() - here.field_77994_a;
                if (free <= 0) continue;
                int delta = Math.min(free, add.field_77994_a);
                add.field_77994_a -= delta;
                here.field_77994_a += delta;
                did_something = true;
                if (add.field_77994_a <= 0) break block1;
            }
        }
        if (did_something) {
            is.field_77992_b = 5;
            for (int row_id = 0; row_id < 4; ++row_id) {
                this.writeRow(is, (ArrayList)contents.get(row_id), row_id);
            }
        }
        return did_something;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public void onCraft(ItemStack is, IInventory craftMatrix, int craftSlot, ItemStack result, EntityPlayer player) {
        this.init(result);
        boolean bag = false;
        boolean pearl = false;
        boolean dark_iron = false;
        boolean leather = false;
        boolean bad = false;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack here = craftMatrix.func_70301_a(i);
            if (here == null) continue;
            Item it = here.func_77973_b();
            if (it == this) {
                if (bag) {
                    bad = true;
                    break;
                }
                bag = true;
            }
            if (it == Item.field_77730_bn) {
                if (pearl) {
                    bad = true;
                    break;
                }
                pearl = true;
            }
            if (it == Core.registry.dark_iron) {
                if (dark_iron) {
                    bad = true;
                    break;
                }
                dark_iron = true;
            }
            if (it != Item.field_77770_aF) continue;
            if (leather) {
                bad = true;
                break;
            }
            leather = true;
        }
        if (!bad && bag && pearl && dark_iron && leather) {
            result.func_77982_d(is.func_77978_p());
            this.addPearl(result);
        }
    }
}

