/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.IFactoryType;
import factorization.common.BlockClass;
import factorization.common.BlockIcons;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactorizationTextureLoader;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.Registry;
import factorization.common.TileEntityBattery;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityExtension;
import factorization.common.TileEntityFactorization;
import factorization.common.TileEntityFzNull;
import factorization.common.TileEntityGreenware;
import factorization.common.TileEntityLeydenJar;
import factorization.common.servo.Decorator;
import factorization.common.servo.TileEntityServoRail;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockFactorization
extends BlockContainer {
    public boolean fake_normal_render = false;
    public static Icon force_texture = null;
    private Icon tempParticleIcon = null;
    LinkedList destroyed_tes = new LinkedList();
    public static final float lamp_pad = 0.0625f;
    public static int sideDisable = 0;
    static final Random rand = new Random();

    public BlockFactorization(int id) {
        super(id, Core.registry.materialMachine);
        this.func_71848_c(2.0f);
        this.func_71894_b(5.0f);
        this.func_71868_h(1);
        BlockFactorization.field_71985_p[id] = true;
        this.func_71907_b(false);
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityFzNull();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityServoRail sr;
        Decorator decoration;
        ItemStack is;
        TileEntityCommon parent;
        TileEntityCommon tec = (TileEntityCommon)new Coord(world, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return null;
        }
        FactoryType ft = tec.getFactoryType();
        if (ft == FactoryType.EXTENDED && (parent = ((TileEntityExtension)tec).getParent()) != null) {
            tec = parent;
            ft = parent.getFactoryType();
        }
        if (ft == FactoryType.MIRROR) {
            return new ItemStack((Item)Core.registry.mirror);
        }
        if (ft == FactoryType.BATTERY) {
            is = new ItemStack((Item)Core.registry.battery);
            TileEntityBattery bat = (TileEntityBattery)tec;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("storage", bat.storage);
            is.func_77982_d(tag);
            Core.registry.battery.normalizeDamage(is);
            return is;
        }
        if (ft == FactoryType.LEYDENJAR) {
            is = new ItemStack((Item)Core.registry.item_factorization, 1, tec.getFactoryType().md);
            NBTTagCompound tag = FactorizationUtil.getTag(is);
            TileEntityLeydenJar jar = (TileEntityLeydenJar)tec;
            tag.func_74768_a("storage", jar.storage);
            return is;
        }
        if (ft == FactoryType.CERAMIC) {
            return ((TileEntityGreenware)tec).getItem();
        }
        if (ft == FactoryType.ROCKETENGINE) {
            return new ItemStack((Item)Core.registry.rocket_engine);
        }
        if (ft == FactoryType.SERVORAIL && (decoration = (sr = (TileEntityServoRail)tec).getDecoration()) != null) {
            return decoration.toItem();
        }
        return new ItemStack((Item)Core.registry.item_factorization, 1, ft.md);
    }

    public boolean func_71887_s() {
        return true;
    }

    public boolean func_71924_d(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity t = world.func_72796_p(x, y, z);
        if (t == null || !(t instanceof TileEntityCommon)) {
            return false;
        }
        TileEntityCommon te = (TileEntityCommon)t;
        return te.isBlockSolidOnSide(side);
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.func_71924_d((IBlockAccess)world, x, y, z, side.ordinal());
    }

    public void func_71863_a(World w, int x, int y, int z, int l) {
        int md = w.func_72805_g(x, y, z);
        TileEntity ent = w.func_72796_p(x, y, z);
        if (ent == null) {
            return;
        }
        if (ent instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)ent;
            tec.neighborChanged();
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float vecx, float vecy, float vecz) {
        ItemStack cur;
        Coord here = new Coord(world, x, y, z);
        if (here.getTE() == null && world.field_72995_K) {
            Core.network.broadcastMessage(null, here, 2, new Object[0]);
        }
        if (entityplayer.func_70093_af() && ((cur = entityplayer.func_71045_bC()) == null || cur.func_77973_b() != Core.registry.logicMatrixProgrammer)) {
            return false;
        }
        TileEntityCommon t = (TileEntityCommon)here.getTE(TileEntityCommon.class);
        if (t != null) {
            return t.activate(entityplayer, ForgeDirection.getOrientation((int)side));
        }
        if (world.field_72995_K) {
            if (here.getTE() == null) {
                Core.network.broadcastMessage(null, here, 2, new Object[0]);
                return false;
            }
            return false;
        }
        entityplayer.func_71035_c("This block is missing its TileEntity, possibly due to a bug in Factorization.");
        if (Core.proxy.isPlayerAdmin(entityplayer) || entityplayer.field_71075_bZ.field_75098_d) {
            entityplayer.func_71035_c("The block and its contents can not be recovered.");
        } else {
            entityplayer.func_71035_c("It can not be repaired without cheating.");
        }
        return true;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer entityplayer) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity t = world.func_72796_p(x, y, z);
        if (t instanceof TileEntityFactorization) {
            ((TileEntityFactorization)t).click(entityplayer);
        }
    }

    public void func_94332_a(IconRegister reg) {
        FactorizationTextureLoader.register(reg, BlockIcons.class);
        Core.proxy.texturepackChanged();
    }

    public Icon func_71895_b(IBlockAccess w, int x, int y, int z, int side) {
        if (force_texture != null) {
            return force_texture;
        }
        TileEntity t = w.func_72796_p(x, y, z);
        if (t instanceof TileEntityCommon) {
            return ((TileEntityCommon)t).getIcon(ForgeDirection.getOrientation((int)side));
        }
        return BlockIcons.error;
    }

    public Icon func_71858_a(int side, int md) {
        if (this.tempParticleIcon != null) {
            Icon ret = this.tempParticleIcon;
            this.tempParticleIcon = null;
            return ret;
        }
        FactoryType ft = FactoryType.fromMd(md);
        if (ft == null) {
            return BlockIcons.default_icon;
        }
        TileEntityCommon rep = ft.getRepresentative();
        if (rep == null) {
            return BlockIcons.error;
        }
        return rep.getIcon(ForgeDirection.getOrientation((int)side));
    }

    public int func_71899_b(int i) {
        return i;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public void func_71852_a(World w, int x, int y, int z, int id, int md) {
        Coord here = new Coord(w, x, y, z);
        TileEntityCommon te = (TileEntityCommon)here.getTE(TileEntityCommon.class);
        if (te != null) {
            te.onRemove();
            this.destroyed_tes.add(te);
        }
        super.func_71852_a(w, x, y, z, id, md);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        Coord here = new Coord(world, x, y, z);
        TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
        if (tec == null) {
            Core.notify(null, here, "No TileEntity!", new String[0]);
            return super.removeBlockByPlayer(world, player, x, y, z);
        }
        return tec.removeBlockByPlayer(player);
    }

    public ArrayList getBlockDropped(World world, int X, int Y, int Z, int md, int fortune) {
        TileEntityCommon parent;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Coord here = new Coord(world, X, Y, Z);
        IFactoryType f = (IFactoryType)here.getTE(IFactoryType.class);
        if (f == null) {
            Iterator it = this.destroyed_tes.iterator();
            TileEntityCommon destroyedTE = null;
            while (it.hasNext()) {
                TileEntityCommon tec = (TileEntityCommon)it.next();
                if (!tec.getCoord().equals(here)) continue;
                destroyedTE = tec;
                it.remove();
                break;
            }
            if (destroyedTE == null) {
                Core.logWarning("No IFactoryType TE behind block that was destroyed, and nothing saved!", new Object[0]);
                destroyedTE = null;
                return ret;
            }
            Coord destr = destroyedTE.getCoord();
            if (!destr.equals(here)) {
                Core.logWarning("Last saved destroyed TE wasn't for this location", new Object[0]);
                destroyedTE = null;
                return ret;
            }
            if (!(destroyedTE instanceof IFactoryType)) {
                Core.logWarning("TileEntity isn't an IFT! It's " + here.getTE(), new Object[0]);
                destroyedTE = null;
                return ret;
            }
            f = destroyedTE;
            destroyedTE = null;
        }
        ItemStack is = new ItemStack((Item)Core.registry.item_factorization, 1, f.getFactoryType().md);
        if (f.getFactoryType() == FactoryType.EXTENDED && (parent = ((TileEntityExtension)f).getParent()) != null) {
            f = parent;
        }
        if (f.getFactoryType() == FactoryType.MIRROR) {
            is = new ItemStack((Item)Core.registry.mirror);
        }
        if (f.getFactoryType() == FactoryType.BATTERY) {
            is = new ItemStack((Item)Core.registry.battery);
            TileEntityBattery bat = (TileEntityBattery)f;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("storage", bat.storage);
            is.func_77982_d(tag);
            Core.registry.battery.normalizeDamage(is);
        }
        if (f.getFactoryType() == FactoryType.LEYDENJAR) {
            NBTTagCompound tag = FactorizationUtil.getTag(is);
            TileEntityLeydenJar jar = (TileEntityLeydenJar)f;
            tag.func_74768_a("storage", jar.storage);
        }
        if (f.getFactoryType() == FactoryType.ROCKETENGINE) {
            is = new ItemStack((Item)Core.registry.rocket_engine);
        }
        ret.add(is);
        return ret;
    }

    public void addCreativeItems(ArrayList itemList) {
        if (this != Core.registry.factory_block) {
            return;
        }
        Registry reg = Core.registry;
        itemList.add(reg.barrel_item);
        itemList.add(reg.maker_item);
        itemList.add(reg.stamper_item);
        itemList.add(reg.packager_item);
        itemList.add(reg.slagfurnace_item);
        itemList.add(reg.parasieve_item);
        itemList.add(reg.router_item);
        itemList.add(reg.servorail_item);
        itemList.add(reg.lamp_item);
        if (reg.battery != null) {
            itemList.add(new ItemStack((Item)reg.battery, 1, 2));
        }
        itemList.add(reg.solarboiler_item);
        itemList.add(reg.steamturbine_item);
        if (reg.mirror != null) {
            itemList.add(new ItemStack((Item)reg.mirror));
        }
        itemList.add(reg.heater_item);
        itemList.add(reg.leadwire_item);
        itemList.add(reg.grinder_item);
        itemList.add(reg.mixer_item);
        itemList.add(reg.crystallizer_item);
        itemList.add(reg.leydenjar_item);
        if (reg.leydenjar_item_full != null) {
            itemList.add(reg.leydenjar_item_full);
        }
        itemList.add(reg.greenware_item);
        if (reg.rocket_engine != null) {
            itemList.add(new ItemStack((Item)reg.rocket_engine));
        }
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        if (this != Core.registry.factory_block) {
            return;
        }
        Core.addBlockToCreativeList(par3List, (Block)this);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int dir) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityCommon) {
            TileEntityCommon tec = (TileEntityCommon)te;
            return tec.getFactoryType().connectRedstone();
        }
        return false;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return BlockClass.get(world.func_72805_g(i, j, k)).isNormal();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int md, ForgeDirection face) {
        if (BlockClass.Barrel.md == md) {
            return 20;
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return BlockClass.Barrel.md == metadata;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te;
        int md = world.func_72805_g(x, y, z);
        BlockClass c = BlockClass.get(md);
        if (c == BlockClass.MachineLightable && (te = world.func_72796_p(x, y, z)) instanceof TileEntityFactorization) {
            if (((TileEntityFactorization)te).draw_active == 0) {
                return BlockClass.Machine.lightValue;
            }
            return c.lightValue;
        }
        if (c == BlockClass.MachineDynamicLightable && (te = world.func_72796_p(x, y, z)) instanceof TileEntityCommon) {
            return ((TileEntityCommon)te).getDynamicLight();
        }
        return BlockClass.get((int)md).lightValue;
    }

    public float func_71934_m(World w, int x, int y, int z) {
        BlockClass bc = BlockClass.get(w.func_72805_g(x, y, z));
        return bc.hardness;
    }

    public MovingObjectPosition func_71878_a(World w, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TileEntityCommon tec = (TileEntityCommon)new Coord(w, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return super.func_71878_a(w, x, y, z, startVec, endVec);
        }
        return tec.collisionRayTrace(startVec, endVec);
    }

    public AxisAlignedBB func_71872_e(World w, int x, int y, int z) {
        TileEntityCommon tec = (TileEntityCommon)new Coord(w, x, y, z).getTE(TileEntityCommon.class);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (tec == null) {
            return super.func_71872_e(w, x, y, z);
        }
        return tec.getCollisionBoundingBoxFromPool();
    }

    public void func_71871_a(World w, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        BlockRenderHelper test;
        TileEntityCommon tec = (TileEntityCommon)new Coord(w, x, y, z).getTE(TileEntityCommon.class);
        BlockRenderHelper blockRenderHelper = test = w.field_72995_K ? Core.registry.clientTraceHelper : Core.registry.serverTraceHelper;
        if (tec == null || !tec.addCollisionBoxesToList(test, aabb, list, entity)) {
            super.func_71871_a(w, x, y, z, aabb, list, entity);
        }
    }

    public AxisAlignedBB func_71911_a_(World w, int x, int y, int z) {
        AxisAlignedBB ret;
        TileEntityCommon tec;
        TileEntity te = w.func_72796_p(x, y, z);
        if (te instanceof TileEntityCommon && (tec = (TileEntityCommon)te).getFactoryType() == FactoryType.EXTENDED && (ret = tec.getCollisionBoundingBoxFromPool()) != null) {
            return ret;
        }
        return super.func_71911_a_(w, x, y, z);
    }

    public void func_71902_a(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_72796_p(x, y, z);
        if (te == null || !(te instanceof TileEntityCommon)) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        ((TileEntityCommon)te).setBlockBounds((Block)this);
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        if (this.fake_normal_render) {
            return 0;
        }
        return Core.factory_rendertype;
    }

    public boolean func_71853_i() {
        return true;
    }

    public void func_71847_b(World w, int x, int y, int z, Random rand) {
        new Coord(w, x, y, z).notifyBlockChange();
    }

    public int func_71855_c(IBlockAccess w, int x, int y, int z, int side) {
        if (side < 2) {
            return 0;
        }
        TileEntity te = w.func_72796_p(x, y, z);
        if (te instanceof TileEntityCommon) {
            return ((TileEntityCommon)te).power() ? 15 : 0;
        }
        return 0;
    }

    public int func_71865_a(IBlockAccess w, int x, int y, int z, int side) {
        return this.func_71855_c(w, x, y, z, side);
    }

    public void func_71862_a(World w, int x, int y, int z, Random rand) {
        Core.proxy.randomDisplayTickFor(w, x, y, z, rand);
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean isAirBlock(World world, int x, int y, int z) {
        return false;
    }

    public boolean func_71877_c(IBlockAccess iworld, int x, int y, int z, int side) {
        if (sideDisable != 0) {
            return (sideDisable & 1 << side) == 0;
        }
        return super.func_71877_c(iworld, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        Coord here = new Coord(worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
        this.tempParticleIcon = tec == null ? BlockIcons.default_icon : tec.getIcon(ForgeDirection.getOrientation((int)target.field_72310_e));
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        Coord here = new Coord(world, x, y, z);
        TileEntityCommon tec = (TileEntityCommon)here.getTE(TileEntityCommon.class);
        Icon theIcon = tec == null ? BlockIcons.default_icon : tec.getIcon(ForgeDirection.DOWN);
        int b0 = 4;
        Minecraft mc = Minecraft.func_71410_x();
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, Block.field_71981_t, i2, 0, mc.field_71446_o).func_70596_a(x, y, z);
                    fx.func_94052_a(mc.field_71446_o, theIcon);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileEntityCommon tec = (TileEntityCommon)new Coord(worldObj, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return false;
        }
        return tec.rotate(axis);
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        TileEntityCommon tec = (TileEntityCommon)new Coord(worldObj, x, y, z).getTE(TileEntityCommon.class);
        if (tec == null) {
            return TileEntityCommon.empty_rotation_array;
        }
        return tec.getValidRotations();
    }
}

