/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoord;
import factorization.api.VectorUV;
import factorization.client.render.ItemRenderCapture;
import factorization.common.BlockFactorization;
import factorization.common.BlockIcons;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.WireRenderingCube;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class FactorizationBlockRender
implements ICoord {
    static Block metal = Block.field_72089_ap;
    static Block glass = Block.field_72014_bd;
    protected boolean world_mode;
    protected boolean use_vertex_offset;
    protected IBlockAccess w;
    protected int x;
    protected int y;
    protected int z;
    protected int metadata;
    protected TileEntity te;
    protected ItemStack is;
    protected IItemRenderer.ItemRenderType renderType;
    private static FactorizationBlockRender[] renderMap = new FactorizationBlockRender[255];
    private static FactorizationBlockRender defaultRender;
    protected String cubeTexture = "/terrain.png";
    private static RenderBlocks rb;
    static float[] directionLighting;
    float vertexColorResult;
    int vertexBrightnessResult;
    DeltaCoord outward = new DeltaCoord();
    DeltaCoord corner = new DeltaCoord();
    int[] mixedBrightness = new int[3];
    float[] aoLightValue = new float[3];
    boolean[] aoGrass = new boolean[3];
    float faceColor;
    boolean isDebugVertex = false;
    static boolean force_inv;
    private static int[] allFaces;

    public static void setDefaultRender(FactoryType ft) {
        assert (defaultRender != null);
        FactorizationBlockRender.renderMap[ft.md] = defaultRender;
    }

    public static FactorizationBlockRender getRenderer(int md) {
        FactorizationBlockRender ret = renderMap[md];
        if (ret == null) {
            FactorizationBlockRender.renderMap[md] = defaultRender;
            Core.logFine("No renderer for ID " + md, new Object[0]);
            return defaultRender;
        }
        return ret;
    }

    public FactorizationBlockRender() {
        if (this.getFactoryType() != null) {
            int md = this.getFactoryType().md;
            if (renderMap[md] != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            FactorizationBlockRender.renderMap[md] = this;
        } else {
            if (defaultRender != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            defaultRender = this;
        }
    }

    public FactorizationBlockRender(FactoryType ft) {
        if (ft != null) {
            int md = ft.md;
            if (renderMap[md] != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            FactorizationBlockRender.renderMap[md] = this;
        } else {
            if (defaultRender != null) {
                throw new RuntimeException("Tried to overwrite a renderer");
            }
            defaultRender = this;
        }
    }

    protected abstract void render(RenderBlocks var1);

    protected abstract FactoryType getFactoryType();

    void renderSecondPass(RenderBlocks rb) {
    }

    @Override
    public Coord getCoord() {
        if (!this.world_mode) {
            if (this.te != null) {
                return new Coord(this.te);
            }
            return null;
        }
        return new Coord((World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z);
    }

    public final void renderInWorld(IBlockAccess w, int wx, int wy, int wz) {
        this.world_mode = true;
        this.w = w;
        this.x = wx;
        this.y = wy;
        this.z = wz;
        this.use_vertex_offset = true;
        this.te = null;
    }

    public final void renderInInventory() {
        this.world_mode = false;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.use_vertex_offset = true;
        this.te = null;
        this.is = ItemRenderCapture.getRenderingItem();
        this.renderType = ItemRenderCapture.getRenderType();
    }

    public final void setTileEntity(TileEntity t) {
        this.te = t;
    }

    public final void setMetadata(int md) {
        this.metadata = md;
    }

    protected void renderNormalBlock(RenderBlocks rb, int md) {
        BlockFactorization b = Core.registry.factory_rendering_block;
        rb.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.world_mode) {
            rb.func_78570_q((Block)b, this.x, this.y, this.z);
        } else {
            Core.registry.factory_rendering_block.fake_normal_render = true;
            rb.func_78600_a((Block)b, md, 1.0f);
            Core.registry.factory_rendering_block.fake_normal_render = false;
        }
    }

    protected void renderCauldron(RenderBlocks rb, Icon lid, Icon metal) {
        this.renderCauldron(rb, lid, metal, 1.0f);
    }

    protected void renderCauldron(RenderBlocks rb, Icon lid, Icon metal, float height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        block2.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f);
        block2.useTextures(metal, lid, metal, metal, metal, metal);
        if (this.world_mode) {
            block2.render(rb, this.getCoord());
            float d = 0.125f;
            boolean origAO = rb.field_78677_m;
            rb.func_83020_a((double)d, (double)d, (double)d, (double)(1.0f - d), (double)height, (double)(1.0f - d));
            block2.func_71905_a(d, d, d, 1.0f - d, 1.0f - d, 1.0f - d);
            rb.field_78677_m = false;
            rb.func_78573_e((Block)block2, (double)((float)(this.x + 1) - 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.func_78611_c((Block)block2, (double)this.x, (double)this.y, (double)((float)(this.z + 1) - 2.0f * d), metal);
            rb.func_78605_f((Block)block2, (double)((float)(this.x - 1) + 2.0f * d), (double)this.y, (double)this.z, metal);
            rb.func_78622_d((Block)block2, (double)this.x, (double)this.y, (double)((float)(this.z - 1) + 2.0f * d), metal);
            rb.func_78617_b((Block)block2, (double)this.x, (double)((float)this.y - height + 1.0f * d), (double)this.z, metal);
            rb.field_78677_m = origAO;
        } else {
            GL11.glDisable((int)2884);
            block2.renderForInventory(rb);
            GL11.glEnable((int)2884);
        }
    }

    protected void renderPart(RenderBlocks rb, Icon texture, float b1, float b2, float b3, float b4, float b5, float b6) {
        BlockFactorization block2 = Core.registry.factory_rendering_block;
        rb.func_83020_a((double)b1, (double)b2, (double)b3, (double)b4, (double)b5, (double)b6);
        block2.func_71905_a(b1, b2, b3, b4, b5, b6);
        if (this.world_mode) {
            BlockFactorization.force_texture = texture;
            rb.func_78570_q((Block)block2, this.x, this.y, this.z);
            BlockFactorization.force_texture = null;
        } else {
            this.renderPartInvTexture(rb, (Block)block2, texture);
        }
        rb.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        block2.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPartInvTexture(RenderBlocks renderblocks, Block block2, Icon texture) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block2.func_71919_f();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_78613_a(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_78617_b(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_78611_c(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_78622_d(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_78573_e(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_78605_f(block2, 0.0, 0.0, 0.0, texture);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private int getMixedBrightnessForBlock(IBlockAccess w, int x, int y, int z) {
        return w.func_72802_i(x, y, z, Block.field_71984_q[w.func_72798_a(x, y, z)]);
    }

    private int getAoBrightness(int a, int b, int c, int d) {
        return rb.func_78602_a(a, b, c, d);
    }

    private float getAmbientOcclusionLightValue(IBlockAccess w, int x, int y, int z) {
        return Block.field_71981_t.func_71888_h(w, x, y, z);
    }

    private static ForgeDirection getFaceDirection(VectorUV[] vecs, VectorUV center) {
        VectorUV here = vecs[0].add(vecs[2]);
        here.scale(0.5);
        here = here.add(center);
        double x = Math.abs(here.x);
        double y = Math.abs(here.y);
        double z = Math.abs(here.z);
        if (x >= y && x >= z) {
            return here.x >= 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST;
        }
        if (y >= x && y >= z) {
            return here.y >= 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
        }
        if (z >= x && z >= y) {
            return here.z >= 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return ForgeDirection.UP;
    }

    private static float getNormalizedLighting(VectorUV[] vecs, VectorUV center) {
        return directionLighting[FactorizationBlockRender.getFaceDirection(vecs, center).ordinal()];
    }

    private float interpolate(float a, float b, float scale) {
        return a * scale + b * (1.0f - scale);
    }

    private void calculateAO(ForgeDirection face, DeltaCoord corner, Coord here, int normalAxis) {
        int array_index = 1;
        for (int i = 0; i < 3; ++i) {
            if (i == normalAxis) {
                int px = here.x + corner.x;
                int py = here.y + corner.y;
                int pz = here.z + corner.z;
                int ai = 0;
                this.mixedBrightness[ai] = this.getMixedBrightnessForBlock((IBlockAccess)here.w, px, py, pz);
                this.aoLightValue[ai] = this.getAmbientOcclusionLightValue((IBlockAccess)here.w, px, py, pz);
                this.aoGrass[ai] = Block.field_71985_p[here.w.func_72798_a(px, py, pz)];
                continue;
            }
            int store = corner.get(i);
            corner.set(i, 0);
            int px = here.x + corner.x;
            int py = here.y + corner.y;
            int pz = here.z + corner.z;
            int ai = array_index++;
            this.mixedBrightness[ai] = this.getMixedBrightnessForBlock((IBlockAccess)here.w, px, py, pz);
            this.aoLightValue[ai] = this.getAmbientOcclusionLightValue((IBlockAccess)here.w, px, py, pz);
            this.aoGrass[ai] = Block.field_71985_p[here.w.func_72798_a(px, py, pz)];
            corner.set(i, store);
        }
        int here_mixed = Block.field_71981_t.func_71874_e((IBlockAccess)here.w, here.x + face.offsetX, here.y + face.offsetY, here.z + face.offsetZ);
        float hereAmbient = this.getAmbientOcclusionLightValue((IBlockAccess)here.w, here.x, here.y, here.z);
        if (!this.aoGrass[1] && !this.aoGrass[2]) {
            this.mixedBrightness[0] = here_mixed;
            this.aoLightValue[0] = hereAmbient;
            this.aoLightValue[0] = 1.0f;
        }
        this.vertexBrightnessResult = this.getAoBrightness(this.mixedBrightness[0], this.mixedBrightness[1], this.mixedBrightness[2], here_mixed);
        float color = this.aoLightValue[0] + this.aoLightValue[1] + this.aoLightValue[2] + hereAmbient;
        color /= 3.0f;
        color = Math.max(color, hereAmbient);
        this.vertexColorResult = color * this.faceColor;
    }

    protected void renderCube(WireRenderingCube rc) {
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78382_b();
            GL11.glDisable((int)2896);
        }
        float delta = 0.00390625f;
        double zfight = rc.corner.x * (double)delta;
        zfight *= rc.corner.y * (double)delta;
        zfight *= rc.corner.z * (double)delta;
        zfight = 1.0025f;
        for (int face = 0; face < 6; ++face) {
            VectorUV[] vecs = rc.faceVerts(face);
            float color = directionLighting[face];
            Tessellator.field_78398_a.func_78386_a(color, color, color);
            for (int i = 0; i < vecs.length; ++i) {
                VectorUV vec = vecs[i];
                this.vertex(rc, (float)(vec.x * zfight), (float)(vec.y * zfight), (float)(vec.z * zfight), (float)vec.u, (float)vec.v);
            }
        }
        if (!this.world_mode) {
            Tessellator.field_78398_a.func_78381_a();
            GL11.glEnable((int)2896);
        }
    }

    protected void vertex(WireRenderingCube rc, float x, float y, float z, float u, float v) {
        Icon wire = BlockIcons.wire;
        Tessellator.field_78398_a.func_78374_a((double)this.x + 0.5 + (double)(x / 16.0f), (double)this.y + 0.5 + (double)(y / 16.0f), (double)this.z + 0.5 + (double)(z / 16.0f), (double)wire.func_94214_a((double)u), (double)wire.func_94207_b((double)v));
    }

    public static void renderIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_98187_b("/gui/items.png");
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        GL11.glEnable((int)32826);
        float f6 = 1.5f;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94213_j(), (int)icon.func_94208_k(), (float)0.0625f);
    }

    public void renderMotor(RenderBlocks rb, float yoffset) {
        Icon metal = BlockIcons.motor_texture;
        float d = 0.25f;
        float yd = -d + 0.003f;
        this.renderPart(rb, metal, d, d + yd + yoffset, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
    }

    protected void renderRotatedHelper(BlockRenderHelper block2) {
        Tessellator tess = Tessellator.field_78398_a;
        if (this.world_mode) {
            block2.renderRotated(tess, this.x, this.y, this.z);
        } else {
            tess.func_78382_b();
            block2.renderRotated(tess, 0, 0, 0);
            tess.func_78381_a();
        }
    }

    protected void renderBlock(RenderBlocks rb, BlockRenderHelper block2) {
        if (this.world_mode) {
            block2.render(rb, this.x, this.y, this.z);
        } else {
            block2.renderForInventory(rb);
        }
    }

    static {
        rb = new RenderBlocks();
        directionLighting = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
        force_inv = true;
        allFaces = new int[]{0, 1, 2, 3, 4, 5};
    }
}

