/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.Coord;
import factorization.client.render.FactorizationBlockRender;
import factorization.common.BlockIcons;
import factorization.common.BlockRenderHelper;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityBattery;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderEngine;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BlockRenderBattery
extends FactorizationBlockRender {
    float item_fullness = 0.0f;

    @Override
    protected void render(RenderBlocks rb) {
        if (this.world_mode) {
            TileEntityBattery bat = (TileEntityBattery)new Coord((World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z).getTE(TileEntityBattery.class);
            if (bat == null) {
                return;
            }
            this.renderBatteryDisplay(rb, bat.getFullness());
            this.renderNormalBlock(rb, FactoryType.BATTERY.md);
        }
    }

    void renderInventoryMode(RenderBlocks rb, IItemRenderer.ItemRenderType type) {
        this.renderNormalBlock(rb, FactoryType.BATTERY.md);
        GL11.glPushMatrix();
        RenderEngine re = Minecraft.func_71410_x().field_71446_o;
        re.func_98187_b("/terrain.png");
        this.renderBatteryDisplay(rb, this.item_fullness);
        GL11.glPopMatrix();
    }

    void renderBatteryDisplay(RenderBlocks rb, float fullness) {
        fullness = Math.min(fullness, 1.0f);
        Tessellator tes = Tessellator.field_78398_a;
        float pixels = Math.round(fullness * 11.0f);
        if (pixels < 1.0f) {
            return;
        }
        float h = 0.0625f + pixels / 16.0f;
        float d = 0.0078125f;
        int brightness = this.world_mode ? Core.registry.factory_block.func_71874_e((IBlockAccess)this.getCoord().w, this.x, this.y, this.z) : 0xC000C0;
        tes.func_78380_c(brightness);
        float color = Math.min(1.0f, fullness * 0.8f + 0.2f);
        tes.func_78386_a(color, fullness, fullness);
        BlockRenderHelper block2 = BlockRenderHelper.instance;
        Icon meter = BlockIcons.battery_meter;
        block2.useTextures(null, null, meter, meter, meter, meter);
        block2.func_71905_a(-0.0078125f, 0.0f, -0.0078125f, 1.0078125f, h, 1.0078125f);
        if (this.world_mode) {
            block2.render(rb, this.x, this.y, this.z);
        } else {
            block2.renderForInventory(rb);
        }
    }

    @Override
    protected FactoryType getFactoryType() {
        return FactoryType.BATTERY;
    }
}

