/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.gui;

import factorization.api.Coord;
import factorization.common.Core;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class FactorizationNotify {
    static ArrayList messages = new ArrayList();

    public static void addMessage(Coord locus, String format, String ... args) {
        boolean long_lasting;
        if (format.equals("!clear")) {
            messages.clear();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String translated;
            args[i] = translated = StatCollector.func_74838_a((String)args[i]);
        }
        String msg = String.format(format, args);
        boolean force_position = msg.startsWith("\b");
        if (force_position) {
            msg = msg.substring(1);
        }
        if (long_lasting = msg.startsWith("\t")) {
            msg = msg.substring(1);
        }
        if (msg.length() == 0) {
            return;
        }
        if (Core.notify_in_chat) {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_71035_c(msg);
            }
            return;
        }
        if (messages.size() > 2 && !force_position) {
            messages.remove(0);
        }
        for (Message m : messages) {
            if (m.locus.equals(locus)) {
                m.set(locus, msg, long_lasting, force_position);
                return;
            }
            if (m.locus.distanceManhatten(locus) != 1 || force_position) continue;
            m.creationTime = 0L;
        }
        messages.add(new Message().set(locus, msg, long_lasting, force_position));
    }

    @ForgeSubscribe
    public void renderMessages(RenderWorldLastEvent event) {
        this.doRenderMessages(event);
    }

    void doRenderMessages(RenderWorldLastEvent event) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null) {
            return;
        }
        if (messages.size() == 0) {
            return;
        }
        Core.profileStart("factorizationNotify");
        Iterator it = messages.iterator();
        long deathTime = System.currentTimeMillis() - 6000L;
        EntityLiving camera = Minecraft.func_71410_x().field_71451_h;
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.partialTicks;
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.partialTicks;
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        GL11.glPushAttrib((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        while (it.hasNext()) {
            Message m = (Message)it.next();
            if (m.creationTime < deathTime || m.locus.w != w) {
                it.remove();
                continue;
            }
            if (m.orig_under != m.locus.getTE()) {
                it.remove();
                continue;
            }
            this.renderMessage(m);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        Core.profileEnd();
    }

    private void renderMessage(Message m) {
        int width = 0;
        int height = 0;
        String[] lines = m.msg.split("\n");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (String line : lines) {
            height += fr.field_78288_b + 2;
            width = Math.max(width, fr.func_78256_a(line));
        }
        width += 2;
        float scaling = 0.026666667f;
        scaling *= 0.6666667f;
        GL11.glPushMatrix();
        float y = m.locus.y;
        AxisAlignedBB bb = m.locus.getCollisionBoundingBoxFromPool();
        y = bb != null && !m.position_important ? (float)((double)y + (bb.field_72337_e - bb.field_72338_b)) : (y += 0.5f);
        GL11.glTranslatef((float)((float)m.locus.x + 0.5f), (float)y, (float)((float)m.locus.z + 0.5f));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scaling), (float)(-scaling), (float)scaling);
        GL11.glTranslatef((float)0.0f, (float)(-10 * lines.length), (float)0.0f);
        Tessellator tess = Tessellator.field_78398_a;
        int var16 = (lines.length - 1) * 10;
        GL11.glDisable((int)3553);
        tess.func_78382_b();
        int var17 = width / 2;
        tess.func_78369_a(0.0f, 0.0f, 0.0f, 0.5f);
        tess.func_78377_a((double)(-var17 - 1), -1.0, 0.0);
        tess.func_78377_a((double)(-var17 - 1), (double)(8 + var16), 0.0);
        tess.func_78377_a((double)(var17 + 1), (double)(8 + var16), 0.0);
        tess.func_78377_a((double)(var17 + 1), -1.0, 0.0);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        int i = 0;
        for (String line : lines) {
            fr.func_78276_b(line, -fr.func_78256_a(line) / 2, 10 * i, -1);
            ++i;
        }
        GL11.glPopMatrix();
    }

    static class Message {
        Coord locus;
        String msg;
        long creationTime;
        boolean position_important;
        TileEntity orig_under;

        Message() {
        }

        Message set(Coord locus, String msg, boolean long_lasting, boolean position_important) {
            this.creationTime = System.currentTimeMillis();
            if (long_lasting) {
                this.creationTime += 5000L;
            }
            this.locus = locus;
            this.msg = msg;
            this.position_important = position_important;
            this.orig_under = locus.getTE();
            return this;
        }
    }
}

