/*
 * Decompiled with CFR 0.152.
 */
package factorization.api.datahelpers;

import factorization.api.FzOrientation;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataHelper {
    protected String name;
    protected boolean valid;
    private static final Class[] validTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, NBTTagCompound.class};

    public DataHelper as(Share share, String set_name) {
        this.name = set_name;
        this.valid = this.shouldStore(share);
        return this;
    }

    public DataHelper asSameShare(String set_name) {
        this.name = set_name;
        return this;
    }

    protected abstract boolean shouldStore(Share var1);

    public abstract boolean isReader();

    public boolean isWriter() {
        return !this.isReader();
    }

    public NBTTagCompound getTag() {
        return null;
    }

    public boolean isNBT() {
        return false;
    }

    public final Object put(Object o) throws IOException {
        if (!this.valid) {
            return o;
        }
        if (o instanceof IDataSerializable) {
            return ((IDataSerializable)o).serialize(this.name, this);
        }
        if (o instanceof Enum) {
            Enum value = (Enum)o;
            int i = value.ordinal();
            i = (Integer)this.put(i);
            if (this.isWriter()) {
                return value;
            }
            return ((Enum[])value.getClass().getEnumConstants())[i];
        }
        if (o instanceof ItemStack) {
            ItemStack value = (ItemStack)o;
            NBTTagCompound writtenTag = value.func_77955_b(new NBTTagCompound());
            if (this.isReader()) {
                return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)this.put(writtenTag)));
            }
            this.put(writtenTag);
            return o;
        }
        return this.putImplementation(o);
    }

    protected abstract Object putImplementation(Object var1) throws IOException;

    public final boolean putBoolean(boolean value) throws IOException {
        return (Boolean)this.put(value);
    }

    public final byte putByte(byte value) throws IOException {
        return (Byte)this.put(value);
    }

    public final short putShort(short value) throws IOException {
        return (Short)this.put(value);
    }

    public final int putInt(int value) throws IOException {
        return (Integer)this.put(value);
    }

    public final long putLong(long value) throws IOException {
        return (Long)this.put(value);
    }

    public final float putFloat(float value) throws IOException {
        return ((Float)this.put(Float.valueOf(value))).floatValue();
    }

    public final double putDouble(double value) throws IOException {
        return (Double)this.put(value);
    }

    public final String putString(String value) throws IOException {
        return (String)this.put(value);
    }

    public final FzOrientation putFzOrientation(FzOrientation value) throws IOException {
        return (FzOrientation)((Object)this.put((Object)value));
    }

    public final ItemStack putItemStack(ItemStack value) throws IOException {
        return (ItemStack)this.put(value);
    }

    public final Enum putEnum(Enum value) throws IOException {
        return (Enum)this.put(value);
    }

    public final Object putUntypedOject(Object value) throws IOException {
        if (!this.valid) {
            return value;
        }
        String orig_name = this.name;
        if (this.isReader()) {
            int typeIndex = (Integer)this.asSameShare(orig_name + ".type").put(-1);
            this.asSameShare(orig_name);
            if (typeIndex < 0 || typeIndex > validTypes.length) {
                return value;
            }
            Class type = validTypes[typeIndex];
            if (value != null && value.getClass() == type) {
                return this.put(value);
            }
            if (type == Boolean.class) {
                value = false;
            } else if (type == Short.class) {
                value = (short)0;
            } else if (type == Integer.class) {
                value = 0;
            } else if (type == Long.class) {
                value = 0L;
            } else if (type == Float.class) {
                value = Float.valueOf(0.0f);
            } else if (type == Double.class) {
                value = 0.0;
            } else if (type == NBTTagCompound.class) {
                value = new NBTTagCompound();
            } else {
                return null;
            }
            return this.put(value);
        }
        Class<?> value_type = value.getClass();
        for (int i = 0; i < validTypes.length; ++i) {
            Class type = validTypes[i];
            if (value_type != type) continue;
            this.asSameShare(orig_name + ".type").put(i);
            this.asSameShare(orig_name);
            this.put(value);
            return value;
        }
        return value;
    }
}

