/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.FzOrientation;
import factorization.api.VectorUV;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class Quaternion
implements IDataSerializable {
    public double w;
    public double x;
    public double y;
    public double z;
    private static ThreadLocal localStaticArray = new ThreadLocal(){

        protected double[] initialValue() {
            return new double[4];
        }
    };
    private static Quaternion[] quat_cache = new Quaternion[FzOrientation.values().length];
    private static final double DOT_THRESHOLD = 0.9995;
    private static Vec3 uvCache = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Quaternion(Quaternion orig) {
        this.w = orig.w;
        this.x = orig.x;
        this.y = orig.y;
        this.z = orig.z;
    }

    public Quaternion(double[] init) {
        this(init[0], init[1], init[2], init[3]);
        assert (init.length == 4);
    }

    public Quaternion(double w, Vec3 v) {
        this(w, v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public Quaternion(double w, ForgeDirection dir) {
        this(w, dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public boolean isEqual(Quaternion other) {
        return this.w == other.w && this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public String toString() {
        return "Quaternion(" + this.w + ", " + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void writeToTag(NBTTagCompound tag, String prefix) {
        tag.func_74780_a(prefix + "w", this.w);
        tag.func_74780_a(prefix + "x", this.x);
        tag.func_74780_a(prefix + "y", this.y);
        tag.func_74780_a(prefix + "z", this.z);
    }

    public static Quaternion loadFromTag(NBTTagCompound tag, String prefix) {
        return new Quaternion(tag.func_74769_h(prefix + "w"), tag.func_74769_h(prefix + "x"), tag.func_74769_h(prefix + "y"), tag.func_74769_h(prefix + "z"));
    }

    public void write(ByteArrayDataOutput out) {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        double[] d = this.toStaticArray();
        for (int i = 0; i < d.length; ++i) {
            out.writeDouble(d[i]);
        }
    }

    public static Quaternion read(DataInput in) throws IOException {
        double[] d = (double[])localStaticArray.get();
        for (int i = 0; i < d.length; ++i) {
            d[i] = in.readDouble();
        }
        return new Quaternion(d);
    }

    @Override
    public IDataSerializable serialize(String name_prefix, DataHelper data) throws IOException {
        this.w = (Double)data.asSameShare(name_prefix + "w").put(this.w);
        this.x = (Double)data.asSameShare(name_prefix + "x").put(this.x);
        this.y = (Double)data.asSameShare(name_prefix + "y").put(this.y);
        this.z = (Double)data.asSameShare(name_prefix + "z").put(this.z);
        return this;
    }

    public double[] fillArray(double[] out) {
        out[0] = this.w;
        out[1] = this.x;
        out[2] = this.y;
        out[3] = this.z;
        return out;
    }

    public double[] toArray() {
        return this.fillArray(new double[4]);
    }

    public double[] toStaticArray() {
        return this.fillArray((double[])localStaticArray.get());
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public void update(double nw, double nx, double ny, double nz) {
        this.w = nw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public void update(Quaternion other) {
        this.update(other.w, other.x, other.y, other.z);
    }

    public void update(ForgeDirection dir) {
        this.update(this.w, dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public void updateVector(Vec3 v) {
        v.field_72450_a = this.x;
        v.field_72448_b = this.y;
        v.field_72449_c = this.z;
    }

    public Vec3 toVector() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public void incrNormalize() {
        double normSquared = this.magnitudeSquared();
        if (normSquared == 1.0 || normSquared == 0.0) {
            return;
        }
        double norm = Math.sqrt(normSquared);
        this.w /= norm;
        this.x /= norm;
        this.y /= norm;
        this.z /= norm;
    }

    public static Quaternion getRotationQuaternion(FzOrientation orient) {
        if (orient.top == ForgeDirection.UP) {
            // empty if block
        }
        return Quaternion.getRotationQuaternionRadians(Math.toRadians(orient.getRotation() * 90), orient.facing);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, Vec3 axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), axis.field_72450_a * sin, axis.field_72448_b * sin, axis.field_72449_c * sin);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, ForgeDirection axis) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), (double)axis.offsetX * sin, (double)axis.offsetY * sin, (double)axis.offsetZ * sin);
    }

    public static Quaternion getRotationQuaternionRadians(double angle, double ax, double ay, double az) {
        double halfAngle = angle / 2.0;
        double sin = Math.sin(halfAngle);
        return new Quaternion(Math.cos(halfAngle), ax * sin, ay * sin, az * sin);
    }

    public static Quaternion fromOrientation(FzOrientation orient) {
        Quaternion q1;
        int ord = orient.ordinal();
        if (quat_cache[ord] != null) {
            return quat_cache[ord];
        }
        if (orient == FzOrientation.UNKNOWN) {
            Quaternion.quat_cache[ord] = new Quaternion();
            return Quaternion.quat_cache[ord];
        }
        Vec3 target = orient.getDiagonalVector();
        double quart = Math.toRadians(90.0);
        int rotation = orient.getRotation();
        switch (orient.facing) {
            case UP: {
                q1 = Quaternion.getRotationQuaternionRadians(0.0 * quart, ForgeDirection.WEST);
                rotation = 5 - rotation;
                break;
            }
            case DOWN: {
                q1 = Quaternion.getRotationQuaternionRadians(2.0 * quart, ForgeDirection.WEST);
                rotation = 3 - rotation;
                break;
            }
            case NORTH: {
                q1 = Quaternion.getRotationQuaternionRadians(1.0 * quart, ForgeDirection.WEST);
                rotation = 5 - rotation;
                break;
            }
            case SOUTH: {
                q1 = Quaternion.getRotationQuaternionRadians(-1.0 * quart, ForgeDirection.WEST);
                rotation = 3 - rotation;
                break;
            }
            case EAST: {
                q1 = Quaternion.getRotationQuaternionRadians(1.0 * quart, ForgeDirection.NORTH);
                rotation += Math.abs(orient.top.offsetZ) * 2;
                break;
            }
            case WEST: {
                q1 = Quaternion.getRotationQuaternionRadians(-1.0 * quart, ForgeDirection.NORTH);
                rotation += Math.abs(orient.top.offsetY) * 2;
                break;
            }
            default: {
                Quaternion.quat_cache[ord] = new Quaternion();
                return Quaternion.quat_cache[ord];
            }
        }
        Quaternion q2 = Quaternion.getRotationQuaternionRadians((double)rotation * quart, orient.facing);
        q2.incrMultiply(q1);
        Quaternion.quat_cache[ord] = q2;
        return Quaternion.quat_cache[ord];
    }

    public double setVector(Vec3 axis) {
        double halfAngle = Math.acos(this.w);
        double sin = Math.sin(halfAngle);
        axis.field_72450_a = this.x / sin;
        axis.field_72448_b = this.y / sin;
        axis.field_72449_c = this.z / sin;
        return halfAngle * 2.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void glRotate() {
        double halfAngle = Math.acos(this.w);
        double sin = Math.sin(halfAngle);
        GL11.glRotatef((float)((float)Math.toDegrees(halfAngle * 2.0)), (float)((float)(this.x / sin)), (float)((float)(this.y / sin)), (float)((float)(this.z / sin)));
    }

    public double dotProduct(Quaternion other) {
        return this.w * other.w + this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public void incrLerp(Quaternion other, double t) {
        other.incrAdd(this, -1.0);
        other.incrScale(t);
        this.incrAdd(other);
        this.incrNormalize();
    }

    public Quaternion slerp(Quaternion other, double t) {
        double dot = this.dotProduct(other);
        if (dot > 0.9995) {
            Quaternion result = new Quaternion(this);
            Quaternion temp = other.add(this, -1.0);
            temp.incrScale(t);
            result.incrAdd(temp);
            result.incrNormalize();
            return result;
        }
        dot = Math.min(-1.0, Math.max(1.0, dot));
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * t;
        Quaternion v2 = other.add(this, -dot);
        v2.incrNormalize();
        Quaternion ret = this.scale(Math.cos(theta));
        v2.incrScale(Math.sin(theta));
        ret.incrAdd(v2);
        return ret;
    }

    public double magnitude() {
        return Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magnitudeSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double incrDistance(Quaternion other) {
        this.incrAdd(other);
        return this.magnitude();
    }

    public void incrConjugate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
    }

    public void incrAdd(Quaternion other) {
        this.w += other.w;
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public void incrAdd(Quaternion other, double scale) {
        this.w += other.w * scale;
        this.x += other.x * scale;
        this.y += other.y * scale;
        this.z += other.z * scale;
    }

    public void incrMultiply(Quaternion other) {
        double nw = this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z;
        double nx = this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y;
        double ny = this.w * other.y - this.x * other.z + this.y * other.w + this.z * other.x;
        double nz = this.w * other.z + this.x * other.y - this.y * other.x + this.z * other.w;
        this.update(nw, nx, ny, nz);
    }

    public void incrScale(double scaler) {
        this.w *= scaler;
        this.x *= scaler;
        this.y *= scaler;
        this.z *= scaler;
    }

    public void incrUnit() {
        this.incrScale(1.0 / this.magnitude());
    }

    public void incrReciprocal() {
        double m = this.magnitude();
        this.incrConjugate();
        this.incrScale(1.0 / (m * m));
    }

    public void applyRotation(Vec3 p) {
        Quaternion point = new Quaternion(0.0, p);
        Quaternion trans = this.multiply(point).multiply(this.conjugate());
        p.field_72450_a = trans.x;
        p.field_72448_b = trans.y;
        p.field_72449_c = trans.z;
    }

    public void applyRotation(VectorUV vec) {
        Quaternion.uvCache.field_72450_a = vec.x;
        Quaternion.uvCache.field_72448_b = vec.y;
        Quaternion.uvCache.field_72449_c = vec.z;
        this.applyRotation(uvCache);
        vec.x = Quaternion.uvCache.field_72450_a;
        vec.y = Quaternion.uvCache.field_72448_b;
        vec.z = Quaternion.uvCache.field_72449_c;
    }

    public double distance(Quaternion other) {
        return this.add(other).magnitude();
    }

    public Quaternion conjugate() {
        Quaternion ret = new Quaternion(this);
        ret.incrConjugate();
        return ret;
    }

    public Quaternion add(Quaternion other) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other);
        return ret;
    }

    public Quaternion add(Quaternion other, double scale) {
        Quaternion ret = new Quaternion(this);
        ret.incrAdd(other, scale);
        return ret;
    }

    public Quaternion multiply(Quaternion other) {
        Quaternion a = new Quaternion(this);
        a.incrMultiply(other);
        return a;
    }

    public Quaternion scale(double scaler) {
        Quaternion a = new Quaternion(this);
        a.incrScale(scaler);
        return a;
    }

    public Quaternion unit() {
        Quaternion r = new Quaternion(this);
        r.incrUnit();
        return r;
    }

    public Quaternion reciprocal() {
        Quaternion r = new Quaternion(this);
        r.incrReciprocal();
        return r;
    }
}

