/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import cpw.mods.fml.common.Loader;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.netherores.NetherOresCore;
import thermalexpansion.api.crafting.CraftingManagers;
import thermalexpansion.api.item.ItemRegistry;

public enum Ores {
    coal("Coal", 8, 16, 2, 4),
    diamond("Diamond", 4, 3, 2, 4),
    gold("Gold", 8, 6, 2, 4),
    iron("Iron", 8, 8, 2, 4),
    lapis("Lapis", 6, 6, 2, 24),
    redstone("Redstone", 6, 8, 2, 24),
    copper("Copper", 8, 8, 2, 4),
    tin("Tin", 8, 8, 2, 4),
    emerald("Emerald", 3, 2, 2, 4),
    silver("Silver", 6, 4, 2, 4),
    lead("Lead", 6, 6, 2, 4),
    uranium("Uranium", 3, 2, 2, 4),
    nikolite("Nikolite", 8, 4, 2, 24),
    ruby("Ruby", 6, 3, 2, 4),
    greensapphire("GreenSapphire", 6, 3, 2, 4),
    sapphire("Sapphire", 6, 3, 2, 4),
    platinum("Platinum", 3, 3, 2, 4),
    nickel("Nickel", 4, 6, 2, 4),
    pigiron("Steel", 3, 4, 2, 4),
    iridium("Iridium", 1, 2, 2, 4),
    osmium("Osmium", 8, 7, 2, 4);

    private int _blockIndex;
    private int _metadata;
    private String _oreName;
    private String _netherOreName;
    private String _dustName;
    private boolean _registeredSmelting;
    private boolean _registeredMacerator;
    private int _oreGenMinY = 1;
    private int _oreGenMaxY = 126;
    private int _oreGenGroupsPerChunk = 6;
    private int _oreGenBlocksPerGroup = 14;
    private boolean _oreGenDisable = false;
    private int _smeltCount;
    private int _maceCount;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Ores(int oreSuffix, int groupsPerChunk, int blocksPerGroup) {
        void maceCount;
        void smeltCount;
        int meta = this.ordinal();
        this._blockIndex = meta / 16;
        this._metadata = meta % 16;
        this._oreName = "ore" + (String)oreSuffix;
        this._dustName = "dust" + (String)oreSuffix;
        this._netherOreName = "oreNether" + (String)oreSuffix;
        this._oreGenGroupsPerChunk = groupsPerChunk;
        this._oreGenBlocksPerGroup = blocksPerGroup;
        this._smeltCount = smeltCount;
        this._maceCount = maceCount;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public int getMetadata() {
        return this._metadata;
    }

    public String getOreName() {
        return this._oreName;
    }

    public String getDustName() {
        return this._dustName;
    }

    public boolean isRegisteredSmelting() {
        return this._registeredSmelting;
    }

    public boolean isRegisteredMacerator() {
        return this._registeredMacerator;
    }

    public int getMaxY() {
        return this._oreGenMaxY;
    }

    public int getMinY() {
        return this._oreGenMinY;
    }

    public int getGroupsPerChunk() {
        return this._oreGenGroupsPerChunk;
    }

    public int getBlocksPerGroup() {
        return this._oreGenBlocksPerGroup;
    }

    public boolean getDisabled() {
        return this._oreGenDisable;
    }

    public void load() {
        MinecraftForge.setBlockHarvestLevel((Block)NetherOresCore.getOreBlock(this._blockIndex), (int)this._metadata, (String)"pickaxe", (int)2);
        ItemStack oreStack = new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata);
        OreDictionary.registerOre((String)this._netherOreName, (ItemStack)oreStack);
    }

    public void registerSmelting(ItemStack smeltStack) {
        this._registeredSmelting = true;
        if (NetherOresCore.enableStandardFurnaceRecipes.getBoolean(true)) {
            ItemStack smeltTo = smeltStack.func_77946_l();
            smeltTo.field_77994_a = this._smeltCount;
            FurnaceRecipes.func_77602_a().addSmelting(NetherOresCore.getOreBlock((int)this._blockIndex).field_71990_ca, this._metadata, smeltTo, 1.0f);
        }
        if (NetherOresCore.enableInductionSmelterRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
            ItemStack smeltToReg = smeltStack.func_77946_l();
            ItemStack smeltToRich = smeltStack.func_77946_l();
            ++smeltToReg.field_77994_a;
            smeltToRich.field_77994_a += 2;
            CraftingManagers.smelterManager.addRecipe(320, new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), new ItemStack(Block.field_71939_E), smeltToReg, ItemRegistry.getItem((String)"slagRich", (int)1), 10, false);
            CraftingManagers.smelterManager.addRecipe(400, new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), ItemRegistry.getItem((String)"slagRich", (int)1), smeltToRich, ItemRegistry.getItem((String)"slag", (int)1), 80, false);
        }
    }

    public void registerMacerator(ItemStack maceStack) {
        this._registeredMacerator = true;
        if (NetherOresCore.enableMaceratorRecipes.getBoolean(true) && Loader.isModLoaded((String)"IC2")) {
            ItemStack maceTo = maceStack.func_77946_l();
            maceTo.field_77994_a = this._maceCount;
            Recipes.macerator.addRecipe(new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), (Object)maceTo.func_77946_l());
        }
        if (NetherOresCore.enablePulverizerRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
            ItemStack pulvPriTo = maceStack.func_77946_l();
            ItemStack pulvSecTo = new ItemStack(Block.field_72012_bb);
            pulvPriTo.field_77994_a = this._maceCount;
            pulvSecTo.field_77994_a = 1;
            CraftingManagers.pulverizerManager.addRecipe(400, new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), pulvPriTo, pulvSecTo, 15, false);
        }
    }

    public void loadConfig(Configuration c) {
        this._oreGenMaxY = c.get("WorldGen", this._oreName + "MaxY", this._oreGenMaxY).getInt();
        this._oreGenMinY = c.get("WorldGen", this._oreName + "MinY", this._oreGenMinY).getInt();
        this._oreGenGroupsPerChunk = c.get("WorldGen", this._oreName + "GroupsPerChunk", this._oreGenGroupsPerChunk).getInt();
        this._oreGenBlocksPerGroup = c.get("WorldGen", this._oreName + "BlocksPerGroup", this._oreGenBlocksPerGroup).getInt();
        this._oreGenDisable = c.get("WorldGen", this._oreName + "Disable", false).getBoolean(false);
        if (this._oreGenMinY >= this._oreGenMaxY) {
            this._oreGenMinY = this._oreGenMaxY - 1;
        }
    }
}

