/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.mod.BaseMod;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.entity.EntityHellfish;
import powercrystals.netherores.net.ClientPacketHandler;
import powercrystals.netherores.net.ConnectionHandler;
import powercrystals.netherores.net.INetherOresProxy;
import powercrystals.netherores.net.ServerPacketHandler;
import powercrystals.netherores.ores.BlockNetherOres;
import powercrystals.netherores.ores.ItemBlockNetherOre;
import powercrystals.netherores.ores.Ores;
import powercrystals.netherores.world.BlockHellfish;
import powercrystals.netherores.world.NetherOresWorldGenHandler;

@Mod(modid="NetherOres", name="Nether Ores", version="1.5.1R2.1.5", dependencies="required-after:PowerCrystalsCore;after:IC2;after:ThermalExpansion")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ServerPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class NetherOresCore
extends BaseMod {
    public static final String modId = "NetherOres";
    public static final String version = "1.5.1R2.1.5";
    public static final String modName = "Nether Ores";
    public static final String mobTexureFolder = "/textures/mob/powercrystals/netherores/";
    public static Block[] blockNetherOres = new Block[(Ores.values().length + 15) / 16];
    public static Block blockHellfish;
    private static Property[] netherOreBlockIds;
    private static Property hellfishBlockId;
    public static Property explosionPower;
    public static Property explosionProbability;
    public static Property enableExplosions;
    public static Property enableExplosionChainReactions;
    public static Property enableAngryPigmen;
    public static Property enableHellfish;
    public static Property enableStandardFurnaceRecipes;
    public static Property enableMaceratorRecipes;
    public static Property enablePulverizerRecipes;
    public static Property enableInductionSmelterRecipes;
    public static Property forceOreSpawn;
    public static Property worldGenAllDimensions;
    @SidedProxy(clientSide="powercrystals.netherores.net.ClientProxy", serverSide="powercrystals.netherores.net.ServerProxy")
    public static INetherOresProxy proxy;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        this.setConfigFolderBase(evt.getModConfigurationDirectory());
        this.loadConfig(this.getCommonConfig());
        this.extractLang(new String[]{"en_US", "es_AR", "es_ES", "es_MX", "es_UY", "es_VE", "de_DE", "ru_RU"});
        this.loadLang();
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        int e = blockNetherOres.length;
        for (int i = 0; i < e; ++i) {
            NetherOresCore.blockNetherOres[i] = new BlockNetherOres(netherOreBlockIds[i].getInt(), i);
            BlockNetherOres b = NetherOresCore.blockNetherOres[i];
            GameRegistry.registerBlock((Block)b, ItemBlockNetherOre.class, (String)b.func_71917_a());
        }
        blockHellfish = new BlockHellfish(hellfishBlockId.getInt());
        GameRegistry.registerBlock((Block)blockHellfish, (String)"netherOresBlockHellfish");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherOresWorldGenHandler());
        for (Ores o : Ores.values()) {
            o.load();
        }
        EntityRegistry.registerModEntity(EntityArmedOre.class, (String)"netherOresArmedOre", (int)0, (Object)((Object)this), (int)160, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityHellfish.class, (String)"netherOresHellfish", (int)1, (Object)((Object)this), (int)160, (int)5, (boolean)true);
        proxy.load();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager((IUpdateableMod)this), (Side)Side.CLIENT);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent e) {
        if (enableStandardFurnaceRecipes.getBoolean(true) || enableInductionSmelterRecipes.getBoolean(true)) {
            Ores.coal.registerSmelting(new ItemStack(Block.field_71950_I));
            Ores.diamond.registerSmelting(new ItemStack(Block.field_72073_aw));
            Ores.gold.registerSmelting(new ItemStack(Block.field_71941_G));
            Ores.iron.registerSmelting(new ItemStack(Block.field_71949_H));
            Ores.lapis.registerSmelting(new ItemStack(Block.field_71947_N));
            Ores.redstone.registerSmelting(new ItemStack(Block.field_72047_aN));
            Ores.emerald.registerSmelting(new ItemStack(Block.field_72068_bR));
        }
        if (enableMaceratorRecipes.getBoolean(true) || enablePulverizerRecipes.getBoolean(true)) {
            Ores.diamond.registerMacerator(new ItemStack(Item.field_77702_n));
            Ores.coal.registerMacerator(new ItemStack(Item.field_77705_m));
            Ores.redstone.registerMacerator(new ItemStack(Item.field_77767_aC));
            Ores.lapis.registerMacerator(new ItemStack(Item.field_77756_aW, 1, 4));
        }
        try {
            Method laserOre = Class.forName("powercrystals.minefactoryreloaded.MFRRegistry").getMethod("registerLaserOre", Integer.TYPE, ItemStack.class);
            Ores ore = Ores.coal;
            laserOre.invoke(null, 88, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.iron;
            laserOre.invoke(null, 75, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.gold;
            laserOre.invoke(null, 60, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.redstone;
            laserOre.invoke(null, 50, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.lapis;
            laserOre.invoke(null, 40, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.diamond;
            laserOre.invoke(null, 25, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
            ore = Ores.emerald;
            laserOre.invoke(null, 25, new ItemStack(NetherOresCore.getOreBlock(ore.getBlockIndex()), 1, ore.getMetadata()));
        }
        catch (Throwable _) {
            // empty catch block
        }
        for (String oreName : OreDictionary.getOreNames()) {
            if (OreDictionary.getOres((String)oreName).size() <= 0) continue;
            this.registerOreDictionaryEntry(oreName, (ItemStack)OreDictionary.getOres((String)oreName).get(0));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Block getOreBlock(int index) {
        if (index >= 0 && index < blockNetherOres.length) {
            return blockNetherOres[index];
        }
        return null;
    }

    private void registerOreDictionaryEntry(String oreName, ItemStack stack) {
        for (Ores ore : Ores.values()) {
            if (!ore.isRegisteredSmelting() && ore.getOreName().trim().toLowerCase().equals(oreName.trim().toLowerCase())) {
                ore.registerSmelting(stack);
            }
            if (ore.isRegisteredMacerator() || !ore.getDustName().trim().toLowerCase().equals(oreName.trim().toLowerCase())) continue;
            ore.registerMacerator(stack);
        }
    }

    private void loadConfig(File f) {
        int baseID;
        Configuration c = new Configuration(f);
        c.load();
        int curID = baseID = 1440;
        NetherOresCore.netherOreBlockIds[0] = c.getBlock("block", "ID.NetherOreBlock", curID++);
        hellfishBlockId = c.getBlock("block", "ID.HellfishBlock", curID++);
        for (int i = 1; i < netherOreBlockIds.length; ++i) {
            NetherOresCore.netherOreBlockIds[i] = c.getBlock("block", "ID.NetherOreBlock" + i, curID++);
        }
        explosionPower = c.get("general", "ExplosionPower", 2);
        NetherOresCore.explosionPower.comment = "How powerful an explosion will be. Creepers are 3, TNT is 4, electrified creepers are 6. This affects both the ability of the explosion to punch through blocks as well as the blast radius.";
        explosionProbability = c.get("general", "ExplosionProbability", 75);
        NetherOresCore.explosionProbability.comment = "The likelyhood an adjacent netherore will turn into an armed ore when one is mined. Percent chance out of 1000 (lower is less likely).";
        enableExplosions = c.get("general", "ExplosionEnable", true);
        NetherOresCore.enableExplosions.comment = "NetherOres have a chance to explode when mined if true.";
        enableExplosionChainReactions = c.get("general", "ExplosionChainReactEnable", true);
        NetherOresCore.enableExplosionChainReactions.comment = "NetherOre explosions can trigger more explosions if true. Does nothing if ExplosionEnable is false.";
        enableAngryPigmen = c.get("general", "AngryPigmenEnable", true);
        NetherOresCore.enableAngryPigmen.comment = "If true, when NetherOres are mined, nearby pigmen become angry to the player.";
        enableStandardFurnaceRecipes = c.get("general", "EnableStandardFurnaceRecipes", true);
        NetherOresCore.enableStandardFurnaceRecipes.comment = "Set this to false to remove the standard furnace recipes (ie, nether iron ore -> normal iron ore).";
        enableMaceratorRecipes = c.get("general", "EnableMaceratorRecipes", true);
        NetherOresCore.enableMaceratorRecipes.comment = "Set this to false to remove the IC2 Macerator recipes (ie, nether iron ore -> 4x iron dust).";
        enablePulverizerRecipes = c.get("general", "EnablePulverizerRecipes", true);
        NetherOresCore.enablePulverizerRecipes.comment = "Set this to false to remove the TE Pulvierzer recipes (ie, nether iron ore -> 4x iron dust).";
        enableInductionSmelterRecipes = c.get("general", "EnableInductionSmelterRecipes", true);
        NetherOresCore.enableInductionSmelterRecipes.comment = "Set this to false to remove the TE Induction Smelter recipes (ie, nether iron ore -> 2x normal iron ore).";
        forceOreSpawn = c.get("general", "ForceOreSpawn", false);
        NetherOresCore.forceOreSpawn.comment = "If true, will spawn nether ores regardless of if a furnace or macerator recipe was found. If false, at least one of those two must be found to spawn the ore.";
        enableHellfish = c.get("general", "HellfishEnable", true);
        NetherOresCore.enableHellfish.comment = "If true, Hellfish will spawn in the Nether. Note that setting this false will not kill active Hellfish mobs.";
        worldGenAllDimensions = c.get("general", "AllDimensionWorldGen", false);
        NetherOresCore.worldGenAllDimensions.comment = "If true, Nether Ores oregen will run in all dimensions instead of just the Nether. It will still require netherrack to place ores.";
        for (Ores o : Ores.values()) {
            o.loadConfig(c);
        }
        c.save();
    }

    @ForgeSubscribe
    public void registerOreEvent(OreDictionary.OreRegisterEvent event) {
        this.registerOreDictionaryEntry(event.Name, event.Ore);
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        netherOreBlockIds = new Property[blockNetherOres.length];
    }
}

