/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

public interface ILanguageAdapter {
    public Object getNewInstance(FMLModContainer var1, Class<?> var2, ClassLoader var3) throws Exception;

    public boolean supportsStatics();

    public void setProxy(Field var1, Class<?> var2, Object var3) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException;

    public void setInternalProxies(ModContainer var1, Side var2, ClassLoader var3);

    public static class JavaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> objectClass, ClassLoader classLoader) throws Exception {
            return objectClass.newInstance();
        }

        @Override
        public boolean supportsStatics() {
            return true;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            target.set(null, proxy);
        }

        @Override
        public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
        }
    }

    public static class ScalaAdapter
    implements ILanguageAdapter {
        @Override
        public Object getNewInstance(FMLModContainer container, Class<?> scalaObjectClass, ClassLoader classLoader) throws Exception {
            Class<?> sObjectClass = Class.forName(scalaObjectClass.getName() + "$", true, classLoader);
            return sObjectClass.getField("MODULE$").get(null);
        }

        @Override
        public boolean supportsStatics() {
            return false;
        }

        @Override
        public void setProxy(Field target, Class<?> proxyTarget, Object proxy) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
            try {
                if (!proxyTarget.getName().endsWith("$")) {
                    proxyTarget = Class.forName(proxyTarget.getName() + "$", true, proxyTarget.getClassLoader());
                }
            }
            catch (ClassNotFoundException e2) {
                FMLLog.log(Level.INFO, e2, "An error occured trying to load a proxy into %s.%s. Did you declare your mod as 'class' instead of 'object'?", proxyTarget.getSimpleName(), target.getName());
                return;
            }
            Object targetInstance = proxyTarget.getField("MODULE$").get(null);
            try {
                String setterName = target.getName() + "_$eq";
                for (Method setter : proxyTarget.getMethods()) {
                    Class<?>[] setterParameters = setter.getParameterTypes();
                    if (!setterName.equals(setter.getName()) || setterParameters.length != 1 || !setterParameters[0].isAssignableFrom(proxy.getClass())) continue;
                    setter.invoke(targetInstance, proxy);
                    return;
                }
            }
            catch (InvocationTargetException e3) {
                FMLLog.log(Level.SEVERE, e3, "An error occured trying to load a proxy into %s.%s", proxyTarget.getSimpleName(), target.getName());
                throw new LoaderException(e3);
            }
            FMLLog.severe("Failed loading proxy into %s.%s, could not find setter function. Did you declare the field with 'val' instead of 'var'?", proxyTarget.getSimpleName(), target.getName());
            throw new LoaderException();
        }

        @Override
        public void setInternalProxies(ModContainer mod, Side side, ClassLoader loader) {
            Class<?> proxyTarget = mod.getMod().getClass();
            if (proxyTarget.getName().endsWith("$")) {
                for (Field target : proxyTarget.getDeclaredFields()) {
                    if (target.getAnnotation(SidedProxy.class) == null) continue;
                    String targetType = side.isClient() ? target.getAnnotation(SidedProxy.class).clientSide() : target.getAnnotation(SidedProxy.class).serverSide();
                    try {
                        Object proxy = Class.forName(targetType, true, loader).newInstance();
                        if (!target.getType().isAssignableFrom(proxy.getClass())) {
                            FMLLog.severe("Attempted to load a proxy type %s into %s.%s, but the types don't match", targetType, proxyTarget.getSimpleName(), target.getName());
                            throw new LoaderException();
                        }
                        this.setProxy(target, proxyTarget, proxy);
                    }
                    catch (Exception e2) {
                        FMLLog.log(Level.SEVERE, e2, "An error occured trying to load a proxy into %s.%s", proxyTarget.getSimpleName(), target.getName());
                        throw new LoaderException(e2);
                    }
                }
            } else {
                FMLLog.finer("Mod does not appear to be a singleton.", new Object[0]);
            }
        }
    }
}

