/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class TextureAnimations {
    private static TextureAnimation[] textureAnimations = null;
    private static bge renderEngine = null;

    public static void reset() {
        textureAnimations = null;
    }

    public static void update(bge re2) {
        renderEngine = re2;
        bjt tp2 = re2.g.e();
        textureAnimations = TextureAnimations.getTextureAnimations(tp2);
        TextureAnimations.updateAnimations();
    }

    public static void updateCustomAnimations() {
        if (textureAnimations == null) {
            return;
        }
        if (!Config.isAnimatedTextures()) {
            return;
        }
        TextureAnimations.updateAnimations();
    }

    public static void updateAnimations() {
        if (textureAnimations == null) {
            return;
        }
        for (int i2 = 0; i2 < textureAnimations.length; ++i2) {
            TextureAnimation anim = textureAnimations[i2];
            anim.updateTexture();
        }
    }

    public static TextureAnimation[] getTextureAnimations(bjt tpb) {
        if (!(tpb instanceof bjp)) {
            return null;
        }
        bjp tpi = (bjp)tpb;
        File tpFile = tpi.a;
        if (tpFile == null) {
            return null;
        }
        if (!tpFile.exists()) {
            return null;
        }
        String[] animPropNames = null;
        animPropNames = tpFile.isFile() ? TextureAnimations.getAnimationPropertiesZip(tpFile) : TextureAnimations.getAnimationPropertiesDir(tpFile);
        if (animPropNames == null) {
            return null;
        }
        ArrayList<TextureAnimation> list = new ArrayList<TextureAnimation>();
        for (int i2 = 0; i2 < animPropNames.length; ++i2) {
            String propName = animPropNames[i2];
            Config.dbg("Texture animation: " + propName);
            try {
                InputStream in = tpi.a(propName);
                Properties props = new Properties();
                props.load(in);
                TextureAnimation anim = TextureAnimations.makeTextureAnimation(props);
                if (anim == null) continue;
                list.add(anim);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.dbg("File not found: " + e2.getMessage());
                continue;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        TextureAnimation[] anims = list.toArray(new TextureAnimation[list.size()]);
        return anims;
    }

    public static TextureAnimation makeTextureAnimation(Properties props) {
        String texFrom = props.getProperty("from");
        String texTo = props.getProperty("to");
        int x2 = Config.parseInt(props.getProperty("x"), -1);
        int y2 = Config.parseInt(props.getProperty("y"), -1);
        int width = Config.parseInt(props.getProperty("w"), -1);
        int height = Config.parseInt(props.getProperty("h"), -1);
        if (texFrom == null || texTo == null) {
            Config.dbg("TextureAnimation: Source or target texture not specified");
            return null;
        }
        if (x2 < 0 || y2 < 0 || width < 0 || height < 0) {
            Config.dbg("TextureAnimation: Invalid coordinates");
            return null;
        }
        byte[] imageBytes = TextureAnimations.getCustomTextureData(texFrom, width);
        if (imageBytes == null) {
            Config.dbg("TextureAnimation: Source texture not found: " + texTo);
            return null;
        }
        if (!renderEngine.getTexturePack().e().b(texTo, true)) {
            Config.dbg("TextureAnimation: Target texture not found: " + texTo);
            return null;
        }
        int destTexId = renderEngine.f(texTo);
        if (destTexId < 0) {
            Config.dbg("TextureAnimation: Target texture not found: " + texTo);
            return null;
        }
        TextureAnimation anim = new TextureAnimation(texFrom, imageBytes, texTo, destTexId, x2, y2, width, height, props, 1);
        return anim;
    }

    public static String[] getAnimationPropertiesDir(File tpDir) {
        File dirAnim = new File(tpDir, "anim");
        if (!dirAnim.exists()) {
            return null;
        }
        if (!dirAnim.isDirectory()) {
            return null;
        }
        File[] propFiles = dirAnim.listFiles();
        if (propFiles == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < propFiles.length; ++i2) {
            File file = propFiles[i2];
            String name = file.getName();
            if (name.startsWith("custom_") || !name.endsWith(".properties") || !file.isFile() || !file.canRead()) continue;
            Config.dbg("TextureAnimation: anim/" + file.getName());
            list.add("/anim/" + name);
        }
        String[] props = list.toArray(new String[list.size()]);
        return props;
    }

    public static String[] getAnimationPropertiesZip(File tpFile) {
        try {
            ZipFile zf2 = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en2 = zf2.entries();
            ArrayList<String> list = new ArrayList<String>();
            while (en2.hasMoreElements()) {
                ZipEntry ze2 = en2.nextElement();
                String name = ze2.getName();
                if (!name.startsWith("anim/") || name.startsWith("anim/custom_") || !name.endsWith(".properties")) continue;
                list.add("/" + name);
            }
            String[] props = list.toArray(new String[list.size()]);
            return props;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static byte[] getCustomTextureData(String imagePath, int tileWidth) {
        byte[] imageBytes = TextureAnimations.loadImage(imagePath, tileWidth);
        if (imageBytes == null) {
            imageBytes = TextureAnimations.loadImage("/anim" + imagePath, tileWidth);
        }
        return imageBytes;
    }

    private static byte[] loadImage(String name, int targetWidth) {
        bjt tp2 = renderEngine.getTexturePack().e();
        avy options = Config.getGameSettings();
        try {
            bjt texturePackBase = tp2;
            if (texturePackBase == null) {
                return null;
            }
            InputStream in = texturePackBase.a(name);
            if (in == null) {
                return null;
            }
            BufferedImage image = TextureAnimations.readTextureImage(in);
            if (image == null) {
                return null;
            }
            if (targetWidth > 0 && image.getWidth() != targetWidth) {
                double aspectHW = image.getHeight() / image.getWidth();
                int targetHeight = (int)((double)targetWidth * aspectHW);
                image = TextureAnimations.scaleBufferedImage(image, targetWidth, targetHeight);
            }
            int width = image.getWidth();
            int height = image.getHeight();
            int[] ai2 = new int[width * height];
            byte[] byteBuf = new byte[width * height * 4];
            image.getRGB(0, 0, width, height, ai2, 0, width);
            for (int l2 = 0; l2 < ai2.length; ++l2) {
                int alpha = ai2[l2] >> 24 & 0xFF;
                int red = ai2[l2] >> 16 & 0xFF;
                int green = ai2[l2] >> 8 & 0xFF;
                int blue = ai2[l2] & 0xFF;
                if (options != null && options.g) {
                    int j3 = (red * 30 + green * 59 + blue * 11) / 100;
                    int l3 = (red * 30 + green * 70) / 100;
                    int j4 = (red * 30 + blue * 70) / 100;
                    red = j3;
                    green = l3;
                    blue = j4;
                }
                byteBuf[l2 * 4 + 0] = (byte)red;
                byteBuf[l2 * 4 + 1] = (byte)green;
                byteBuf[l2 * 4 + 2] = (byte)blue;
                byteBuf[l2 * 4 + 3] = (byte)alpha;
            }
            return byteBuf;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return null;
        }
    }

    private static BufferedImage readTextureImage(InputStream par1InputStream) throws IOException {
        BufferedImage var2 = ImageIO.read(par1InputStream);
        par1InputStream.close();
        return var2;
    }

    public static BufferedImage scaleBufferedImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D gr2 = scaledImage.createGraphics();
        gr2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gr2.drawImage(image, 0, 0, width, height, null);
        return scaledImage;
    }
}

