/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forge;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.neiplugins.common.Utils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidDictionaryList
extends LiquidTemplateRecipeHandler {
    static Rectangle liquidTank = new Rectangle(22, 8, 48, 47);

    public String getRecipeName() {
        return "Liquid Registry";
    }

    @Override
    public String getRecipeId() {
        return "forge.liquiddictionary";
    }

    public String getGuiTexture() {
        return "/mods/neiplugins/gfx/LiquidDictionaryList.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTextCentered(((CachedLiquidDictionaryEntry)this.arecipes.get((int)recipe)).name, 85, 9, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    protected ArrayList getAllRecipes() {
        ArrayList<CachedLiquidDictionaryEntry> result = new ArrayList<CachedLiquidDictionaryEntry>();
        HashMap<List<Integer>, CachedLiquidDictionaryEntry> liquids = new HashMap<List<Integer>, CachedLiquidDictionaryEntry>();
        for (LiquidContainerData data : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (liquids.containsKey(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta))) continue;
            CachedLiquidDictionaryEntry entry = new CachedLiquidDictionaryEntry(data.stillLiquid);
            liquids.put(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta), entry);
            result.add(entry);
        }
        Map definedLiquids = LiquidDictionary.getLiquids();
        if (definedLiquids != null) {
            String[] names;
            for (String name : names = definedLiquids.keySet().toArray(new String[0])) {
                LiquidStack liquid = (LiquidStack)definedLiquids.get(name);
                CachedLiquidDictionaryEntry entry = (CachedLiquidDictionaryEntry)liquids.get(Arrays.asList(liquid.itemID, liquid.itemMeta));
                if (entry == null) {
                    entry = new CachedLiquidDictionaryEntry(liquid);
                    liquids.put(Arrays.asList(liquid.itemID, liquid.itemMeta), entry);
                    result.add(entry);
                }
                entry.tank.dictionaryNames.add(name);
            }
        }
        return result;
    }

    @Override
    public void loadUsageRecipes(LiquidStack ingredient) {
        for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
            if (!recipe.sameLiquid(ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null) {
            for (CachedLiquidDictionaryEntry recipe : this.getAllRecipes()) {
                if (!recipe.sameLiquid(t)) continue;
                this.arecipes.add(recipe);
            }
        }
    }

    public class LiquidDictionaryTank
    extends LiquidTank {
        public List dictionaryNames;

        public LiquidDictionaryTank(LiquidStack liquid, int capacity, Rectangle position) {
            super(liquid, capacity, position);
            this.dictionaryNames = new ArrayList();
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            if (Utils.getBooleanSetting("mistaqur.showLiquidDictionaryNames") && this.dictionaryNames.size() > 0) {
                currenttip.add("\u00a77Liquid dictionary names:");
                for (String name : this.dictionaryNames) {
                    currenttip.add("\u00a73" + name);
                }
            }
            if (Utils.getBooleanSetting("mistaqur.showLiquidDictionaryFuelTooltip")) {
                ArrayList fuelTooltip = new ArrayList();
                FuelTooltip.addLiquidStackFuelTooltip(currenttip, this.liquid, FuelTooltip.disabledHelpers);
                if (fuelTooltip != null && fuelTooltip.size() > 0) {
                    currenttip.add("\u00a77Can produce (per bucket):");
                    currenttip.addAll(fuelTooltip);
                }
            }
            return currenttip;
        }
    }

    public class CachedLiquidDictionaryEntry
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        LiquidDictionaryTank tank;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        String name;

        public CachedLiquidDictionaryEntry(LiquidStack liquid) {
            super((TemplateRecipeHandler)LiquidDictionaryList.this);
            this.name = this.name;
            this.tank = new LiquidDictionaryTank(liquid.copy(), 1000, liquidTank);
            this.tank.liquid.amount = 1000;
            this.tank.showAmount = false;
            this.tank.showCapacity = false;
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.tank.liquid, 104, 6, 104, 42);
            this.liquidInput = output_cont[0];
            this.liquidOutput = output_cont[1];
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.liquidInput != null && this.liquidOutput != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(LiquidDictionaryList.this.cycleticks / 20, this.liquidInput));
                stacks.add(LiquidHelper.getSeqCycledStack(LiquidDictionaryList.this.cycleticks / 20, this.liquidOutput));
            }
            return stacks;
        }

        public boolean sameLiquid(LiquidStack liquid) {
            return LiquidHelper.areSameLiquid(this.tank.liquid, liquid);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidDictionaryTank> res = new ArrayList<LiquidDictionaryTank>();
            res.add(this.tank);
            return res;
        }
    }
}

