/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.utils.ShapedRecipeCustom;
import java.util.ArrayList;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public abstract class ForestryRecipeHandler
extends LiquidTemplateRecipeHandler {
    public boolean containsIngredient(IRecipe recipe, ItemStack ingredient) {
        if (recipe instanceof ShapedRecipeCustom) {
            return ((ShapedRecipeCustom)recipe).isIngredient(ingredient);
        }
        NEIPlugins.logInfo("ForestryRecipeHandler.containsIngredient: class {0} not supported. Recipe output: {1}", recipe.getClass().getName(), recipe.func_77571_b());
        return false;
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public abstract class CachedShapedRecipeCustom
    extends TemplateRecipeHandler.CachedRecipe {
        public int xoffset;
        public int yoffset;
        public int xproduct;
        public int yproduct;
        public ArrayList ingredients;
        public PositionedStack product;

        public CachedShapedRecipeCustom() {
            super((TemplateRecipeHandler)ForestryRecipeHandler.this);
        }

        public void setIngredients(IDescriptiveRecipe recipe) {
            this.product = new PositionedStack((Object)recipe.func_77571_b(), this.xproduct, this.yproduct);
            this.setIngredients(recipe.getWidth(), recipe.getHeight(), recipe.getIngredients());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], this.xoffset + x * 18, this.yoffset + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public PositionedStack getResult() {
            return this.product;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(ForestryRecipeHandler.this.cycleticks / 20, this.ingredients);
        }
    }
}

