/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.buildcraft;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class IronEngineFuelsHandler
extends TemplateRecipeHandler {
    static Rectangle fuelTank = new Rectangle(99, 3, 16, 58);
    static Rectangle coolantTank = new Rectangle(117, 3, 16, 58);
    static Point overlayTank = new Point(176, 0);

    public String getRecipeName() {
        return "Combustion Engine";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public void drawLiquidTanks(GuiContainerManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui, this.getGuiTexture());
            }
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(147, 11, 12, 12), "buildcraft.ironengine.coolant", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(147, 27, 12, 12), "buildcraft.ironengine.fuel", new Object[0]));
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTexture(this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 16, 166, 65);
    }

    public void drawForeground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        gui.bindTexture("/gfx/buildcraft/gui/triggers.png");
        if (recipe % 2 == 0) {
            gui.drawTexturedModalRect(150, 30, 5, 21, 6, 6);
            gui.drawTexturedModalRect(150, 14, 37, 21, 6, 6);
        }
        gui.bindTexture(this.getGuiTexture());
        this.drawExtras(gui, recipe);
        this.drawLiquidTanks(gui, recipe);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            IronEngineCoolant coolant;
            LiquidStack t = (LiquidStack)ingredients[0];
            IronEngineFuel fuel = IronEngineFuel.getFuelForLiquid((LiquidStack)t);
            if (fuel != null) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
            if ((coolant = IronEngineCoolant.getCoolantForLiquid((LiquidStack)t)) != null) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        if (t != null) {
            IronEngineCoolant coolant;
            IronEngineFuel fuel = IronEngineFuel.getFuelForLiquid((LiquidStack)t);
            if (fuel != null) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
            if ((coolant = IronEngineCoolant.getCoolantForLiquid((LiquidStack)t)) != null) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("buildcraft.ironengine.fuel") && ((Object)((Object)this)).getClass() == IronEngineFuelsHandler.class) {
            for (IronEngineCoolant coolant : IronEngineCoolant.coolants) {
                this.arecipes.add(new CachedIronEngineRecipeCoolant(coolant, ((IronEngineFuel)IronEngineFuel.fuels.get((int)0)).liquid));
            }
        } else if (outputId.equals("buildcraft.ironengine.coolant") && ((Object)((Object)this)).getClass() == IronEngineFuelsHandler.class) {
            for (IronEngineFuel fuel : IronEngineFuel.fuels) {
                this.arecipes.add(new CachedIronEngineRecipeFuel(fuel, ((IronEngineCoolant)IronEngineCoolant.coolants.get((int)0)).liquid));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getGuiTexture() {
        return "/gfx/buildcraft/gui/combustion_engine_gui.png";
    }

    protected boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        currenttip = super.handleTooltip(guiRecipe, currenttip, recipe);
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (guiRecipe.manager.shouldShowTooltip() && crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = guiRecipe.manager.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.field_74198_m - offset.x, mousepos.y - guiRecipe.field_74197_n - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public class IronEngineFuelLiquidTank
    extends LiquidTank {
        public float powerPerCycle;
        public int totalBurningTime;

        public IronEngineFuelLiquidTank(IronEngineFuel fuel, int capacity, Rectangle position, Point overlay) {
            super(fuel.liquid, capacity, position);
            this.liquid.amount = capacity;
            this.powerPerCycle = fuel.powerPerCycle;
            this.totalBurningTime = fuel.totalBurningTime;
            this.overlay = overlay;
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add("\u00a77Stats per bucket:");
                currenttip.add("\u00a77Output: " + this.powerPerCycle + " MJ/t");
                currenttip.add("\u00a77Duration: " + this.totalBurningTime + " t");
            }
            return currenttip;
        }
    }

    public class IronEngineCoolantLiquidTank
    extends LiquidTank {
        public float coolingPerUnit;

        public IronEngineCoolantLiquidTank(IronEngineCoolant coolant, int capacity, Rectangle position, Point overlay) {
            super(coolant.liquid, capacity, position);
            this.liquid.amount = capacity;
            this.coolingPerUnit = coolant.coolingPerUnit;
            this.overlay = overlay;
        }

        @Override
        public List additionalHandleTooltip(List currenttip) {
            if (this.liquid.itemID > 0) {
                currenttip.add("\u00a77Coolant: " + this.coolingPerUnit + "");
            }
            return currenttip;
        }
    }

    public class CachedIronEngineRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList slot_input;
        LiquidTank fueltank;
        LiquidTank coolanttank;

        public CachedIronEngineRecipe() {
            super((TemplateRecipeHandler)IronEngineFuelsHandler.this);
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(IronEngineFuelsHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.fueltank);
            res.add(this.coolanttank);
            return res;
        }
    }

    public class CachedIronEngineRecipeCoolant
    extends CachedIronEngineRecipe {
        public CachedIronEngineRecipeCoolant(IronEngineCoolant coolant, LiquidStack liquid) {
            liquid.amount = 10000;
            this.fueltank = new LiquidTank(liquid, 10000, fuelTank, overlayTank);
            this.coolanttank = new IronEngineCoolantLiquidTank(coolant, 10000, coolantTank, overlayTank);
            this.fueltank.showAmount = false;
            this.coolanttank.showAmount = false;
            this.fueltank.overrideTitle = "Fuel";
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.coolanttank.liquid, 47, 9, 47, 25);
            this.slot_input = new ArrayList();
            if (input_cont[1] != null) {
                this.slot_input.add(input_cont[1]);
            }
        }
    }

    public class CachedIronEngineRecipeFuel
    extends CachedIronEngineRecipe {
        public CachedIronEngineRecipeFuel(IronEngineFuel fuel, LiquidStack liquid) {
            liquid.amount = 10000;
            this.fueltank = new IronEngineFuelLiquidTank(fuel, 10000, fuelTank, overlayTank);
            this.coolanttank = new LiquidTank(liquid, 10000, coolantTank, overlayTank);
            this.fueltank.showAmount = false;
            this.coolanttank.showAmount = false;
            this.coolanttank.overrideTitle = "Coolant";
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.fueltank.liquid, 47, 9, 47, 25);
            this.slot_input = new ArrayList();
            if (input_cont[1] != null) {
                this.slot_input.add(input_cont[1]);
            }
        }
    }
}

