/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.item.Items;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.common.ItemApiHelper;
import mods.neiplugins.common.RecipeHandlerUtils;
import mods.neiplugins.common.Utils;
import mods.neiplugins.ic2.GuiValuableOreList;
import mods.neiplugins.ic2.IC2FuelHelper;
import mods.neiplugins.ic2.MassFabricatorRecipeHandler;
import mods.neiplugins.options.OptionsIC2;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class NEIPlugins_IC2
implements IPlugin {
    public static final String PLUGIN_NAME = "IC2";
    public static final String PLUGIN_VERSION = "1.1.0";
    public static final String REQUIRED_MOD = "IC2@[1.115.320-lf,)";

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod(REQUIRED_MOD);
    }

    @Override
    public void init() {
    }

    @Override
    public void loadConfig() {
        this.configureItemPanel();
        this.initHandlers();
        this.addTransferRects();
        OptionsIC2.addOptions();
    }

    public static ItemStack getIc2Item(String name) {
        return Items.getItem((String)name);
    }

    private void addTransferRects() {
        Class cls = Utils.findClass("ic2.core.block.machine.gui.GuiIronFurnace");
        ArrayList<Class> guis = new ArrayList<Class>();
        ArrayList<TemplateRecipeHandler.RecipeTransferRect> transferRects = new ArrayList<TemplateRecipeHandler.RecipeTransferRect>();
        if (cls != null) {
            guis.add(cls);
            transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
            transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
            TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(guis, transferRects);
        }
        cls = Utils.findClass("ic2.core.block.machine.gui.GuiElecFurnace");
        guis = new ArrayList();
        transferRects = new ArrayList();
        if (cls != null) {
            guis.add(cls);
            transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
            TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(guis, transferRects);
        }
    }

    private void initHandlers() {
        MassFabricatorRecipeHandler.guiclass = Utils.findClass("ic2.core.block.machine.gui.GuiMatter");
        Class cls = Utils.findClass("ic2.core.IC2");
        if (cls != null) {
            GuiValuableOreList.valuableOres = (Map)Utils.getField(cls, "valuableOres", null);
        }
        RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_IC2.getIc2Item("compressor"), "Compressor", 0, "ic2.compressor", new Object[0]);
        RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_IC2.getIc2Item("extractor"), "Extractor", 0, "ic2.extractor", new Object[0]);
        RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_IC2.getIc2Item("macerator"), "Macerator", 0, "ic2.macerator", new Object[0]);
        if (NEIPlugins_IC2.getIc2Item("matter") != null) {
            MassFabricatorRecipeHandler.addEmptyScrap = true;
            API.registerRecipeHandler((ICraftingHandler)new MassFabricatorRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new MassFabricatorRecipeHandler());
            RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_IC2.getIc2Item("massFabricator"), "Mass Fabricator", 0, "ic2.matter", new Object[0]);
        }
        RecipeHandlerUtils.addToRecipeList(PLUGIN_NAME, NEIPlugins_IC2.getIc2Item("scrapBox"), "Scrapbox", 0, "ic2.scrapbox", new Object[0]);
        IC2FuelHelper.registerFuelHelpers();
        FuelTooltip.addValidNBTItem(NEIPlugins_IC2.getIc2Item("filledFuelCan"));
    }

    private void configureItemPanel() {
        MultiItemRange electricItems = new MultiItemRange();
        MultiItemRange reactorComponents = new MultiItemRange();
        MultiItemRange tfbp = new MultiItemRange();
        MultiItemRange painters = new MultiItemRange();
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("reinforcedDoorBlock"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("activeLuminator"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("miningPipeTip"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("dynamiteStick"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("dynamiteStickWithRemote"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("constructionFoamWall"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("blockBarrel"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("enabledNanoSaber"));
        ItemApiHelper.hideItem(NEIPlugins_IC2.getIc2Item("copperCableBlock"));
        Class IElectricItem = Utils.findClass("ic2.api.item.IElectricItem");
        Class IReactorComponent = Utils.findClass("ic2.api.reactor.IReactorComponent");
        Class ITerraformingBP = Utils.findClass("ic2.api.item.ITerraformingBP");
        for (Item i : Item.field_77698_e) {
            if (IElectricItem != null && IElectricItem.isInstance(i)) {
                electricItems.add(i.field_77779_bT);
            }
            if (IReactorComponent != null && IReactorComponent.isInstance(i)) {
                ItemApiHelper.addItemToRangeWithNBT(reactorComponents, i);
            }
            if (ITerraformingBP == null || !ITerraformingBP.isInstance(i)) continue;
            tfbp.add(i.field_77779_bT);
        }
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("blackPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("redPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("greenPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("brownPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("bluePainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("purplePainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("cyanPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("lightGreyPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("darkGreyPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("pinkPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("limePainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("yellowPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("cloudPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("magentaPainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("orangePainter"));
        ItemApiHelper.addItemStackToRange(painters, NEIPlugins_IC2.getIc2Item("whitePainter"));
        API.addSetRange((String)"IC2 Related.Electric Items", (MultiItemRange)electricItems);
        API.addSetRange((String)"IC2 Related.Reactor Components", (MultiItemRange)reactorComponents);
        API.addSetRange((String)"IC2 Related.Terraformer Blueprints", (MultiItemRange)tfbp);
        API.addSetRange((String)"IC2 Related.Tools.Painters", (MultiItemRange)painters);
        ItemApiHelper.addSetRangeFromItem("IC2 Related.Seeds", NEIPlugins_IC2.getIc2Item("cropSeed"));
    }
}

