/*
 * Decompiled with CFR 0.152.
 */
package mods.chemcraft.snowfall.asm;

import cpw.mods.fml.relauncher.IClassTransformer;
import mods.chemcraft.snowfall.asm.SnowfallLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SnowTransformer
implements IClassTransformer {
    private static String worldName = "";
    private static String playerName = "";
    private static String itemStackName = "";
    private static String itemBlockWithMetadataName = "";
    private static String snowfallHooks = "mods/chemcraft/snowfall/asm/SnowfallHooks";

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.world.World")) {
            worldName = name;
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            InsnList canSnowAtBody = new InsnList();
            canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(25, 0));
            canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(21, 1));
            canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(21, 2));
            canSnowAtBody.add((AbstractInsnNode)new VarInsnNode(21, 3));
            canSnowAtBody.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "canSnowAtBody", "(L" + worldName + ";III)Z"));
            canSnowAtBody.add((AbstractInsnNode)new InsnNode(172));
            for (MethodNode mn : node.methods) {
                if (!mn.name.equals("canSnowAtBody")) continue;
                if (SnowfallLoadingPlugin.isDebugMode) {
                    SnowfallLoadingPlugin.myLogger.fine("Found canSnowAtBody in World: Replacing");
                }
                mn.instructions = canSnowAtBody;
            }
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            playerName = name;
            return bytes;
        }
        if (transformedName.equals("net.minecraft.item.ItemStack")) {
            itemStackName = name;
            return bytes;
        }
        if (transformedName.equals("net.minecraft.item.ItemBlockWithMetadata")) {
            itemBlockWithMetadataName = name;
            return bytes;
        }
        if (transformedName.equals("net.minecraft.item.ItemSnow")) {
            this.checkClassLoaded(worldName, "net.minecraft.world.World");
            this.checkClassLoaded(playerName, "net.minecraft.entity.player.EntityPlayer");
            this.checkClassLoaded(itemStackName, "net.minecraft.item.ItemStack");
            this.checkClassLoaded(itemBlockWithMetadataName, "net.minecraft.item.ItemBlockWithMetadata");
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            InsnList onItemUse = new InsnList();
            LabelNode skip29 = new LabelNode();
            LabelNode skip38 = new LabelNode();
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 1));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 2));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 3));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 4));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 5));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 6));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 7));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 8));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 9));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 10));
            onItemUse.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "onItemUse", "(L" + itemStackName + ";L" + playerName + ";L" + worldName + ";IIIIFFF)I"));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(54, 11));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 11));
            onItemUse.add((AbstractInsnNode)new JumpInsnNode(154, skip29));
            onItemUse.add((AbstractInsnNode)new InsnNode(4));
            onItemUse.add((AbstractInsnNode)new InsnNode(172));
            onItemUse.add((AbstractInsnNode)skip29);
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 11));
            onItemUse.add((AbstractInsnNode)new InsnNode(5));
            onItemUse.add((AbstractInsnNode)new JumpInsnNode(160, skip38));
            onItemUse.add((AbstractInsnNode)new IincInsnNode(5, 1));
            onItemUse.add((AbstractInsnNode)skip38);
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 0));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 1));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 2));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(25, 3));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 4));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 5));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 6));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(21, 7));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 8));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 9));
            onItemUse.add((AbstractInsnNode)new VarInsnNode(23, 10));
            onItemUse.add((AbstractInsnNode)new MethodInsnNode(183, itemBlockWithMetadataName, "a", "(L" + itemStackName + ";L" + playerName + ";L" + worldName + ";IIIIFFF)Z"));
            onItemUse.add((AbstractInsnNode)new InsnNode(172));
            for (MethodNode mn : node.methods) {
                if (!mn.desc.equals("(L" + itemStackName + ";L" + playerName + ";L" + worldName + ";IIIIFFF)Z")) continue;
                if (SnowfallLoadingPlugin.isDebugMode) {
                    SnowfallLoadingPlugin.myLogger.fine("Found onItemUse in ItemSnow: Replacing");
                }
                mn.instructions = onItemUse;
            }
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        if (transformedName.equals("net.minecraft.block.BlockSnowBlock")) {
            this.checkClassLoaded(worldName, "net.minecraft.world.World");
            this.checkClassLoaded(playerName, "net.minecraft.entity.player.EntityPlayer");
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            InsnList harvestBlock = new InsnList();
            LabelNode skip = new LabelNode();
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 1));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 2));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 3));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 4));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 5));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 6));
            harvestBlock.add((AbstractInsnNode)new InsnNode(3));
            harvestBlock.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "snowShovelHook", "(L" + worldName + ";L" + playerName + ";IIIIZ)Z"));
            harvestBlock.add((AbstractInsnNode)new JumpInsnNode(153, skip));
            harvestBlock.add((AbstractInsnNode)new InsnNode(177));
            harvestBlock.add((AbstractInsnNode)skip);
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 0));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 1));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 2));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 3));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 4));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 5));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 6));
            harvestBlock.add((AbstractInsnNode)new MethodInsnNode(183, node.superName, "a", "(L" + worldName + ";L" + playerName + ";IIII)V"));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 1));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 3));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 4));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 5));
            harvestBlock.add((AbstractInsnNode)new MethodInsnNode(182, worldName, "i", "(III)Z"));
            harvestBlock.add((AbstractInsnNode)new InsnNode(87));
            harvestBlock.add((AbstractInsnNode)new InsnNode(177));
            MethodNode mn = new MethodNode(1, "a", "(L" + worldName + ";L" + playerName + ";IIII)V", null, new String[0]);
            mn.instructions = harvestBlock;
            node.methods.add(mn);
            if (SnowfallLoadingPlugin.isDebugMode) {
                SnowfallLoadingPlugin.myLogger.fine("Adding BlockSnowBlock Snowshovel Hook");
            }
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        if (transformedName.equals("net.minecraft.block.BlockSnow")) {
            this.checkClassLoaded(worldName, "net.minecraft.world.World");
            this.checkClassLoaded(playerName, "net.minecraft.entity.player.EntityPlayer");
            if (SnowfallLoadingPlugin.isDebugMode) {
                SnowfallLoadingPlugin.myLogger.fine("Running BlockSnow Transformer");
            }
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            InsnList updateTick = new InsnList();
            updateTick.add((AbstractInsnNode)new VarInsnNode(25, 1));
            updateTick.add((AbstractInsnNode)new VarInsnNode(21, 2));
            updateTick.add((AbstractInsnNode)new VarInsnNode(21, 3));
            updateTick.add((AbstractInsnNode)new VarInsnNode(21, 4));
            updateTick.add((AbstractInsnNode)new VarInsnNode(25, 5));
            updateTick.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "updateTick", "(L" + worldName + ";IIILjava/util/Random;)V"));
            updateTick.add((AbstractInsnNode)new InsnNode(177));
            InsnList harvestBlock = new InsnList();
            LabelNode skip = new LabelNode();
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 1));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(25, 2));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 3));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 4));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 5));
            harvestBlock.add((AbstractInsnNode)new VarInsnNode(21, 6));
            harvestBlock.add((AbstractInsnNode)new InsnNode(4));
            harvestBlock.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "snowShovelHook", "(L" + worldName + ";L" + playerName + ";IIIIZ)Z"));
            harvestBlock.add((AbstractInsnNode)new JumpInsnNode(153, skip));
            harvestBlock.add((AbstractInsnNode)new InsnNode(177));
            harvestBlock.add((AbstractInsnNode)skip);
            InsnList canPlaceBlockAt = new InsnList();
            canPlaceBlockAt.add((AbstractInsnNode)new VarInsnNode(25, 1));
            canPlaceBlockAt.add((AbstractInsnNode)new VarInsnNode(21, 2));
            canPlaceBlockAt.add((AbstractInsnNode)new VarInsnNode(21, 3));
            canPlaceBlockAt.add((AbstractInsnNode)new VarInsnNode(21, 4));
            canPlaceBlockAt.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "canPlaceBlockAt", "(L" + worldName + ";III)Z"));
            canPlaceBlockAt.add((AbstractInsnNode)new InsnNode(172));
            InsnList isBlockSolidOnSide = new InsnList();
            isBlockSolidOnSide.add((AbstractInsnNode)new VarInsnNode(25, 1));
            isBlockSolidOnSide.add((AbstractInsnNode)new VarInsnNode(21, 2));
            isBlockSolidOnSide.add((AbstractInsnNode)new VarInsnNode(21, 3));
            isBlockSolidOnSide.add((AbstractInsnNode)new VarInsnNode(21, 4));
            isBlockSolidOnSide.add((AbstractInsnNode)new VarInsnNode(25, 5));
            isBlockSolidOnSide.add((AbstractInsnNode)new MethodInsnNode(184, snowfallHooks, "isBlockSolidOnSide", "(L" + worldName + ";IIILnet/minecraftforge/common/ForgeDirection;)Z"));
            isBlockSolidOnSide.add((AbstractInsnNode)new InsnNode(172));
            MethodNode isBlockSolid = new MethodNode(1, "isBlockSolidOnSide", "(L" + worldName + ";IIILnet/minecraftforge/common/ForgeDirection;)Z", null, new String[0]);
            isBlockSolid.instructions = isBlockSolidOnSide;
            node.methods.add(isBlockSolid);
            InsnList isBlockReplaceable = new InsnList();
            isBlockReplaceable.add((AbstractInsnNode)new InsnNode(4));
            isBlockReplaceable.add((AbstractInsnNode)new InsnNode(172));
            MethodNode replaceable = new MethodNode(1, "isBlockReplaceable", "(L" + worldName + ";III)Z", null, new String[0]);
            replaceable.instructions = isBlockReplaceable;
            node.methods.add(replaceable);
            for (MethodNode mn : node.methods) {
                if (SnowfallLoadingPlugin.isDebugMode) {
                    SnowfallLoadingPlugin.myLogger.fine("Method name: " + mn.name + " Description: " + mn.desc + " Signature: " + mn.signature);
                }
                if (mn.name.equals("a") && mn.desc.equals("(L" + worldName + ";IIILjava/util/Random;)V")) {
                    if (SnowfallLoadingPlugin.isDebugMode) {
                        SnowfallLoadingPlugin.myLogger.fine("Found updateTick Method: Replacing");
                    }
                    mn.instructions = updateTick;
                }
                if (mn.name.equals("a") && mn.desc.equals("(L" + worldName + ";L" + playerName + ";IIII)V")) {
                    if (SnowfallLoadingPlugin.isDebugMode) {
                        SnowfallLoadingPlugin.myLogger.fine("Found harvestBlock Method: Adding Hook");
                    }
                    mn.instructions.insertBefore(mn.instructions.getFirst(), harvestBlock);
                }
                if (!mn.name.equals("c") || !mn.desc.equals("(L" + worldName + ";III)Z")) continue;
                if (SnowfallLoadingPlugin.isDebugMode) {
                    SnowfallLoadingPlugin.myLogger.fine("Found canPlaceBlockAt Method: Replacing");
                }
                mn.instructions = canPlaceBlockAt;
            }
            ClassWriter writer = new ClassWriter(0);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return bytes;
    }

    private void checkClassLoaded(String var, String className) {
        if (var == "") {
            try {
                this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                var = " ";
            }
        }
    }
}

