/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;

public class TreetapModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_TREETAP = "Treetap";
    public static final String TREETAP_ENERGY_CONSUMPTION = "Energy Consumption";
    private static wm rubber = ModCompatability.getIC2Item((String)"rubberWood");
    private static wm resin = ModCompatability.getIC2Item((String)"resin");

    public TreetapModule(List validItems) {
        super(validItems);
        this.addBaseProperty(TREETAP_ENERGY_CONSUMPTION, 100.0);
        this.addInstallCost(ModCompatability.getIC2Item((String)"electricTreetap"));
    }

    public String getTextureFile() {
        return "treetap";
    }

    public String getCategory() {
        return "Tool";
    }

    public String getDataName() {
        return MODULE_TREETAP;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.treetap.name");
    }

    public String getDescription() {
        return "An IC2 treetap integrated in your power tool.";
    }

    public void onRightClick(sq player, aab world, wm item) {
    }

    public void onItemUse(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int blockID = world.a(x, y, z);
        if (blockID == TreetapModule.rubber.c) {
            TreetapModule.tryExtract(player, world, x, y, z, side, null);
            ElectricItemUtils.drainPlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)itemStack, (String)TREETAP_ENERGY_CONSUMPTION));
        }
    }

    public static boolean tryExtract(sq player, aab world, int x, int y, int z, int side, List stacks) {
        wm tempResin;
        int metadata = world.h(x, y, z);
        if (metadata < 2 || metadata % 6 != side) {
            return false;
        }
        if (metadata < 6 && AddonUtils.isServerSide()) {
            world.b(x, y, z, metadata + 6, 7);
            if (stacks != null) {
                tempResin = resin.m();
                tempResin.a = world.s.nextInt(3);
                stacks.add(tempResin);
            } else {
                TreetapModule.eject(world, x, y, z, side, world.s.nextInt(3) + 1);
            }
            world.a(x, y, z, TreetapModule.rubber.c, apa.r[TreetapModule.rubber.c].a(world));
        }
        if (world.s.nextInt(5) == 0 && AddonUtils.isServerSide()) {
            world.b(x, y, z, 1, 7);
        }
        if (world.s.nextInt(5) == 0) {
            if (AddonUtils.isServerSide()) {
                TreetapModule.eject(world, x, y, z, side, 1);
                if (stacks != null) {
                    tempResin = resin.m();
                    tempResin.a = world.s.nextInt(3);
                    stacks.add(tempResin);
                } else {
                    TreetapModule.eject(world, x, y, z, side, 1);
                }
            }
            return true;
        }
        return false;
    }

    public static void eject(aab world, int x, int y, int z, int side, int quantity) {
        double ejectX = (double)x + 0.5;
        double ejectY = (double)y + 0.5;
        double ejectZ = (double)z + 0.5;
        if (side == 2) {
            ejectZ -= 0.3;
        } else if (side == 5) {
            ejectX += 0.3;
        } else if (side == 3) {
            ejectZ += 0.3;
        } else if (side == 4) {
            ejectX -= 0.3;
        }
        for (int i = 0; i < quantity; ++i) {
            rh item = new rh(world, ejectX, ejectY, ejectZ, resin.m());
            item.b = 10;
            world.d((mp)item);
        }
    }

    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

