/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;

public class TorchPlacerModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule,
IRightClickModule {
    public static final String MODULE_TORCH_PLACER = "Torch Placer";
    public static final String TORCH_ENERGY_CONSUMPTION = "Energy Consumption";
    public static final String MAX_TORCH_STORAGE = "Maximum Storage Amount";
    public aph torch = AddonConfig.torch;

    public TorchPlacerModule(List validItems) {
        super(validItems);
        this.addBaseProperty(TORCH_ENERGY_CONSUMPTION, 50.0);
        this.addBaseProperty(MAX_TORCH_STORAGE, 64.0);
        this.addTradeoffProperty("Storage", MAX_TORCH_STORAGE, 192.0);
        this.addTradeoffProperty("Storage", TORCH_ENERGY_CONSUMPTION, 450.0);
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.servoMotor, (int)2));
    }

    public String getTextureFile() {
        return "torchplacer";
    }

    public String getCategory() {
        return "Special";
    }

    public String getDataName() {
        return MODULE_TORCH_PLACER;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.torchPlacer.name");
    }

    public String getDescription() {
        return "Stores torches in an internal storage and places them in the world on use.";
    }

    public void onPlayerTickActive(sq player, wm item) {
        so inv = player.bK;
        int torchesNeeded = (int)ModuleManager.computeModularProperty((wm)item, (String)MAX_TORCH_STORAGE) - AddonUtils.getTorchLevel(item);
        if (torchesNeeded > 0) {
            for (int i = 0; i < inv.j_(); ++i) {
                wm stack = inv.a(i);
                if (stack == null || stack.c != apa.au.cz) continue;
                int loopTimes = torchesNeeded < stack.a ? torchesNeeded : stack.a;
                for (int i2 = 0; i2 < loopTimes; ++i2) {
                    AddonUtils.setTorchLevel(item, AddonUtils.getTorchLevel(item) + 1);
                    player.bK.a(i, 1);
                    if (stack.a != 0) continue;
                    player.bK.a(i, null);
                }
                if (!(ModuleManager.computeModularProperty((wm)item, (String)MAX_TORCH_STORAGE) - (double)AddonUtils.getTorchLevel(item) < 1.0)) continue;
                i = inv.j_() + 1;
            }
        }
    }

    public void onPlayerTickInactive(sq player, wm item) {
    }

    public void onRightClick(sq player, aab world, wm item) {
    }

    public void onItemUse(wm item, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (AddonUtils.getTorchLevel(item) > 0) {
            if (player.a(x, y, z, side, item) && apa.r[apa.au.cz].c(world, x, y, z)) {
                int blockID = world.a(x, y, z);
                if (!(blockID == apa.by.cz || blockID == apa.ab.cz || blockID == apa.ac.cz || apa.r[blockID] != null && apa.r[blockID].isBlockReplaceable(world, x, y, z))) {
                    x += side == 5 ? 1 : (side == 4 ? -1 : 0);
                    y += side == 1 ? 1 : (side == 0 ? -1 : 0);
                    z += side == 3 ? 1 : (side == 2 ? -1 : 0);
                }
                blockID = world.a(x, y, z);
                if (world.c(x, y, z) || apa.r[blockID].isBlockReplaceable(world, x, y, z)) {
                    if (this.torch.c(world, x, y, z)) {
                        world.f(x, y, z, apa.au.cz, this.getMetaForTorch(world, x, y, z, side), 2);
                        world.f(x, y, z, apa.au.cz);
                        apa.r[apa.au.cz].a(world, x, y, z);
                        AddonUtils.setTorchLevel(item, AddonUtils.getTorchLevel(item) - 1);
                        ElectricItemUtils.drainPlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)TORCH_ENERGY_CONSUMPTION));
                    } else if (AddonUtils.isClientSide()) {
                        player.a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((wm)item, (String)MAX_TORCH_STORAGE));
                    }
                } else if (AddonUtils.isClientSide()) {
                    player.a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((wm)item, (String)MAX_TORCH_STORAGE));
                }
            } else if (AddonUtils.isClientSide()) {
                player.a("[MPSA] Cannot place a torch here. Torch level: " + AddonUtils.getTorchLevel(item) + "/" + (int)ModuleManager.computeModularProperty((wm)item, (String)MAX_TORCH_STORAGE));
            }
        } else {
            player.a("[MPSA] No torches!");
        }
    }

    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }

    public int getMetaForTorch(aab world, int x, int y, int z, int side) {
        return apa.r[apa.au.cz].a(world, x, y, z, side, (float)x, (float)y, (float)z, 0);
    }
}

