/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;

public class ThermalGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_THERMAL_GENERATOR = "Thermal Generator";
    public static final String THERMAL_ENERGY_GENERATION = "Energy Generation";

    public ThermalGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(THERMAL_ENERGY_GENERATION, 25.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addTradeoffProperty("Energy Generated", THERMAL_ENERGY_GENERATION, 25.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 1000.0, "g");
        if (ModCompatability.isIndustrialCraftLoaded()) {
            this.addInstallCost(ModCompatability.getIC2Item((String)"geothermalGenerator"));
            this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)1));
        } else {
            this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)2));
            this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.basicPlating, (int)1));
        }
    }

    public String getTextureFile() {
        return "heatgenerator";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getDataName() {
        return MODULE_THERMAL_GENERATOR;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.thermalGenerator.name");
    }

    public String getDescription() {
        return "Generate power from extreme amounts of heat.";
    }

    public void onPlayerTickActive(sq player, wm item) {
        double currentHeat = MuseHeatUtils.getPlayerHeat((sq)player);
        double maxHeat = MuseHeatUtils.getMaxHeat((sq)player);
        if (player.q.H() % 20L == 0L) {
            if (player.ae()) {
                ElectricItemUtils.givePlayerEnergy((sq)player, (double)(4.0 * ModuleManager.computeModularProperty((wm)item, (String)THERMAL_ENERGY_GENERATION)));
            } else if (currentHeat >= 200.0) {
                ElectricItemUtils.givePlayerEnergy((sq)player, (double)(2.0 * ModuleManager.computeModularProperty((wm)item, (String)THERMAL_ENERGY_GENERATION)));
            } else if (currentHeat / maxHeat >= 0.5) {
                ElectricItemUtils.givePlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)THERMAL_ENERGY_GENERATION));
            }
        }
    }

    public void onPlayerTickInactive(sq player, wm item) {
    }
}

