/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonComponent;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;

public class SolarGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule {
    public static final String MODULE_SOLAR_GENERATOR = "Solar Generator";
    public static final String SOLAR_ENERGY_GENERATION_DAY = "Daytime Energy Generation";
    public static final String SOLAR_ENERGY_GENERATION_NIGHT = "Nighttime Energy Generation";

    public SolarGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(SOLAR_ENERGY_GENERATION_DAY, 1500.0);
        this.addBaseProperty(SOLAR_ENERGY_GENERATION_NIGHT, 150.0);
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)AddonComponent.solarPanel, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)2));
    }

    public String getTextureFile() {
        return "solarhelmet";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getDataName() {
        return MODULE_SOLAR_GENERATOR;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.solarGenerator.name");
    }

    public String getDescription() {
        return "Let the sun power your adventures.";
    }

    public void onPlayerTickActive(sq player, wm item) {
        wm helmet = player.q(3);
        if (helmet != null && helmet.equals(item)) {
            boolean moonVisible;
            aab world = player.q;
            int xCoord = kx.c((double)player.u);
            int zCoord = kx.c((double)player.w);
            boolean canRain = true;
            if (world.H() % 20L == 0L) {
                canRain = world.u().a(xCoord, zCoord).g() > 0;
            }
            boolean isRaining = canRain && (world.P() || world.O());
            boolean sunVisible = world.v() && !isRaining && world.l(xCoord, kx.c((double)player.v) + 1, zCoord);
            boolean bl = moonVisible = !world.v() && !isRaining && world.l(xCoord, kx.c((double)player.v) + 1, zCoord);
            if (!world.I && !world.t.f && world.H() % 80L == 0L) {
                if (sunVisible) {
                    ElectricItemUtils.givePlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)SOLAR_ENERGY_GENERATION_DAY));
                } else if (moonVisible) {
                    ElectricItemUtils.givePlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)SOLAR_ENERGY_GENERATION_NIGHT));
                }
            }
        }
    }

    public void onPlayerTickInactive(sq player, wm item) {
    }
}

