/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MusePlayerUtils;

public class LightningModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_LIGHTNING = "Lightning Summoner";
    public static final String LIGHTNING_ENERGY_CONSUMPTION = "Lightning Energy Consumption";
    public static final String HEAT = "Lightning Heat Emission";

    public LightningModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.hvcapacitor, (int)1));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.solenoid, (int)2));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.fieldEmitter, (int)2));
        this.addBaseProperty(LIGHTNING_ENERGY_CONSUMPTION, 500000.0, "");
        this.addBaseProperty(HEAT, 100.0, "");
    }

    public String getTextureFile() {
        return "bluestar";
    }

    public String getCategory() {
        return "Weapon";
    }

    public String getDataName() {
        return MODULE_LIGHTNING;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.lightningSummoner.name");
    }

    public String getDescription() {
        return "Allows you to summon lightning for a large energy cost.";
    }

    public void onRightClick(sq player, aab world, wm item) {
        double range = 64.0;
        double energyConsumption = ModuleManager.computeModularProperty((wm)item, (String)LIGHTNING_ENERGY_CONSUMPTION);
        if (energyConsumption < ElectricItemUtils.getPlayerEnergy((sq)player)) {
            ElectricItemUtils.drainPlayerEnergy((sq)player, (double)energyConsumption);
            MuseHeatUtils.heatPlayer((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)HEAT));
            ara MOP = MusePlayerUtils.doCustomRayTrace((aab)player.q, (sq)player, (boolean)true, (double)range);
            world.d((mp)new re(player.q, MOP.f.c, MOP.f.d, MOP.f.e));
        }
    }

    public void onItemUse(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

