/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.modules.PropertyModifierIntLinearAdditive;
import java.util.List;
import net.machinemuse.api.IPropertyModifier;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;

public class LeafBlowerModule
extends PowerModuleBase
implements IRightClickModule {
    private static final String MODULE_LEAF_BLOWER = "Leaf Blower";
    private static final String LEAF_BLOWER_ENERGY_CONSUMPTION = "Energy Consumption";
    private static final String PLANT_RADIUS = "Plant Radius";
    private static final String LEAF_RADIUS = "Leaf Radius";

    public LeafBlowerModule(List validItems) {
        super(validItems);
        this.addInstallCost(new wm(wk.p, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.solenoid, (int)1));
        this.addBaseProperty(LEAF_BLOWER_ENERGY_CONSUMPTION, 100.0, "J");
        this.addBaseProperty(PLANT_RADIUS, 1.0, "m");
        this.addBaseProperty(LEAF_RADIUS, 1.0, "m");
        this.addIntTradeoffProperty(PLANT_RADIUS, PLANT_RADIUS, 2.0, "m", 1, 0);
        this.addIntTradeoffProperty(LEAF_RADIUS, LEAF_RADIUS, 2.0, "m", 1, 0);
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, (IPropertyModifier)new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    public String getCategory() {
        return "Tool";
    }

    public String getDataName() {
        return MODULE_LEAF_BLOWER;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.leafBlower.name");
    }

    public String getDescription() {
        return "Create a torrent of air to knock plants out of the ground and leaves off of trees.";
    }

    public String getTextureFile() {
        return "leafblower";
    }

    public void onRightClick(sq player, aab world, wm item) {
    }

    public void onItemUse(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        apa tempBlock;
        int meta;
        int id;
        int k;
        int j;
        int i;
        int blockID = world.a(x, y, z);
        apa block = apa.r[blockID];
        int plant = (int)ModuleManager.computeModularProperty((wm)itemStack, (String)PLANT_RADIUS);
        int leaf = (int)ModuleManager.computeModularProperty((wm)itemStack, (String)LEAF_RADIUS);
        int totalEnergyDrain = 0;
        if (block != null && block.isLeaves(world, x, y, z)) {
            for (i = -leaf; i < leaf; ++i) {
                for (j = -leaf; j < leaf; ++j) {
                    for (k = -leaf; k < leaf; ++k) {
                        id = world.a(x + i, y + j, z + k);
                        meta = world.h(x + i, y + j, z + k);
                        tempBlock = apa.r[id];
                        if (tempBlock == null || !tempBlock.isLeaves(world, x + i, y + j, z + k)) continue;
                        if (tempBlock.canHarvestBlock(player, meta)) {
                            tempBlock.a(world, player, x + i, y + j, z + k, meta);
                            totalEnergyDrain = (int)((double)totalEnergyDrain + ModuleManager.computeModularProperty((wm)itemStack, (String)LEAF_BLOWER_ENERGY_CONSUMPTION));
                        }
                        world.i(x + i, y + j, z + k);
                    }
                }
            }
        }
        for (i = -plant; i < plant; ++i) {
            for (j = -plant; j < plant; ++j) {
                for (k = -plant; k < plant; ++k) {
                    id = world.a(x + i, y + j, z + k);
                    meta = world.h(x + i, y + j, z + k);
                    tempBlock = apa.r[id];
                    if (tempBlock == null || !(tempBlock instanceof alh) || !tempBlock.canHarvestBlock(player, meta)) continue;
                    tempBlock.a(world, player, x + i, y + j, z + k, meta);
                    totalEnergyDrain = (int)((double)totalEnergyDrain + ModuleManager.computeModularProperty((wm)itemStack, (String)LEAF_BLOWER_ENERGY_CONSUMPTION));
                    world.i(x + i, y + j, z + k);
                }
            }
        }
        ElectricItemUtils.drainPlayerEnergy((sq)player, (double)totalEnergyDrain);
    }

    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

