/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;

public class KineticGeneratorModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_KINETIC_GENERATOR = "Kinetic Generator";
    public static final String KINETIC_ENERGY_GENERATION = "Energy Per 5 Blocks";
    public static final String KINETIC_HEAT_GENERATION = "Heat Generation";

    public KineticGeneratorModule(List validItems) {
        super(validItems);
        this.addBaseProperty(KINETIC_HEAT_GENERATION, 5.0);
        this.addBaseProperty("Weight", 1000.0);
        this.addBaseProperty(KINETIC_ENERGY_GENERATION, 200.0);
        this.addTradeoffProperty("Energy Generated", KINETIC_ENERGY_GENERATION, 600.0, " Joules");
        this.addTradeoffProperty("Energy Generated", "Weight", 3000.0, "g");
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.servoMotor, (int)2));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)1));
    }

    public String getTextureFile() {
        return "kineticgen";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getDataName() {
        return MODULE_KINETIC_GENERATOR;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.kineticGenerator.name");
    }

    public String getDescription() {
        return "Generate power with your movement.";
    }

    public void onPlayerTickActive(sq player, wm item) {
        if (!player.an) {
            double distance;
            boolean isNotWalking;
            bs tag = MuseItemUtils.getMuseItemTag((wm)item);
            boolean bl = isNotWalking = player.o != null || player.G();
            if (!tag.b("x") || isNotWalking) {
                tag.a("x", (int)player.u);
            }
            if (!tag.b("z") || isNotWalking) {
                tag.a("z", (int)player.w);
            }
            if ((distance = Math.sqrt((tag.e("x") - (int)player.u) * (tag.e("x") - (int)player.u) + (tag.e("z") - (int)player.w) * (tag.e("z") - (int)player.w))) >= 5.0) {
                tag.a("x", (int)player.u);
                tag.a("z", (int)player.w);
                if (player.ah()) {
                    ElectricItemUtils.givePlayerEnergy((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)KINETIC_ENERGY_GENERATION));
                    MuseHeatUtils.heatPlayer((sq)player, (double)ModuleManager.computeModularProperty((wm)item, (String)KINETIC_HEAT_GENERATION));
                } else {
                    ElectricItemUtils.givePlayerEnergy((sq)player, (double)(ModuleManager.computeModularProperty((wm)item, (String)KINETIC_ENERGY_GENERATION) / 2.0));
                    MuseHeatUtils.heatPlayer((sq)player, (double)(ModuleManager.computeModularProperty((wm)item, (String)KINETIC_HEAT_GENERATION) / 2.0));
                }
            }
        }
    }

    public void onPlayerTickInactive(sq player, wm item) {
    }
}

