/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.text.DecimalFormat;
import java.util.List;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.MuseItemUtils;

public class EUReaderModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_EU_READER = "EU Reader";

    public EUReaderModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)1));
        this.addInstallCost(ModCompatability.getIC2Item((String)"ecMeter"));
    }

    public String getTextureFile() {
        return "eureader";
    }

    public String getCategory() {
        return "Energy";
    }

    public String getDataName() {
        return MODULE_EU_READER;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.euReader.name");
    }

    public String getDescription() {
        return "An IC2 EU Reader integrated in your power tool.";
    }

    public void onRightClick(sq player, aab world, wm item) {
    }

    public void onItemUse(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        aqp tileEntity = world.r(x, y, z);
        if ((tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            bs nbtData = AddonUtils.getNBTTag(itemStack);
            long currentTotalEnergyEmitted = EnergyNet.getForWorld((aab)world).getTotalEnergyEmitted(tileEntity);
            long currentTotalEnergySunken = EnergyNet.getForWorld((aab)world).getTotalEnergySunken(tileEntity);
            long currentMeasureTime = world.I();
            if (nbtData.e("lastMeasuredTileEntityX") != x || nbtData.e("lastMeasuredTileEntityY") != y || nbtData.e("lastMeasuredTileEntityZ") != z) {
                nbtData.a("lastMeasuredTileEntityX", x);
                nbtData.a("lastMeasuredTileEntityY", y);
                nbtData.a("lastMeasuredTileEntityZ", z);
                player.a("Starting new measurement");
            } else {
                long measurePeriod = currentMeasureTime - nbtData.f("lastMeasureTime");
                if (measurePeriod < 1L) {
                    measurePeriod = 1L;
                }
                double deltaEmitted = (currentTotalEnergyEmitted - nbtData.f("lastTotalEnergyEmitted")) / measurePeriod;
                double deltaSunken = (currentTotalEnergySunken - nbtData.f("lastTotalEnergySunken")) / measurePeriod;
                DecimalFormat powerFormat = new DecimalFormat("0.##");
                player.a("Measured power [EU/t]: " + powerFormat.format(deltaSunken) + " in " + powerFormat.format(deltaEmitted) + " out " + powerFormat.format(deltaSunken - deltaEmitted) + " gain" + " (avg. over " + measurePeriod + " ticks)");
            }
            nbtData.a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
            nbtData.a("lastTotalEnergySunken", currentTotalEnergySunken);
            nbtData.a("lastMeasureTime", currentMeasureTime);
            return true;
        }
        return false;
    }

    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

