/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.modules;

import andrew.powersuits.common.AddonConfig;
import andrew.powersuits.common.AddonUtils;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;

public class AutoFeederModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_AUTO_FEEDER = "Auto-Feeder";
    public static final String EATING_ENERGY_CONSUMPTION = "Eating Energy Consumption";
    public static final String EATING_EFFICIENCY = "Auto-Feeder Efficiency";

    public AutoFeederModule(List validItems) {
        super(validItems);
        this.addBaseProperty(EATING_ENERGY_CONSUMPTION, 100.0);
        this.addBaseProperty(EATING_EFFICIENCY, 50.0);
        this.addTradeoffProperty("Efficiency", EATING_ENERGY_CONSUMPTION, 100.0);
        this.addTradeoffProperty("Efficiency", EATING_EFFICIENCY, 50.0);
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.servoMotor, (int)2));
        this.addInstallCost(MuseItemUtils.copyAndResize((wm)ItemComponent.controlCircuit, (int)1));
    }

    public String getTextureFile() {
        return "autofeeder";
    }

    public String getCategory() {
        return "Environment";
    }

    public String getDataName() {
        return MODULE_AUTO_FEEDER;
    }

    public String getLocalizedName() {
        return bo.a((String)"module.autoFeeder.name");
    }

    public String getDescription() {
        return "Whenever you're hungry, this module will grab the bottom-left-most food item from your inventory and feed it to you, storing the rest for later.";
    }

    public void onPlayerTickActive(sq player, wm item) {
        if (AddonConfig.useOldAutoFeeder) {
            so inv = player.bK;
            double foodLevel = AddonUtils.getFoodLevel(item);
            double saturationLevel = AddonUtils.getSaturationLevel(item);
            double efficiency = ModuleManager.computeModularProperty((wm)item, (String)EATING_EFFICIENCY);
            for (int i = 0; i < inv.j_(); ++i) {
                wm stack = inv.a(i);
                if (stack == null || !(stack.b() instanceof wf)) continue;
                wf food = (wf)stack.b();
                for (int a = 0; a < stack.a; ++a) {
                    foodLevel += (double)food.g();
                    saturationLevel += (double)food.h();
                }
                foodLevel = foodLevel * efficiency / 100.0;
                saturationLevel = saturationLevel * efficiency / 100.0;
                AddonUtils.setFoodLevel(item, foodLevel);
                AddonUtils.setSaturationLevel(item, saturationLevel);
                player.bK.a(i, null);
            }
            double eatingEnergyConsumption = ModuleManager.computeModularProperty((wm)item, (String)EATING_ENERGY_CONSUMPTION);
            ti foodStats = player.cn();
            int foodNeeded = 20 - foodStats.a();
            if (foodNeeded > 0 && eatingEnergyConsumption * (double)foodNeeded < ElectricItemUtils.getPlayerEnergy((sq)player) && AddonUtils.getFoodLevel(item) > (double)foodNeeded) {
                if (AddonUtils.getSaturationLevel(item) >= 1.0) {
                    foodStats.a(foodNeeded, 1.0f);
                    AddonUtils.setSaturationLevel(item, AddonUtils.getSaturationLevel(item) - 1.0);
                } else {
                    foodStats.a(foodNeeded, 0.0f);
                }
                AddonUtils.setFoodLevel(item, AddonUtils.getFoodLevel(item) - (double)foodNeeded);
                ElectricItemUtils.drainPlayerEnergy((sq)player, (double)(eatingEnergyConsumption * (double)foodNeeded));
            }
        } else {
            double totalEnergy = ElectricItemUtils.getPlayerEnergy((sq)player);
            so inv = player.bK;
            double foodLevel = AddonUtils.getFoodLevel(item);
            double saturationLevel = AddonUtils.getSaturationLevel(item);
            double efficiency = ModuleManager.computeModularProperty((wm)item, (String)EATING_EFFICIENCY);
            ti foodStats = player.cn();
            int foodNeeded = 20 - foodStats.a();
            for (int i = 0; i < inv.j_() && (double)foodNeeded > foodLevel; ++i) {
                wm stack = inv.a(i);
                if (stack == null || !(stack.b() instanceof wf)) continue;
                wf food = (wf)stack.b();
                while (stack.a > 0 && (double)foodNeeded > foodLevel) {
                    foodLevel += (double)food.g() * efficiency / 100.0;
                    saturationLevel += (double)food.h() * efficiency / 100.0;
                    --stack.a;
                }
                if (stack.a != 0) continue;
                player.bK.a(i, null);
            }
            double eatingEnergyConsumption = (double)foodNeeded * ModuleManager.computeModularProperty((wm)item, (String)EATING_ENERGY_CONSUMPTION);
            int foodConsumed = (int)Math.min((double)foodNeeded, Math.min(foodLevel, eatingEnergyConsumption * totalEnergy));
            if (foodConsumed > 0) {
                if (saturationLevel >= 1.0) {
                    foodStats.a(foodConsumed, 1.0f);
                    saturationLevel -= 1.0;
                } else {
                    foodStats.a(foodConsumed, 0.0f);
                }
                foodLevel -= (double)foodConsumed;
                ElectricItemUtils.drainPlayerEnergy((sq)player, (double)(eatingEnergyConsumption * (double)foodConsumed));
            }
            AddonUtils.setFoodLevel(item, foodLevel);
            AddonUtils.setSaturationLevel(item, saturationLevel);
        }
    }

    public void onPlayerTickInactive(sq player, wm item) {
    }
}

