/*
 * Decompiled with CFR 0.152.
 */
package andrew.powersuits.common;

import andrew.powersuits.common.AddonLogger;
import andrew.powersuits.common.ModularPowersuitsAddons;
import andrew.powersuits.modules.AutoFeederModule;
import andrew.powersuits.modules.ClockModule;
import andrew.powersuits.modules.CompassModule;
import andrew.powersuits.modules.EUReaderModule;
import andrew.powersuits.modules.FlintAndSteelModule;
import andrew.powersuits.modules.InPlaceAssemblerModule;
import andrew.powersuits.modules.KineticGeneratorModule;
import andrew.powersuits.modules.LeafBlowerModule;
import andrew.powersuits.modules.LightningModule;
import andrew.powersuits.modules.MagnetModule;
import andrew.powersuits.modules.MobRepulsorModule;
import andrew.powersuits.modules.OreScannerModule;
import andrew.powersuits.modules.SolarGeneratorModule;
import andrew.powersuits.modules.TEMultimeterModule;
import andrew.powersuits.modules.ThermalGeneratorModule;
import andrew.powersuits.modules.TorchPlacerModule;
import andrew.powersuits.modules.TreetapModule;
import andrew.powersuits.modules.WaterTankModule;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.common.ModularPowersuits;

public class AddonConfig
extends Config {
    public static String category = "Modular Powersuits Addons";
    public static aph torch;
    public static final String LANG_PATH = "/mods/PowersuitAddons/lang/";
    public static String[] languages;
    public static File configFolder;
    public static boolean useAdvancedOreScannerMessage;
    public static boolean useOldAutoFeeder;
    public static boolean useCheatyLeatherRecipe;
    public static boolean useHUDStuff;
    public static boolean useDebugMode;
    public static boolean use24hClock;

    public static void loadPowerModules() {
        List<IModularItem> ARMORONLY = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet);
        List<IModularItem> ALLITEMS = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet, ModularPowersuits.powerTool);
        List<IModularItem> HEADONLY = Arrays.asList(ModularPowersuits.powerArmorHead);
        List<IModularItem> TORSOONLY = Arrays.asList(ModularPowersuits.powerArmorTorso);
        List<IModularItem> LEGSONLY = Arrays.asList(ModularPowersuits.powerArmorLegs);
        List<IModularItem> FEETONLY = Arrays.asList(ModularPowersuits.powerArmorFeet);
        List<IModularItem> TOOLONLY = Arrays.asList(ModularPowersuits.powerTool);
        AddonConfig.addModule((IPowerModule)new InPlaceAssemblerModule(TOOLONLY));
        AddonConfig.addModule((IPowerModule)new KineticGeneratorModule(LEGSONLY));
        AddonConfig.addModule((IPowerModule)new SolarGeneratorModule(HEADONLY));
        AddonConfig.addModule((IPowerModule)new AutoFeederModule(HEADONLY));
        AddonConfig.addModule((IPowerModule)new MagnetModule(TORSOONLY));
        AddonConfig.addModule((IPowerModule)new OreScannerModule(TOOLONLY));
        AddonConfig.addModule((IPowerModule)new LeafBlowerModule(TOOLONLY));
        AddonConfig.addModule((IPowerModule)new ThermalGeneratorModule(TORSOONLY));
        AddonConfig.addModule((IPowerModule)new MobRepulsorModule(TORSOONLY));
        AddonConfig.addModule((IPowerModule)new FlintAndSteelModule(TOOLONLY));
        AddonConfig.addModule((IPowerModule)new ClockModule(HEADONLY));
        AddonConfig.addModule((IPowerModule)new CompassModule(HEADONLY));
        AddonConfig.addModule((IPowerModule)new LightningModule(TOOLONLY));
        AddonConfig.addModule((IPowerModule)new WaterTankModule(TORSOONLY));
        if (ModCompatability.isIndustrialCraftLoaded()) {
            AddonConfig.addModule((IPowerModule)new EUReaderModule(TOOLONLY));
            AddonConfig.addModule((IPowerModule)new TreetapModule(TOOLONLY));
        }
        if (ModCompatability.isThermalExpansionLoaded()) {
            AddonConfig.addModule((IPowerModule)new TEMultimeterModule(TOOLONLY));
        }
        try {
            torch = (aph)apa.r[apa.au.cz];
            AddonConfig.addModule((IPowerModule)new TorchPlacerModule(TOOLONLY));
        }
        catch (Exception e) {
            AddonLogger.logError("Some mod is overriding the default torch. MPSA Torch Placer Module is being disabled.");
        }
    }

    public static void setConfigFolderBase(File folder) {
        configFolder = new File(folder.getAbsolutePath() + "/machinemuse/andrew");
    }

    public static void extractLang(String[] langauges) {
        for (String lang : langauges) {
            InputStream inputStream = ModularPowersuitsAddons.INSTANCE.getClass().getResourceAsStream(LANG_PATH + lang + ".lang");
            try {
                int read;
                File file = new File(configFolder.getAbsolutePath() + "/lang/" + lang + ".lang");
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((read = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, read);
                }
                inputStream.close();
                outputStream.flush();
                ((OutputStream)outputStream).close();
            }
            catch (Exception e) {
                e.printStackTrace();
                AddonLogger.logError("Error initializing MPSA localizations!");
            }
        }
    }

    public static void loadLang() {
        File file = new File(configFolder.getAbsolutePath() + "/lang/");
        for (File langFile : file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lang");
            }
        })) {
            try {
                Properties langPack = new Properties();
                langPack.load(new FileInputStream(langFile));
                String lang = langFile.getName().replace(".lang", "");
                LanguageRegistry.instance().addStringLocalization(langPack, lang);
            }
            catch (Exception e) {
                e.printStackTrace();
                AddonLogger.logError("Error reading MPSA localizations!");
            }
        }
    }

    public static void loadOptions() {
        useAdvancedOreScannerMessage = AddonConfig.getConfig().get(category, "Use Detailed Ore Scanner Message", true).getBoolean(true);
        useOldAutoFeeder = AddonConfig.getConfig().get(category, "Use Old Auto Feeder Method", false).getBoolean(false);
        useCheatyLeatherRecipe = AddonConfig.getConfig().get(category, "Use Cheaty Leather Recipe (Requires Thermal Expansion)", true).getBoolean(true);
        useHUDStuff = AddonConfig.getConfig().get(category, "Use HUD for certain modules (Auto Feeder, Torch Placer, Compass, Clock, etc.", true).getBoolean(true);
        useDebugMode = AddonConfig.getConfig().get(category, "Use Debug mode. WARNING: WILL PROBABLY SPAM YOUR CONSOLE", false).getBoolean(false);
        use24hClock = AddonConfig.getConfig().get(category, "Use a 24h clock instead of 12h", false).getBoolean(false);
    }

    public static String getNetworkChannelName() {
        return "psa";
    }

    static {
        languages = new String[]{"en_US", "de_DE"};
    }
}

