/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.core.RecipeGradual;
import ic2.core.item.ItemGradual;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.src.ModLoader;

public class GradualRecipeHandler
extends TemplateRecipeHandler {
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ic2.gradual") && ((Object)((Object)this)).getClass() == GradualRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof RecipeGradual)) continue;
                this.arecipes.add(new CachedGradualRecipe((RecipeGradual)irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            CachedGradualRecipe recipe;
            if (!(irecipe instanceof RecipeGradual) || !(recipe = new CachedGradualRecipe((RecipeGradual)irecipe)).contains(recipe.ingredients, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "ic2.gradual", new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!(irecipe instanceof RecipeGradual) || !NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedGradualRecipe((RecipeGradual)irecipe));
        }
    }

    public List handleItemTooltip(GuiRecipe guiRecipe, ItemStack stack, List currenttip, int recipe) {
        CachedGradualRecipe crecipe = (CachedGradualRecipe)((Object)this.arecipes.get(recipe));
        if (guiRecipe.isMouseOver((PositionedStack)crecipe.ingredients.get(1), recipe) && crecipe.restoreAmount > 0 && crecipe.capacity > 0) {
            currenttip.add("\u00a77Can restore " + Math.round(100.0f * (float)crecipe.restoreAmount / (float)crecipe.capacity) + "%");
        }
        return currenttip;
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getRecipeName() {
        return "IC2 Recharging";
    }

    public String getGuiTexture() {
        return "/gui/crafting.png";
    }

    public class CachedGradualRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList ingredients;
        PositionedStack result;
        int restoreAmount;
        int capacity;

        public CachedGradualRecipe(RecipeGradual recipe) {
            super((TemplateRecipeHandler)GradualRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.func_77571_b(), 119, 24);
            this.ingredients = new ArrayList();
            ItemStack chargeMaterial = (ItemStack)ModLoader.getPrivateValue(RecipeGradual.class, (Object)recipe, (int)1);
            this.ingredients.add(new PositionedStack((Object)recipe.func_77571_b(), 25 + stackorder[0][0] * 18, 6 + stackorder[0][1] * 18));
            this.ingredients.add(new PositionedStack((Object)chargeMaterial, 25 + stackorder[1][0] * 18, 6 + stackorder[1][1] * 18));
            this.restoreAmount = 0;
            ItemGradual resultItem = (ItemGradual)recipe.func_77571_b().func_77973_b();
            this.capacity = resultItem.getMaxDamageEx();
            this.restoreAmount = recipe.amount;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(GradualRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

