/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotDischarge;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricMachine
extends TileEntityInventory
implements IEnergySink {
    public int energy = 0;
    public int maxEnergy;
    public int maxInput;
    public boolean addedToEnergyNet = false;
    public final InvSlotDischarge dischargeSlot;

    public TileEntityElectricMachine(int maxenergy, int tier, int oldDischargeIndex) {
        this.maxEnergy = maxenergy;
        switch (tier) {
            case 1: {
                this.maxInput = 32;
                break;
            }
            case 2: {
                this.maxInput = 128;
                break;
            }
            case 3: {
                this.maxInput = 512;
                break;
            }
            default: {
                this.maxInput = 2048;
            }
        }
        this.dischargeSlot = new InvSlotDischarge(this, oldDischargeIndex, tier);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energy = nbttagcompound.func_74762_e("energy");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        int amount;
        super.func_70316_g();
        if (this.energy < this.maxEnergy && (amount = this.dischargeSlot.discharge(this.maxEnergy - this.energy, true)) > 0) {
            this.energy += amount;
            this.func_70296_d();
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        int space = this.maxEnergy + (this.maxInput - 1) - this.energy;
        if (space > 0) {
            int transfer = Math.min(space, amount);
            amount -= transfer;
            this.energy += transfer;
        }
        return amount;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    public boolean isRedstonePowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setTier(int tier) {
        this.dischargeSlot.setTier(tier);
        switch (tier) {
            case 1: {
                this.maxInput = 32;
                break;
            }
            case 2: {
                this.maxInput = 128;
                break;
            }
            case 3: {
                this.maxInput = 512;
                break;
            }
            default: {
                this.maxInput = 2048;
            }
        }
    }
}

