/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.PlayerChunkViewerTracker;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerManager {
    public LinkedList playerViewers = new LinkedList();
    public HashMap ticketIDs = new HashMap();
    private int ticketID = 0;
    private int time = 0;
    private HashMap lastLoadedChunkMap = new HashMap();
    public LinkedList chunkChanges = new LinkedList();
    public LinkedList ticketChanges = new LinkedList();
    public LinkedList dimChanges = new LinkedList();
    public LinkedList logouts = new LinkedList();
    public LinkedList addViewers = new LinkedList();
    private static PlayerChunkViewerManager instance;

    public static PlayerChunkViewerManager instance() {
        if (instance == null) {
            instance = new PlayerChunkViewerManager();
        }
        return instance;
    }

    public void update() {
        ++this.time;
        for (String username : this.logouts) {
            Iterator iterator = this.playerViewers.iterator();
            while (iterator.hasNext()) {
                if (!((PlayerChunkViewerTracker)iterator.next()).owner.bS.equals(username)) continue;
                iterator.remove();
            }
        }
        for (String username : this.logouts) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.removePlayer(username);
            }
        }
        for (Object change : this.dimChanges) {
            if (!((DimensionChange)change).add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.loadDimension(((DimensionChange)change).world);
            }
        }
        for (Object change : this.chunkChanges) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.sendChunkChange((ChunkChange)change);
            }
        }
        for (Object change : this.ticketChanges) {
            if (this.ticketIDs.containsKey(((TicketChange)change).ticket)) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.sendTicketChange((TicketChange)change);
                }
                continue;
            }
            this.ticketIDs.put(((TicketChange)change).ticket, this.ticketID++);
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.addTicket(CommonUtils.getDimension((aab)((TicketChange)change).ticket.world), ((TicketChange)change).ticket);
            }
        }
        for (Object change : this.dimChanges) {
            if (((DimensionChange)change).add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.unloadDimension(CommonUtils.getDimension((aab)((DimensionChange)change).world));
            }
        }
        if (this.time % 10 == 0) {
            for (sq player : ServerUtils.getAllPlayers()) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.updatePlayer(player);
                }
            }
        }
        for (String username : this.addViewers) {
            jc player = ServerUtils.getPlayer((String)username);
            if (player == null) continue;
            if (this.playerViewers.isEmpty()) {
                this.updateChunkChangeMap();
            }
            this.playerViewers.add(new PlayerChunkViewerTracker((sq)player, this));
        }
        this.addViewers.clear();
        this.dimChanges.clear();
        this.logouts.clear();
        this.chunkChanges.clear();
        this.ticketChanges.clear();
    }

    private void updateChunkChangeMap() {
        iz[] izArray = DimensionManager.getWorlds();
        int n = izArray.length;
        int n2 = 0;
        while (n2 < n) {
            iz world = izArray[n2];
            HashSet<zu> allChunks = new HashSet<zu>();
            ArrayList loadedChunkCopy = new ArrayList(world.b.g);
            for (abw chunk : loadedChunkCopy) {
                allChunks.add(chunk.l());
            }
            this.lastLoadedChunkMap.put(CommonUtils.getDimension((aab)world), allChunks);
            ++n2;
        }
    }

    public void calculateChunkChanges(iz world) {
        if (this.playerViewers.isEmpty()) {
            return;
        }
        int dimension = CommonUtils.getDimension((aab)world);
        HashSet wasLoadedChunks = (HashSet)this.lastLoadedChunkMap.get(dimension);
        if (wasLoadedChunks == null) {
            wasLoadedChunks = new HashSet();
        }
        HashSet<zu> allChunks = new HashSet<zu>();
        ArrayList loadedChunkCopy = new ArrayList(world.b.g);
        for (abw chunk : loadedChunkCopy) {
            zu coord = chunk.l();
            allChunks.add(coord);
            if (wasLoadedChunks.remove(coord)) continue;
            this.chunkChanges.add(new ChunkChange(dimension, coord, true));
        }
        for (zu coord : wasLoadedChunks) {
            this.chunkChanges.add(new ChunkChange(dimension, coord, false));
        }
        this.lastLoadedChunkMap.put(dimension, allChunks);
    }

    public boolean isViewerOpen(String username) {
        for (PlayerChunkViewerTracker tracker : this.playerViewers) {
            if (!tracker.owner.bS.equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void serverShutdown() {
        instance = null;
    }

    public void closeViewer(String username) {
        Iterator iterator = this.playerViewers.iterator();
        while (iterator.hasNext()) {
            if (!((PlayerChunkViewerTracker)iterator.next()).owner.bS.equals(username)) continue;
            iterator.remove();
        }
    }

    public static class ChunkChange {
        public final zu chunk;
        public final boolean add;
        public final int dimension;

        public ChunkChange(int dimension, zu chunk, boolean add) {
            this.dimension = dimension;
            this.chunk = chunk;
            this.add = add;
        }
    }

    public static class DimensionChange {
        public final iz world;
        public final boolean add;

        public DimensionChange(iz world, boolean add) {
            this.world = world;
            this.add = add;
        }
    }

    public static class TicketChange {
        public final ForgeChunkManager.Ticket ticket;
        public final zu chunk;
        public final boolean force;
        public final int dimension;

        public TicketChange(ForgeChunkManager.Ticket ticket, zu chunk, boolean force) {
            this.ticket = ticket;
            this.dimension = CommonUtils.getDimension((aab)ticket.world);
            this.chunk = chunk;
            this.force = force;
        }
    }
}

